/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.scaffold;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class ScaffoldNodeBase<MoleculeType> {
    protected MoleculeType molecule;
    protected List<String> originSmilesList;
    protected List<String> nonVirtualOriginSmilesList;
    protected List<ScaffoldNodeBase<MoleculeType>> children;

    protected ScaffoldNodeBase(MoleculeType aMolecule) throws NullPointerException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'");
        this.molecule = aMolecule;
        this.children = new LinkedList<ScaffoldNodeBase<MoleculeType>>();
        this.originSmilesList = new ArrayList<String>();
        this.nonVirtualOriginSmilesList = new ArrayList<String>();
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public abstract boolean isOrphan();

    public abstract ScaffoldNodeBase<MoleculeType> addChild(MoleculeType var1) throws NullPointerException;

    public void addOriginSmiles(String aString) throws NullPointerException {
        Objects.requireNonNull(aString, "Given SMILES of the molecule is 'null'");
        if (!this.originSmilesList.contains(aString)) {
            this.originSmilesList.add(aString);
        }
    }

    public void addNonVirtualOriginSmiles(String aString) throws NullPointerException {
        Objects.requireNonNull(aString, "Given SMILES of the molecule is 'null'");
        if (!this.nonVirtualOriginSmilesList.contains(aString)) {
            this.nonVirtualOriginSmilesList.add(aString);
        }
    }

    public boolean hasNonVirtualOriginSmiles() {
        return !this.nonVirtualOriginSmilesList.isEmpty();
    }

    public abstract int getLevel();

    public MoleculeType getMolecule() {
        return this.molecule;
    }

    public void setMolecule(MoleculeType aMolecule) throws NullPointerException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'");
        this.molecule = aMolecule;
    }

    public List<ScaffoldNodeBase<MoleculeType>> getChildren() {
        return this.children;
    }

    public void setChildren(List<ScaffoldNodeBase<MoleculeType>> aChildren) throws NullPointerException {
        Objects.requireNonNull(aChildren, "Given ScaffoldNodeBase List is 'null'");
        this.children = aChildren;
    }

    public List<String> getOriginSmilesList() {
        return this.originSmilesList;
    }

    public List<String> getNonVirtualOriginSmilesList() {
        return this.nonVirtualOriginSmilesList;
    }

    public Integer getOriginCount() {
        return this.originSmilesList.size();
    }

    public Integer getNonVirtualOriginCount() {
        return this.nonVirtualOriginSmilesList.size();
    }

    public void setOriginSmilesList(List<String> aOriginSmilesList) throws NullPointerException {
        Objects.requireNonNull(aOriginSmilesList, "Given SMILES of the molecule List is 'null'");
        this.originSmilesList = aOriginSmilesList;
    }

    public void setNonVirtualOriginSmilesList(List<String> aNonVirtualOriginSmilesList) throws NullPointerException {
        Objects.requireNonNull(aNonVirtualOriginSmilesList, "Given SMILES of the molecule List is 'null'");
        this.nonVirtualOriginSmilesList = aNonVirtualOriginSmilesList;
    }
}

