/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.scaffold;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.scaffold.ScaffoldGenerator;
import org.openscience.cdk.tools.scaffold.ScaffoldNodeBase;

public abstract class ScaffoldNodeCollectionBase {
    protected static final int NODE_MAPS_INIT_CAPACITY = 300;
    protected static final float NODE_MAPS_LOAD_FACTOR = 0.6f;
    protected HashMap<Integer, ScaffoldNodeBase> nodeMap = new HashMap(300, 0.6f);
    protected HashMap<ScaffoldNodeBase, Integer> reverseNodeMap = new HashMap(300, 0.6f);
    protected HashMap<String, ScaffoldNodeBase> smilesMap = new HashMap(300, 0.6f);
    protected HashMap<Integer, HashSet<ScaffoldNodeBase>> levelMap = new HashMap(300, 0.6f);
    protected SmilesGenerator smilesGenerator;
    protected int nodeCounter;

    protected ScaffoldNodeCollectionBase(SmilesGenerator aSmilesGenerator) {
        this.smilesGenerator = aSmilesGenerator;
        this.nodeCounter = 0;
    }

    protected ScaffoldNodeCollectionBase() {
        this(ScaffoldGenerator.SMILES_GENERATOR_SETTING_DEFAULT);
    }

    public abstract void addNode(ScaffoldNodeBase var1) throws CDKException, IllegalArgumentException, NullPointerException;

    public abstract void removeNode(ScaffoldNodeBase var1) throws CDKException, IllegalArgumentException, NullPointerException;

    public boolean containsMolecule(IAtomContainer aMolecule) throws CDKException, NullPointerException {
        Objects.requireNonNull(aMolecule, "Given atom container is 'null'");
        String tmpSmiles = this.smilesGenerator.create(aMolecule);
        return this.smilesMap.containsKey(tmpSmiles);
    }

    public boolean containsNode(int aNumber) {
        return this.nodeMap.containsKey(aNumber);
    }

    public ScaffoldNodeBase getNode(IAtomContainer aMolecule) throws CDKException, IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(aMolecule, "Given atom container is 'null'");
        if (!this.containsMolecule(aMolecule)) {
            throw new IllegalArgumentException("Molecule is not in ScaffoldCollection");
        }
        return this.smilesMap.get(this.smilesGenerator.create(aMolecule));
    }

    public int getMaxLevel() {
        ArrayList<Integer> tmpLevelList = new ArrayList<Integer>();
        tmpLevelList.addAll(this.levelMap.keySet());
        return (Integer)Collections.max(tmpLevelList);
    }

    public List<ScaffoldNodeBase> getAllNodesOnLevel(int aLevel) throws IllegalArgumentException {
        if (this.getMaxLevel() >= aLevel) {
            ArrayList<ScaffoldNodeBase> tmpList = new ArrayList<ScaffoldNodeBase>((Collection)this.levelMap.get(aLevel));
            return tmpList;
        }
        throw new IllegalArgumentException("Level does not exist: " + aLevel);
    }

    public abstract Integer[][] getMatrix() throws IllegalStateException;

    public Map<Integer, ScaffoldNodeBase> getMatrixNodes() {
        return this.nodeMap;
    }

    public ScaffoldNodeBase getMatrixNode(int aNumber) {
        return this.nodeMap.get(aNumber);
    }

    public List<ScaffoldNodeBase> getAllNodes() {
        ArrayList<ScaffoldNodeBase> tmpList = new ArrayList<ScaffoldNodeBase>();
        tmpList.addAll(this.nodeMap.values());
        return tmpList;
    }

    public List<Integer> getMatrixNodesNumbers() {
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        tmpList.addAll(this.nodeMap.keySet());
        return tmpList;
    }

    protected void addNodeToCollections(ScaffoldNodeBase aNode) throws CDKException {
        this.nodeMap.put(this.nodeCounter, aNode);
        this.reverseNodeMap.put(aNode, this.nodeCounter);
        IAtomContainer tmpMolecule = (IAtomContainer)aNode.getMolecule();
        String tmpSmiles = this.smilesGenerator.create(tmpMolecule);
        this.smilesMap.put(tmpSmiles, aNode);
        int tmpLevel = aNode.getLevel();
        this.levelMap.computeIfAbsent(tmpLevel, k -> new HashSet(50, 0.75f));
        this.levelMap.get(tmpLevel).add(aNode);
    }
}

