/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.scaffold;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.scaffold.ScaffoldNodeBase;
import org.openscience.cdk.tools.scaffold.ScaffoldNodeCollectionBase;
import org.openscience.cdk.tools.scaffold.TreeNode;

public class ScaffoldTree
extends ScaffoldNodeCollectionBase {
    public ScaffoldTree(SmilesGenerator aSmilesGenerator) {
        super(aSmilesGenerator);
    }

    public ScaffoldTree() {
    }

    @Override
    public void addNode(ScaffoldNodeBase aNode) throws CDKException, IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(aNode, "Given TreeNode is 'null'");
        if (!(aNode instanceof TreeNode)) {
            throw new IllegalArgumentException("Node can not be added to ScaffoldTree. Parameter must be a TreeNode");
        }
        this.addNodeToCollections(aNode);
        int tmpNewNodeLevel = aNode.getLevel();
        TreeNode tmpIterNode = (TreeNode)aNode;
        for (int tmpCount = 0; tmpCount < tmpNewNodeLevel; ++tmpCount) {
            TreeNode tmpNextNode = tmpIterNode.getParent();
            for (String tmpString : tmpIterNode.getOriginSmilesList()) {
                tmpNextNode.addOriginSmiles(tmpString);
            }
            tmpIterNode = tmpNextNode;
        }
        ++this.nodeCounter;
    }

    @Override
    public void removeNode(ScaffoldNodeBase aNode) throws CDKException, IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(aNode, "Given ScaffoldNode is 'null'");
        if (!(aNode instanceof TreeNode)) {
            throw new IllegalArgumentException("Node can not be removed from the ScaffoldTree. Parameter must be a TreeNode.");
        }
        if (!this.reverseNodeMap.containsKey(aNode)) {
            throw new IllegalArgumentException("Node is not in Scaffold");
        }
        int tmpNumberInNodeMap = (Integer)this.reverseNodeMap.get(aNode);
        this.nodeMap.remove(tmpNumberInNodeMap);
        this.reverseNodeMap.remove(aNode);
        String tmpSmiles = this.smilesGenerator.create((IAtomContainer)aNode.getMolecule());
        this.smilesMap.remove(tmpSmiles, aNode);
        HashSet tmpNodesOnLevelSet = (HashSet)this.levelMap.get(aNode.getLevel());
        tmpNodesOnLevelSet.remove(aNode);
    }

    public boolean isValid() {
        return this.hasOneSingleRootNode() && this.isConnected();
    }

    public boolean mergeTree(ScaffoldTree aScaffoldTree) throws CDKException, NullPointerException {
        Objects.requireNonNull(aScaffoldTree, "Given ScaffoldTree is 'null'");
        if (this.getAllNodes().isEmpty()) {
            for (ScaffoldNodeBase tmpBaseNode : aScaffoldTree.getAllNodes()) {
                TreeNode tmpNode = (TreeNode)tmpBaseNode;
                this.addNode(tmpNode);
            }
            return true;
        }
        for (int i = 0; i <= aScaffoldTree.getMaxLevel(); ++i) {
            boolean tmpAreTreesOverlapping = false;
            for (ScaffoldNodeBase tmpOldTreeNodeBase : this.getAllNodesOnLevel(i)) {
                TreeNode tmpOldTreeNode = (TreeNode)tmpOldTreeNodeBase;
                for (ScaffoldNodeBase tmpNewTreeNodeBase : aScaffoldTree.getAllNodesOnLevel(i)) {
                    String tmpNewSmiles;
                    TreeNode tmpNewTreeNode = (TreeNode)tmpNewTreeNodeBase;
                    String tmpOldSmiles = this.smilesGenerator.create((IAtomContainer)tmpOldTreeNode.getMolecule());
                    if (!tmpOldSmiles.equals(tmpNewSmiles = this.smilesGenerator.create((IAtomContainer)tmpNewTreeNode.getMolecule()))) continue;
                    for (String string : tmpNewTreeNode.getOriginSmilesList()) {
                        tmpOldTreeNode.addOriginSmiles(string);
                    }
                    for (String string : tmpNewTreeNode.getNonVirtualOriginSmilesList()) {
                        tmpOldTreeNode.addNonVirtualOriginSmiles(string);
                    }
                    tmpAreTreesOverlapping = true;
                    for (Object object : tmpNewTreeNode.getChildren()) {
                        TreeNode tmpNewChildNode = (TreeNode)object;
                        IAtomContainer tmpNewChildMolecule = (IAtomContainer)tmpNewChildNode.getMolecule();
                        if (this.containsMolecule(tmpNewChildMolecule)) continue;
                        int tmpChildrenNumber = tmpOldTreeNode.getChildren().size();
                        tmpOldTreeNode.addChild(tmpNewChildMolecule);
                        TreeNode tmpAddedNode = (TreeNode)tmpOldTreeNode.getChildren().get(tmpChildrenNumber);
                        this.addNode(tmpAddedNode);
                    }
                }
            }
            if (tmpAreTreesOverlapping) continue;
            if (i != 0) break;
            return false;
        }
        return true;
    }

    @Override
    public Integer[][] getMatrix() throws IllegalStateException {
        int tmpSize = this.nodeMap.size();
        Integer[][] tmpMatrix = new Integer[tmpSize][tmpSize];
        if (!this.isValid()) {
            throw new IllegalStateException("Tree is not valid");
        }
        for (int tmpRow = 0; tmpRow < tmpMatrix.length; ++tmpRow) {
            Arrays.fill(tmpMatrix[tmpRow], (Object)0);
        }
        int tmpCounter = 0;
        for (ScaffoldNodeBase tmpNodeBase : this.nodeMap.values()) {
            TreeNode tmpNode = (TreeNode)tmpNodeBase;
            if (tmpNode.getParent() != null) {
                tmpMatrix[tmpCounter][this.getMatrixNodesNumbers().indexOf(this.reverseNodeMap.get(tmpNode.getParent()))] = 1;
                tmpMatrix[this.getMatrixNodesNumbers().indexOf(this.reverseNodeMap.get(tmpNode.getParent()))][tmpCounter] = 1;
            }
            ++tmpCounter;
        }
        return tmpMatrix;
    }

    public TreeNode getRoot() throws IllegalStateException {
        if (!this.hasOneSingleRootNode()) {
            throw new IllegalStateException("Tree has no clear root");
        }
        for (ScaffoldNodeBase tmpNodeBase : this.nodeMap.values()) {
            TreeNode tmpNode = (TreeNode)tmpNodeBase;
            if (this.reverseNodeMap.containsKey(tmpNode.getParent())) continue;
            return tmpNode;
        }
        throw new IllegalStateException("Tree has no clear root");
    }

    private boolean isConnected() {
        int tmpCounter = 0;
        boolean tmpIsTreeConnected = true;
        for (ScaffoldNodeBase tmpNodeBase : this.nodeMap.values()) {
            TreeNode tmpNode = (TreeNode)tmpNodeBase;
            if (tmpCounter == 0) {
                ++tmpCounter;
                continue;
            }
            if (!this.reverseNodeMap.containsKey(tmpNode.getParent())) {
                tmpIsTreeConnected = false;
            }
            ++tmpCounter;
        }
        return tmpIsTreeConnected;
    }

    private boolean hasOneSingleRootNode() {
        int tmpRootCounter = 0;
        for (ScaffoldNodeBase tmpNodeBase : this.nodeMap.values()) {
            TreeNode tmpNode = (TreeNode)tmpNodeBase;
            if (!this.reverseNodeMap.containsKey(tmpNode.getParent())) {
                ++tmpRootCounter;
            }
            if (tmpRootCounter >= 1) continue;
            return false;
        }
        return tmpRootCounter == 1;
    }
}

