/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.scaffold;

import java.util.Objects;
import org.openscience.cdk.tools.scaffold.ScaffoldNodeBase;

public class TreeNode<MoleculeType>
extends ScaffoldNodeBase<MoleculeType> {
    private TreeNode<MoleculeType> parent;

    public TreeNode(MoleculeType aMolecule) {
        super(aMolecule);
    }

    @Override
    public boolean isOrphan() {
        return this.parent == null;
    }

    @Override
    public TreeNode<MoleculeType> addChild(MoleculeType aMolecule) throws NullPointerException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'");
        TreeNode<MoleculeType> tmpChildNode = new TreeNode<MoleculeType>(aMolecule);
        this.children.add(tmpChildNode);
        tmpChildNode.parent = this;
        return tmpChildNode;
    }

    @Override
    public int getLevel() {
        if (this.isOrphan()) {
            return 0;
        }
        return this.parent.getLevel() + 1;
    }

    public TreeNode<MoleculeType> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<MoleculeType> aParent) throws NullPointerException {
        Objects.requireNonNull(aParent, "Given TreeNode is 'null'");
        this.parent = aParent;
    }
}

