/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers.smarts;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;

public class ImplicitHCountAtom
extends SMARTSAtom {
    private static final long serialVersionUID = 6752937431492584928L;
    private final int hcount;

    public ImplicitHCountAtom(int hcount, IChemObjectBuilder builder) {
        super(builder);
        this.hcount = hcount;
        this.setImplicitHydrogenCount(hcount);
    }

    @Override
    public boolean matches(IAtom atom) {
        if (atom.getImplicitHydrogenCount() == null) {
            return false;
        }
        return atom.getImplicitHydrogenCount() == this.hcount;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("ImplicitHCountAtom(");
        s.append(((Object)((Object)this)).hashCode()).append(", ");
        s.append("IH:" + this.hcount);
        s.append(')');
        return s.toString();
    }
}

