/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles.smarts;

import com.google.common.base.Predicate;
import java.io.IOException;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.ComponentGrouping;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.SmartsStereoMatch;
import org.openscience.cdk.isomorphism.matchers.smarts.SmartsMatchers;
import org.openscience.cdk.smiles.smarts.SmartsAtomAtomMapFilter;
import org.openscience.cdk.smiles.smarts.parser.SMARTSParser;
import org.openscience.cdk.tools.LoggingToolFactory;

public final class SmartsPattern
extends Pattern {
    private final IAtomContainer query;
    private final Pattern pattern;
    private final boolean ringInfo;
    private final boolean hasStereo;
    private final boolean hasCompGrp;
    private final boolean hasRxnMap;
    private final Aromaticity arom = new Aromaticity(ElectronDonation.daylight(), Cycles.or((CycleFinder)Cycles.all(), (CycleFinder)Cycles.relevant()));

    private SmartsPattern(String smarts, IChemObjectBuilder builder) throws IOException {
        try {
            this.query = SMARTSParser.parse(smarts, builder);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.pattern = Pattern.findSubstructure((IAtomContainer)this.query);
        this.ringInfo = SmartsPattern.ringSizeOrNumber(smarts);
        this.hasStereo = this.query.stereoElements().iterator().hasNext();
        this.hasCompGrp = this.query.getProperty((Object)"COMPONENT.GROUPING") != null;
        this.hasRxnMap = smarts.contains(":");
    }

    public int[] match(IAtomContainer container) {
        return this.matchAll(container).first();
    }

    public Mappings matchAll(IAtomContainer target) {
        SmartsMatchers.prepare(target, this.ringInfo);
        try {
            this.arom.apply(target);
        }
        catch (CDKException e) {
            LoggingToolFactory.createLoggingTool(((Object)((Object)this)).getClass()).error((Object)e);
        }
        Mappings mappings = this.pattern.matchAll(target);
        if (this.hasStereo) {
            mappings = mappings.filter((Predicate)new SmartsStereoMatch(this.query, target));
        }
        if (this.hasCompGrp) {
            mappings = mappings.filter((Predicate)new ComponentGrouping(this.query, target));
        }
        if (this.hasRxnMap) {
            mappings = mappings.filter((Predicate)new SmartsAtomAtomMapFilter(this.query, target));
        }
        return mappings;
    }

    public static SmartsPattern create(String smarts, IChemObjectBuilder builder) throws IOException {
        return new SmartsPattern(smarts, builder);
    }

    public static SmartsPattern create(String smarts) throws IOException {
        return new SmartsPattern(smarts, null);
    }

    static boolean ringSizeOrNumber(String smarts) {
        int end = smarts.length() - 1;
        for (int i = 0; i <= end; ++i) {
            char c = smarts.charAt(i);
            if ((c == 'r' || c == 'R') && i < end && Character.isDigit(smarts.charAt(i + 1))) {
                return true;
            }
            if (c != '!' || i >= end || smarts.charAt(i + 1) != 'R') continue;
            return true;
        }
        return false;
    }
}

