/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smarts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.smarts.CxSmartsState;

final class CxSmartsParser {
    private static final char COMMA_SEPARATOR = ',';
    private static final char DOT_SEPARATOR = '.';

    private CxSmartsParser() {
    }

    private static boolean processAtomLabels(CharIter iter, Map<Integer, String> dest) {
        int atomIdx = 0;
        while (iter.hasNext()) {
            while (iter.nextIf(';')) {
                ++atomIdx;
            }
            char c = iter.next();
            if (c == '$') {
                iter.nextIf(',');
                return true;
            }
            iter.pos--;
            int beg = iter.pos;
            while (iter.hasNext()) {
                if (iter.pos == beg && iter.curr() == '_' && iter.peek() == 'R') {
                    ++beg;
                }
                if (iter.curr() == '&') {
                    int rollback = iter.pos;
                    if (iter.nextIf('&') && iter.nextIf('#') && iter.nextIfDigit()) {
                        while (iter.nextIfDigit()) {
                        }
                        if (iter.nextIf(';')) continue;
                        iter.pos = rollback;
                        continue;
                    }
                    iter.pos = rollback;
                    continue;
                }
                if (iter.curr() == ';' || iter.curr() == '$') break;
                iter.next();
            }
            dest.put(atomIdx, CxSmartsParser.unescape(iter.substr(beg, iter.pos)));
            ++atomIdx;
            if (iter.nextIf('$')) {
                iter.nextIf(',');
                return true;
            }
            if (iter.nextIf(';')) continue;
            return false;
        }
        return false;
    }

    private static double readDouble(CharIter iter) {
        char c;
        int sign = 1;
        if (iter.nextIf('-')) {
            sign = -1;
        } else if (iter.nextIf('+')) {
            sign = 1;
        }
        double fracPart = 0.0;
        int divisor = 1;
        double intPart = CxSmartsParser.processUnsignedInt(iter);
        if (intPart < 0.0) {
            intPart = 0.0;
        }
        iter.nextIf('.');
        while (iter.hasNext() && CxSmartsParser.isDigit(c = iter.curr())) {
            fracPart *= 10.0;
            fracPart += (double)(c - 48);
            divisor *= 10;
            iter.next();
        }
        return (double)sign * (intPart + fracPart / (double)divisor);
    }

    private static boolean processCoords(CharIter iter, CxSmartsState state) {
        if (state.atomCoords == null) {
            state.atomCoords = new ArrayList<double[]>();
        }
        while (iter.hasNext()) {
            if (iter.curr() == ')') {
                iter.next();
                iter.nextIf(',');
                return true;
            }
            double x = CxSmartsParser.readDouble(iter);
            if (!iter.nextIf(',')) {
                return false;
            }
            double y = CxSmartsParser.readDouble(iter);
            if (!iter.nextIf(',')) {
                return false;
            }
            double z = CxSmartsParser.readDouble(iter);
            iter.nextIf(';');
            state.coordFlag = state.coordFlag || z != 0.0;
            state.atomCoords.add(new double[]{x, y, z});
        }
        return false;
    }

    private static boolean processFragmentGrouping(CharIter iter, CxSmartsState state) {
        if (state.fragGroups == null) {
            state.fragGroups = new ArrayList<List<Integer>>();
        }
        ArrayList<Integer> dest = new ArrayList<Integer>();
        while (iter.hasNext()) {
            dest.clear();
            if (!CxSmartsParser.processIntList(iter, '.', dest)) {
                return false;
            }
            iter.nextIf(',');
            if (dest.isEmpty()) {
                return true;
            }
            state.fragGroups.add(new ArrayList<Integer>(dest));
        }
        return false;
    }

    private static boolean isSgroupDelim(char c) {
        return c == ':' || c == ',' || c == '|';
    }

    private static boolean processDataSgroups(CharIter iter, CxSmartsState state) {
        ArrayList<Integer> atomset;
        if (state.mysgroups == null) {
            state.mysgroups = new ArrayList<CxSmartsState.CxSgroup>(4);
        }
        if (!CxSmartsParser.processIntList(iter, ',', atomset = new ArrayList<Integer>())) {
            return false;
        }
        if (!iter.nextIf(':')) {
            return false;
        }
        int beg = iter.pos;
        while (iter.hasNext() && !CxSmartsParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String field = CxSmartsParser.unescape(iter.substr(beg, iter.pos));
        if (field.startsWith("cdk.")) {
            field = field.replace("cdk.", "cdk:");
        }
        if (!iter.nextIf(':')) {
            return false;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmartsParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String value = CxSmartsParser.unescape(iter.substr(beg, iter.pos));
        if (!iter.nextIf(':')) {
            state.mysgroups.add(new CxSmartsState.CxDataSgroup(atomset, field, value, "", "", ""));
            return true;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmartsParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String operator = CxSmartsParser.unescape(iter.substr(beg, iter.pos));
        if (!iter.nextIf(':')) {
            state.mysgroups.add(new CxSmartsState.CxDataSgroup(atomset, field, value, operator, "", ""));
            return true;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmartsParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String unit = CxSmartsParser.unescape(iter.substr(beg, iter.pos));
        if (!iter.nextIf(':')) {
            state.mysgroups.add(new CxSmartsState.CxDataSgroup(atomset, field, value, operator, unit, ""));
            return true;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmartsParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String tag = CxSmartsParser.unescape(iter.substr(beg, iter.pos));
        state.mysgroups.add(new CxSmartsState.CxDataSgroup(atomset, field, value, operator, unit, tag));
        return true;
    }

    private static boolean processPolymerSgroups(CharIter iter, CxSmartsState state) {
        if (state.mysgroups == null) {
            state.mysgroups = new ArrayList<CxSmartsState.CxSgroup>();
        }
        int beg = iter.pos;
        while (iter.hasNext() && !CxSmartsParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String keyword = iter.substr(beg, iter.pos);
        if (!iter.nextIf(':')) {
            return false;
        }
        ArrayList<Integer> atomset = new ArrayList<Integer>();
        if (!CxSmartsParser.processIntList(iter, ',', atomset)) {
            return false;
        }
        if (!iter.nextIf(':')) {
            return false;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmartsParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String subscript = CxSmartsParser.unescape(iter.substr(beg, iter.pos));
        if (subscript.isEmpty()) {
            subscript = keyword;
        }
        if (!iter.nextIf(':')) {
            return false;
        }
        beg = iter.pos;
        while (iter.hasNext() && !CxSmartsParser.isSgroupDelim(iter.curr())) {
            iter.next();
        }
        String supscript = CxSmartsParser.unescape(iter.substr(beg, iter.pos));
        if (!(!supscript.isEmpty() || keyword.equals("c") || keyword.equals("mix") || keyword.equals("f") || keyword.equals("mod"))) {
            supscript = "eu";
        }
        if (iter.nextIf(',') || iter.curr() == '|') {
            state.mysgroups.add(new CxSmartsState.CxPolymerSgroup(keyword, atomset, subscript, supscript));
            return true;
        }
        return false;
    }

    private static boolean processIntListMap(Map<Integer, List<Integer>> map, CharIter iter) {
        while (iter.hasNext()) {
            if (CxSmartsParser.isDigit(iter.curr())) {
                int beg = CxSmartsParser.processUnsignedInt(iter);
                if (!iter.nextIf(':')) {
                    return false;
                }
                ArrayList<Integer> endpoints = new ArrayList<Integer>(6);
                if (!CxSmartsParser.processIntList(iter, '.', endpoints)) {
                    return false;
                }
                iter.nextIf(',');
                map.put(beg, endpoints);
                continue;
            }
            return true;
        }
        return false;
    }

    private static boolean processPositionalVariation(CharIter iter, CxSmartsState state) {
        if (state.positionVar == null) {
            state.positionVar = new TreeMap<Integer, List<Integer>>();
        }
        return CxSmartsParser.processIntListMap(state.positionVar, iter);
    }

    private static boolean processLigandOrdering(CharIter iter, CxSmartsState state) {
        if (state.ligandOrdering == null) {
            state.ligandOrdering = new TreeMap<Integer, List<Integer>>();
        }
        return CxSmartsParser.processIntListMap(state.ligandOrdering, iter);
    }

    private static boolean processRadicals(CharIter iter, CxSmartsState state) {
        CxSmartsState.Radical rad;
        if (state.atomRads == null) {
            state.atomRads = new TreeMap<Integer, CxSmartsState.Radical>();
        }
        switch (iter.next()) {
            case '1': {
                rad = CxSmartsState.Radical.Monovalent;
                break;
            }
            case '2': {
                rad = CxSmartsState.Radical.Divalent;
                break;
            }
            case '3': {
                rad = CxSmartsState.Radical.DivalentSinglet;
                break;
            }
            case '4': {
                rad = CxSmartsState.Radical.DivalentTriplet;
                break;
            }
            case '5': {
                rad = CxSmartsState.Radical.Trivalent;
                break;
            }
            case '6': {
                rad = CxSmartsState.Radical.TrivalentDoublet;
                break;
            }
            case '7': {
                rad = CxSmartsState.Radical.TrivalentQuartet;
                break;
            }
            default: {
                return false;
            }
        }
        if (!iter.nextIf(':')) {
            return false;
        }
        ArrayList<Integer> dest = new ArrayList<Integer>(4);
        if (!CxSmartsParser.processIntList(iter, ',', dest)) {
            return false;
        }
        for (Integer atomidx : dest) {
            state.atomRads.put(atomidx, rad);
        }
        return true;
    }

    static int processCx(String str, CxSmartsState state) {
        CharIter iter = new CharIter(str);
        if (!iter.nextIf('|')) {
            return -1;
        }
        block17: while (iter.hasNext()) {
            switch (iter.next()) {
                case '$': {
                    TreeMap<Integer, String> dest;
                    if (iter.nextIf("_AV:")) {
                        state.atomValues = new TreeMap<Integer, String>();
                        dest = state.atomValues;
                    } else {
                        state.atomLabels = new TreeMap<Integer, String>();
                        dest = state.atomLabels;
                    }
                    if (CxSmartsParser.processAtomLabels(iter, dest)) continue block17;
                    return -1;
                }
                case '(': {
                    if (CxSmartsParser.processCoords(iter, state)) continue block17;
                    return -1;
                }
                case 'c': 
                case 't': {
                    if (!(iter.nextIf(':') ? !CxSmartsParser.skipIntList(iter, ',') : iter.nextIf("tu:") && !CxSmartsParser.skipIntList(iter, ','))) continue block17;
                    return -1;
                }
                case '&': {
                    if (CxSmartsParser.processStereoGrps(state, iter, 65536)) continue block17;
                    return -1;
                }
                case 'o': {
                    if (CxSmartsParser.processStereoGrps(state, iter, 131072)) continue block17;
                    return -1;
                }
                case 'a': {
                    if (CxSmartsParser.processStereoGrps(state, iter, 0)) continue block17;
                    return -1;
                }
                case 'r': {
                    if (iter.nextIf(':')) {
                        state.racemicFrags = new ArrayList<Integer>();
                        if (CxSmartsParser.processIntList(iter, ',', state.racemicFrags)) continue block17;
                        return -1;
                    }
                    state.racemic = true;
                    if (iter.nextIf(',') || iter.curr() == '|') continue block17;
                    return -1;
                }
                case 'l': {
                    if (!iter.nextIf("p:")) {
                        return -1;
                    }
                    if (CxSmartsParser.skipIntMap(iter)) continue block17;
                    return -1;
                }
                case 'f': {
                    if (!iter.nextIf(':')) {
                        return -1;
                    }
                    if (CxSmartsParser.processFragmentGrouping(iter, state)) continue block17;
                    return -1;
                }
                case 'S': {
                    if (iter.nextIf("g:")) {
                        if (CxSmartsParser.processPolymerSgroups(iter, state)) continue block17;
                        return -1;
                    }
                    if (iter.nextIf("gD:")) {
                        if (!CxSmartsParser.processDataSgroups(iter, state)) {
                            return -1;
                        }
                        if (!iter.nextIf(',')) continue block17;
                        continue block17;
                    }
                    if (iter.nextIf("gH:")) {
                        if (CxSmartsParser.processSgroupsHierarchy(iter, state)) continue block17;
                        return -1;
                    }
                    return -1;
                }
                case 'm': {
                    if (!iter.nextIf(':')) {
                        return -1;
                    }
                    if (CxSmartsParser.processPositionalVariation(iter, state)) continue block17;
                    return -1;
                }
                case '^': {
                    if (CxSmartsParser.processRadicals(iter, state)) continue block17;
                    return -1;
                }
                case 'C': 
                case 'H': {
                    if (!iter.nextIf(':')) {
                        return -1;
                    }
                    while (iter.hasNext() && CxSmartsParser.isDigit(iter.curr())) {
                        if (!CxSmartsParser.skipIntList(iter, '.')) {
                            return -1;
                        }
                        iter.nextIf(',');
                    }
                    continue block17;
                }
                case '|': {
                    if (!iter.nextIf(' ')) {
                        iter.nextIf('\t');
                    }
                    return iter.pos;
                }
                case 'L': {
                    if (iter.nextIf('O')) {
                        if (!iter.nextIf(':')) {
                            return -1;
                        }
                        if (CxSmartsParser.processLigandOrdering(iter, state)) continue block17;
                        return -1;
                    }
                    return -1;
                }
            }
            return -1;
        }
        return -1;
    }

    private static boolean processStereoGrps(CxSmartsState state, CharIter iter, int grp) {
        if (grp != 0) {
            int num = CxSmartsParser.processUnsignedInt(iter);
            if (num < 0) {
                return false;
            }
            grp |= num << 18;
        }
        if (!iter.nextIf(':')) {
            return false;
        }
        ArrayList<Integer> idxs = new ArrayList<Integer>();
        if (!CxSmartsParser.processIntList(iter, ',', idxs)) {
            return false;
        }
        if (state.stereoGrps == null) {
            state.stereoGrps = new HashMap<Integer, Integer>();
        }
        for (Integer idx : idxs) {
            state.stereoGrps.put(idx, grp);
        }
        return true;
    }

    private static boolean processSgroupsHierarchy(CharIter iter, CxSmartsState state) {
        int nsgroups = 0;
        if (state.mysgroups != null) {
            nsgroups += state.mysgroups.size();
        }
        if (nsgroups == 0) {
            return false;
        }
        do {
            int parent;
            if ((parent = CxSmartsParser.processUnsignedInt(iter)) < 0) {
                return false;
            }
            if (!iter.nextIf(':')) {
                return false;
            }
            ArrayList<Integer> children = new ArrayList<Integer>();
            CxSmartsParser.processIntList(iter, '.', children);
            if (parent < state.mysgroups.size()) {
                for (Integer child : children) {
                    if (child < nsgroups) {
                        state.mysgroups.get((int)parent).children.add(state.mysgroups.get(child));
                        continue;
                    }
                    return false;
                }
            } else {
                return false;
            }
            if (iter.curr() == '|') {
                return true;
            }
            if (iter.nextIf(',')) continue;
            return false;
        } while (CxSmartsParser.isDigit(iter.curr()));
        return true;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean skipIntList(CharIter iter, char sep) {
        while (iter.hasNext()) {
            char c = iter.curr();
            if (CxSmartsParser.isDigit(c) || c == sep) {
                iter.next();
                continue;
            }
            return true;
        }
        return false;
    }

    private static boolean skipIntMap(CharIter iter) {
        while (iter.hasNext()) {
            char c = iter.curr();
            if (CxSmartsParser.isDigit(c) || c == ',' || c == ':') {
                iter.next();
                continue;
            }
            return true;
        }
        return false;
    }

    private static int processUnsignedInt(CharIter iter) {
        if (!iter.hasNext()) {
            return -1;
        }
        char c = iter.curr();
        if (!CxSmartsParser.isDigit(c)) {
            return -1;
        }
        int res = c - 48;
        iter.next();
        while (iter.hasNext() && CxSmartsParser.isDigit(c = iter.curr())) {
            res = res * 10 + c - 48;
            iter.next();
        }
        return res;
    }

    private static boolean processIntList(CharIter iter, char sep, List<Integer> dest) {
        while (iter.hasNext()) {
            char c = iter.curr();
            if (CxSmartsParser.isDigit(c)) {
                int r = CxSmartsParser.processUnsignedInt(iter);
                if (r < 0) {
                    return false;
                }
                iter.nextIf(sep);
                dest.add(r);
                continue;
            }
            return true;
        }
        return false;
    }

    static String unescape(String str) {
        int dst = 0;
        int src = 0;
        char[] chars = str.toCharArray();
        int len = chars.length;
        while (src < chars.length) {
            if (src + 3 < len && chars[src] == '&' && chars[src + 1] == '#' && CxSmartsParser.isDigit(chars[src + 2])) {
                int tmp;
                int code = 0;
                for (tmp = src + 2; tmp < len && CxSmartsParser.isDigit(chars[tmp]); ++tmp) {
                    code *= 10;
                    code += chars[tmp] - 48;
                }
                if (tmp < len && chars[tmp] == ';') {
                    src = tmp + 1;
                    chars[dst++] = (char)code;
                    continue;
                }
            }
            chars[dst++] = chars[src++];
        }
        return new String(chars, 0, dst);
    }

    private static final class CharIter {
        private final String str;
        private final int len;
        private int pos = 0;

        CharIter(String str) {
            this.str = str;
            this.len = str.length();
        }

        boolean nextIf(char c) {
            if (!this.hasNext() || this.str.charAt(this.pos) != c) {
                return false;
            }
            ++this.pos;
            return true;
        }

        boolean nextIfDigit() {
            if (!this.hasNext() || !CxSmartsParser.isDigit(this.str.charAt(this.pos))) {
                return false;
            }
            ++this.pos;
            return true;
        }

        boolean nextIf(String prefix) {
            boolean res = this.str.startsWith(prefix, this.pos);
            if (res) {
                this.pos += prefix.length();
            }
            return res;
        }

        boolean hasNext() {
            return this.pos < this.len;
        }

        char curr() {
            return this.str.charAt(this.pos);
        }

        char next() {
            return this.str.charAt(this.pos++);
        }

        public char peek() {
            return this.pos < this.str.length() ? this.str.charAt(this.pos + 1) : (char)'\u0000';
        }

        String substr(int beg, int end) {
            return this.str.substring(beg, end);
        }
    }
}

