/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smarts;

import org.openscience.cdk.AtomRef;
import org.openscience.cdk.BondRef;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.smarts.Smarts;
import org.openscience.cdk.smarts.SmartsResult;
import org.openscience.cdk.tools.LoggingToolFactory;

public final class SmartsPattern
extends Pattern {
    private final IAtomContainer query;
    private final Pattern pattern;
    private int requires = 0;
    static final int RING_REQUIRED = 1;
    static final int AROM_REQUIRED = 3;

    private SmartsPattern(String smarts, IChemObjectBuilder builder) {
        this.query = new QueryAtomContainer(builder);
        SmartsResult result = Smarts.parseToResult(this.query, smarts);
        if (!result.ok()) {
            throw new IllegalArgumentException("Could not parse SMARTS: " + smarts + "\n" + result.getMessage() + "\n" + result.displayErrorLocation());
        }
        this.pattern = Pattern.findSubstructure((IAtomContainer)this.query);
        this.requires = SmartsPattern.getRequiredPrep(this.query);
    }

    public static void prepare(IAtomContainer target, int flags) {
        if ((flags & 1) != 0) {
            Cycles.markRingAtomsAndBonds((IAtomContainer)target);
        }
        if ((flags & 3) != 0 && !Aromaticity.apply((ElectronDonation)Aromaticity.Model.Daylight, (IAtomContainer)target)) {
            LoggingToolFactory.createLoggingTool(SmartsPattern.class).error((Object)"Molecule had complex rings and aromaticity may not be completely defined");
        }
    }

    public static void prepare(IAtomContainer target) {
        SmartsPattern.prepare(target, 3);
    }

    public SmartsPattern setPrepare(boolean doPrep) {
        this.requires = doPrep ? SmartsPattern.getRequiredPrep(this.query) : 0;
        return this;
    }

    private static int getRequiredPrep(Expr expr) {
        switch (expr.type()) {
            case RING_COUNT: 
            case RING_BOND_COUNT: 
            case RING_SMALLEST: 
            case RING_SIZE: 
            case IS_IN_RING: 
            case IS_IN_CHAIN: {
                return 1;
            }
            case ALIPHATIC_ELEMENT: {
                switch (expr.value()) {
                    case 0: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 33: 
                    case 34: 
                    case 52: {
                        return 3;
                    }
                }
                return 0;
            }
            case IS_ALIPHATIC: 
            case IS_AROMATIC: 
            case AROMATIC_ELEMENT: 
            case ALIPHATIC_ORDER: 
            case SINGLE_OR_AROMATIC: 
            case DOUBLE_OR_AROMATIC: 
            case SINGLE_OR_DOUBLE: 
            case HAS_ALIPHATIC_HETERO_SUBSTITUENT: 
            case HAS_HETERO_SUBSTITUENT: 
            case IS_ALIPHATIC_HETERO: 
            case ALIPHATIC_HETERO_SUBSTITUENT_COUNT: {
                return 3;
            }
            case RECURSIVE: {
                return SmartsPattern.getRequiredPrep(expr.subquery());
            }
            case AND: 
            case OR: {
                return SmartsPattern.getRequiredPrep(expr.left()) | SmartsPattern.getRequiredPrep(expr.right());
            }
            case NOT: {
                return SmartsPattern.getRequiredPrep(expr.left());
            }
            case TRUE: 
            case FALSE: 
            case IS_HETERO: 
            case HAS_IMPLICIT_HYDROGEN: 
            case HAS_ISOTOPE: 
            case HAS_UNSPEC_ISOTOPE: 
            case UNSATURATED: 
            case ELEMENT: 
            case IMPL_H_COUNT: 
            case TOTAL_H_COUNT: 
            case DEGREE: 
            case TOTAL_DEGREE: 
            case HEAVY_DEGREE: 
            case VALENCE: 
            case ISOTOPE: 
            case FORMAL_CHARGE: 
            case HYBRIDISATION_NUMBER: 
            case HETERO_SUBSTITUENT_COUNT: 
            case PERIODIC_GROUP: 
            case INSATURATION: 
            case REACTION_ROLE: 
            case STEREOCHEMISTRY: 
            case ORDER: {
                return 0;
            }
        }
        throw new IllegalStateException("SmartPattern needs updating to know if: " + expr + " needs ring/arom flags?");
    }

    static int getRequiredPrep(IAtomContainer query) {
        int flags = 0;
        for (IAtom atom : query.atoms()) {
            if (!(atom instanceof IQueryAtom)) continue;
            flags |= SmartsPattern.getRequiredPrep(((QueryAtom)AtomRef.deref((IAtom)atom)).getExpression());
        }
        for (IBond bond : query.bonds()) {
            if (!(bond instanceof IQueryBond)) continue;
            flags |= SmartsPattern.getRequiredPrep(((QueryBond)BondRef.deref((IBond)bond)).getExpression());
        }
        return flags;
    }

    public int[] match(IAtomContainer container) {
        return this.matchAll(container).first();
    }

    public Mappings matchAll(IAtomContainer target) {
        SmartsPattern.prepare(target, this.requires);
        return this.pattern.matchAll(target);
    }

    public static SmartsPattern create(String smarts, IChemObjectBuilder builder) {
        return new SmartsPattern(smarts, builder);
    }

    public static SmartsPattern create(String smarts) {
        return new SmartsPattern(smarts, null);
    }
}

