/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smarts;

import java.util.Arrays;

public class SmartsResult {
    private final String str;
    private final int pos;
    private final String mesg;
    private final int[] aoffsets;
    private final int[] boffsets;
    private final boolean status;

    SmartsResult(String str, int pos, String mesg) {
        this.str = str;
        this.pos = pos;
        this.mesg = mesg;
        this.status = false;
        this.aoffsets = null;
        this.boffsets = null;
    }

    SmartsResult(String str, int[] aoffsets, int[] boffsets) {
        this.str = str;
        this.pos = str.length();
        this.mesg = "OK";
        this.status = true;
        this.aoffsets = aoffsets;
        this.boffsets = boffsets;
    }

    public String getMessage() {
        return this.mesg;
    }

    public int getAtomLocation(int idx) {
        if (idx < 0) {
            return 0;
        }
        if (idx >= this.aoffsets.length) {
            return this.str.length();
        }
        return this.aoffsets[idx];
    }

    public int getBondLocation(int idx) {
        if (idx < 0) {
            return 0;
        }
        if (idx >= this.boffsets.length) {
            return this.str.length();
        }
        return this.boffsets[idx];
    }

    public String displayErrorLocation() {
        return this.displayErrorLocation(this.pos - 1);
    }

    public String displayErrorLocation(int pos) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.str);
        sb.append('\n');
        if (pos <= this.str.length()) {
            char[] cs = new char[pos];
            Arrays.fill(cs, ' ');
            sb.append(cs);
            sb.append('^');
            if (this.str.charAt(pos) == '[') {
                int end = this.str.indexOf(93, pos);
                while (pos++ < end) {
                    sb.append('^');
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public boolean ok() {
        return this.status;
    }

    public int getPosition() {
        return this.pos;
    }
}

