/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smirks;

import java.util.Objects;

final class BinaryExprValue {
    public static final BinaryExprValue ZERO = new BinaryExprValue(0, Type.Integer);
    final int val;
    final Type type;
    static final BinaryExprValue UNDEF = new BinaryExprValue(0, Type.Undefined);
    static final BinaryExprValue CONFLICTING = new BinaryExprValue(0, Type.Conflict);
    static final BinaryExprValue FALSE = new BinaryExprValue(0, Type.Boolean);
    static final BinaryExprValue TRUE = new BinaryExprValue(1, Type.Boolean);

    BinaryExprValue(int x, Type t) {
        this.val = x;
        this.type = t;
    }

    BinaryExprValue(int x) {
        this.val = x;
        this.type = Type.Integer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryExprValue that = (BinaryExprValue)o;
        return this.val == that.val && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.val, this.type});
    }

    BinaryExprValue and(BinaryExprValue that) {
        if (this.type == Type.Undefined) {
            return that;
        }
        if (that.type == Type.Undefined) {
            return this;
        }
        if (this.type == Type.Conflict || that.type == Type.Conflict) {
            return CONFLICTING;
        }
        if (this.val == that.val) {
            return this;
        }
        return CONFLICTING;
    }

    BinaryExprValue or(BinaryExprValue that) {
        if (this.type == Type.Conflict || that.type == Type.Conflict) {
            return CONFLICTING;
        }
        if (this.type == Type.Undefined && that.type == Type.Undefined) {
            return UNDEF;
        }
        if (this.type == that.type && this.val == that.val) {
            return this;
        }
        return CONFLICTING;
    }

    BinaryExprValue not() {
        if (this.type == Type.Undefined) {
            return UNDEF;
        }
        if (this.type == Type.Boolean) {
            return this.val != 0 ? FALSE : TRUE;
        }
        return CONFLICTING;
    }

    public boolean ok() {
        return this.type == Type.Integer || this.type == Type.Boolean;
    }

    public boolean invalid() {
        return this.type == Type.Conflict;
    }

    public boolean undef() {
        return this.type == Type.Undefined;
    }

    public String toString() {
        if (this.type == Type.Undefined) {
            return "{undefined}";
        }
        if (this.type == Type.Conflict) {
            return "{conflict}";
        }
        if (this.type == Type.Boolean) {
            return this.val != 0 ? "(true)" : "(false)";
        }
        return "(" + this.val + ")";
    }

    static enum Type {
        Integer,
        Boolean,
        Conflict,
        Undefined;

    }
}

