/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smirks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openscience.cdk.ReactionRole;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.isomorphism.DfPattern;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.Transform;
import org.openscience.cdk.isomorphism.TransformOp;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.smarts.Smarts;
import org.openscience.cdk.smarts.SmartsResult;
import org.openscience.cdk.smirks.BinaryExprValue;
import org.openscience.cdk.smirks.SmirksOption;
import org.openscience.cdk.smirks.SmirksTransform;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class Smirks {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(Smirks.class);

    private Smirks() {
    }

    public static SmirksTransform compile(String smirks) {
        SmirksTransform transform = new SmirksTransform();
        if (!Smirks.parse(transform, smirks)) {
            throw new IllegalStateException("Invalid SMIRKS: " + transform.message());
        }
        return transform;
    }

    public static boolean apply(IAtomContainer mol, String smirks) {
        return Smirks.compile(smirks).apply(mol);
    }

    public static Iterable<IAtomContainer> apply(IAtomContainer mol, String smirks, Transform.Mode mode) {
        return Smirks.compile(smirks).apply(mol, mode);
    }

    public static boolean parse(Transform transform, String smirks, Set<SmirksOption> options) {
        SmirksState state;
        if (transform == null) {
            throw new NullPointerException("No transform provided");
        }
        if (smirks == null) {
            throw new NullPointerException("No SMIRKS string provided");
        }
        QueryAtomContainer query = new QueryAtomContainer(null);
        SmartsResult result = Smarts.parseToResult((IAtomContainer)query, smirks, 1);
        if (!result.ok()) {
            return transform.setError(result.getMessage());
        }
        if (options.contains((Object)SmirksOption.REVERSE)) {
            for (IAtom atom : query.atoms()) {
                Smirks.swapRoles(atom);
            }
        }
        if (options.contains((Object)SmirksOption.DIFF_PART)) {
            Smirks.markParts(query);
        }
        if (!Smirks.collectAtomPairs(state = new SmirksState(query, result, options))) {
            return transform.setError(state.getMessage());
        }
        if (!Smirks.collectBondPairs(state)) {
            return transform.setError(state.getMessage());
        }
        ArrayList<TransformOp> ops = new ArrayList<TransformOp>();
        Smirks.determineHydrogenMovement(ops, state);
        Smirks.determineAtomChanges(ops, state);
        if (!Smirks.determineBondChanges(ops, state)) {
            return transform.setError(state.getMessage());
        }
        Smirks.determineStereoChanges(ops, state);
        Smirks.checkValence(state, ops);
        Smirks.prepareQuery(state);
        if (state.opts.contains((Object)SmirksOption.OVERWRITE_BOND)) {
            for (int i = 0; i < ops.size(); ++i) {
                TransformOp op = (TransformOp)ops.get(i);
                if (op.type() != TransformOp.Type.NewBond) continue;
                ops.set(i, new TransformOp(TransformOp.Type.OverwriteBond, op));
            }
        }
        if (state.opts.contains((Object)SmirksOption.REMOVE_UNMAPPED_FRAGMENTS)) {
            ops.add(new TransformOp(TransformOp.Type.RemoveUnmapped, 0));
        }
        if (state.opts.contains((Object)SmirksOption.RECOMPUTE_HYDROGENS)) {
            ops.add(new TransformOp(TransformOp.Type.RecomputeHydrogens, 0));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)Smarts.generate((IAtomContainer)query));
            LOGGER.debug(ops);
        }
        transform.init((Pattern)DfPattern.findSubstructure((IAtomContainer)query), ops, state.getMessage());
        return true;
    }

    private static void markParts(QueryAtomContainer query) {
        int groupId = 0;
        for (IAtom atom : query.atoms()) {
            Integer group = (Integer)atom.getProperty((Object)"cdk:ReactionGroup");
            if (group == null || group == 0) continue;
            groupId = Math.max(group, groupId);
        }
        ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
        for (IAtom atom : query.atoms()) {
            Integer group = (Integer)atom.getProperty((Object)"cdk:ReactionGroup");
            if (group != null && group != 0) continue;
            ++groupId;
            queue.add(atom);
            while (!queue.isEmpty()) {
                IAtom a = (IAtom)queue.poll();
                a.setProperty((Object)"cdk:ReactionGroup", (Object)groupId);
                List connectedAtomsList = query.getConnectedAtomsList(a);
                for (IAtom nbor : connectedAtomsList) {
                    Integer nborGroup = (Integer)nbor.getProperty((Object)"cdk:ReactionGroup");
                    if (nborGroup != null && nborGroup != 0) continue;
                    queue.add(nbor);
                }
            }
        }
    }

    private static void swapRoles(IAtom atom) {
        ReactionRole role = (ReactionRole)atom.getProperty((Object)"cdk:ReactionRole");
        if (role == null) {
            return;
        }
        switch (role) {
            case Reactant: {
                atom.setProperty((Object)"cdk:ReactionRole", (Object)ReactionRole.Product);
                break;
            }
            case Product: {
                atom.setProperty((Object)"cdk:ReactionRole", (Object)ReactionRole.Reactant);
            }
        }
    }

    private static Set<SmirksOption> wrap(SmirksOption[] options) {
        if (options.length > 1) {
            return EnumSet.of(options[0], options);
        }
        if (options.length > 0) {
            return EnumSet.of(options[0]);
        }
        return EnumSet.noneOf(SmirksOption.class);
    }

    public static boolean parse(Transform transform, String smirks, SmirksOption ... options) {
        Set<SmirksOption> optset = Smirks.wrap(options);
        return Smirks.parse(transform, smirks, optset);
    }

    public static boolean parse(Transform transform, String smirks) {
        return Smirks.parse(transform, smirks, EnumSet.noneOf(SmirksOption.class));
    }

    private static boolean collectAtomPairs(SmirksState state) {
        for (IAtom atom : state.query.atoms()) {
            ReactionRole role = (ReactionRole)atom.getProperty((Object)"cdk:ReactionRole");
            if (role != null) continue;
            return state.error("SMIRKS was not a reaction!");
        }
        ArrayList<IAtom> atomsInOrder = new ArrayList<IAtom>();
        for (IAtom atom : state.query.atoms()) {
            atomsInOrder.add(atom);
        }
        atomsInOrder.sort(Comparator.comparingInt(a -> ((ReactionRole)a.getProperty((Object)"cdk:ReactionRole", ReactionRole.class)).ordinal()));
        block6: for (IAtom atom : atomsInOrder) {
            ReactionRole role = (ReactionRole)atom.getProperty((Object)"cdk:ReactionRole");
            boolean maybeImplH = Smirks.isSuppressibleH((IAtomContainer)state.query, atom);
            int mapidx = Smirks.getMapIdx(atom);
            Integer pairidx = state.remap.get(mapidx);
            if (pairidx == null) {
                pairidx = state.numPairs++;
                if (mapidx != 0) {
                    state.remap.put(mapidx, pairidx);
                }
            }
            while (state.atomPairs.size() <= pairidx) {
                state.atomPairs.add(new IAtom[2]);
            }
            IAtom[] atoms = state.atomPairs.get(pairidx);
            switch (role) {
                case Reactant: 
                case Agent: {
                    if (atoms[0] != null) {
                        return Smirks.duplicateAtomMap(state, atoms[0], atom);
                    }
                    atoms[0] = atom;
                    if (maybeImplH) break;
                    state.atomidx.put(atom, state.numAtoms++);
                    break;
                }
                case Product: {
                    int n;
                    if (atoms[1] != null) {
                        return Smirks.duplicateAtomMap(state, atoms[1], atom);
                    }
                    atoms[1] = atom;
                    if (maybeImplH || Smirks.isSuppressibleH((IAtomContainer)state.query, atoms[0])) {
                        if (atoms[0] == null) continue block6;
                        if (!state.atomidx.containsKey(atoms[0])) break;
                    }
                    if (atoms[0] != null) {
                        n = state.atomidx.get(atoms[0]);
                    } else {
                        int n2 = state.numAtoms;
                        n = n2;
                        state.numAtoms = n2 + 1;
                    }
                    int aidx = n;
                    state.atomidx.put(atom, aidx);
                    state.hcount[aidx] = state.calcImplH(atom);
                    break;
                }
                default: {
                    throw new IllegalStateException("Atom without a role!");
                }
            }
        }
        return true;
    }

    private static boolean collectBondPairs(SmirksState state) {
        HashMap<BondKey, IBond[]> bondMap = new HashMap<BondKey, IBond[]>();
        for (IBond bond : state.query.bonds()) {
            IAtom beg = bond.getBegin();
            IAtom end = bond.getEnd();
            int begIdx = Smirks.getMapIdx(beg);
            int endIdx = Smirks.getMapIdx(end);
            if (!state.atomidx.containsKey(beg)) {
                if (!state.atomidx.containsKey(end)) continue;
                int n = state.atomidx.get(end);
                state.hcount[n] = state.hcount[n] + (Smirks.isProduct(end) ? 1 : -1);
                if (Smirks.isProduct(end)) continue;
                int n2 = state.atomidx.get(end);
                state.hmin[n2] = state.hmin[n2] + 1;
                continue;
            }
            if (!state.atomidx.containsKey(end)) {
                int n = state.atomidx.get(beg);
                state.hcount[n] = state.hcount[n] + (Smirks.isProduct(beg) ? 1 : -1);
                if (Smirks.isProduct(beg)) continue;
                int n3 = state.atomidx.get(beg);
                state.hmin[n3] = state.hmin[n3] + 1;
                continue;
            }
            IBond[] bondPair = null;
            if (begIdx != 0 && endIdx != 0) {
                bondPair = (IBond[])bondMap.get(new BondKey(Smirks.getMapIdx(beg), Smirks.getMapIdx(end)));
            }
            if (bondPair == null) {
                bondPair = new IBond[2];
                state.bondPairs.add(bondPair);
                if (begIdx != 0 && endIdx != 0) {
                    bondMap.put(new BondKey(Smirks.getMapIdx(beg), Smirks.getMapIdx(end)), bondPair);
                }
            }
            ReactionRole role = (ReactionRole)beg.getProperty((Object)"cdk:ReactionRole");
            switch (role) {
                case Reactant: 
                case Agent: {
                    bondPair[0] = bond;
                    break;
                }
                case Product: {
                    bondPair[1] = bond;
                }
            }
        }
        return true;
    }

    private static void determineHydrogenMovement(List<TransformOp> ops, SmirksState state) {
        Iterator<IAtom[]> iter = state.atomPairs.iterator();
        while (iter.hasNext()) {
            IAtom[] pair = iter.next();
            if (Smirks.isSuppressibleH((IAtomContainer)state.query, pair[0])) {
                if (Smirks.isHydrogen((IAtomContainer)state.query, pair[1])) {
                    IAtom begNbor = ((IBond)state.query.getConnectedBondsList(pair[0]).get(0)).getOther(pair[0]);
                    IAtom endNbor = ((IBond)state.query.getConnectedBondsList(pair[1]).get(0)).getOther(pair[1]);
                    int begNborIdx = state.atomidx.get(begNbor);
                    Integer endNborIdx = state.atomidx.get(endNbor);
                    if (endNborIdx == null) {
                        int atomIdx;
                        int n = begNborIdx;
                        state.hcount[n] = state.hcount[n] + 1;
                        ++state.numAtoms;
                        state.atomidx.put(pair[1], atomIdx);
                        ops.add(new TransformOp(TransformOp.Type.PromoteH, begNborIdx, atomIdx));
                    } else if (begNborIdx != endNborIdx) {
                        int n = begNborIdx;
                        state.hcount[n] = state.hcount[n] + 1;
                        int n2 = endNborIdx;
                        state.hcount[n2] = state.hcount[n2] - 1;
                        ops.add(new TransformOp(TransformOp.Type.MoveH, begNborIdx, endNborIdx.intValue()));
                    }
                    iter.remove();
                    continue;
                }
                if (pair[1] != null) continue;
                iter.remove();
                continue;
            }
            if (!Smirks.isSuppressibleH((IAtomContainer)state.query, pair[1])) continue;
            iter.remove();
        }
    }

    private static String generateAtom(IAtom atom) {
        return "[" + Smarts.generateAtom(((QueryAtom)atom).getExpression()).replaceAll("(?:^\\[)|(?:]$)", "") + ":" + Smirks.getMapIdx(atom) + "]";
    }

    private static void checkAtomMap(SmirksState state, IAtom atom) {
        if (!state.opts.contains((Object)SmirksOption.PEDANTIC)) {
            return;
        }
        if (Smirks.getMapIdx(atom) != 0) {
            state.warning("Added/removed atoms do not need to be mapped", atom);
        }
    }

    private static boolean duplicateAtomMap(SmirksState state, IAtom atom1, IAtom atom2) {
        return state.error("Duplicate atom map " + Smirks.generateAtom(atom1) + " and " + Smirks.generateAtom(atom2));
    }

    private static void determineAtomChanges(List<TransformOp> ops, SmirksState state) {
        for (IAtom[] pair : state.atomPairs) {
            Integer aidx = pair[0] != null ? state.atomidx.get(pair[0]) : state.atomidx.get(pair[1]);
            if (aidx == null) continue;
            if (pair[0] != null && pair[1] == null) {
                Smirks.checkAtomMap(state, pair[0]);
                ops.add(new TransformOp(TransformOp.Type.DeleteAtom, aidx.intValue()));
                continue;
            }
            if (pair[0] == null && pair[1] != null) {
                Smirks.checkAtomMap(state, pair[1]);
                ops.addAll(Smirks.atomTypeOps(state.atomidx.get(pair[1]), null, pair[1], state.hcount[aidx], state));
                continue;
            }
            ops.addAll(Smirks.atomTypeOps(aidx, pair[0], pair[1], state.hcount[aidx], state));
        }
    }

    private static boolean determineBondChanges(List<TransformOp> ops, SmirksState state) {
        for (IBond[] pair : state.bondPairs) {
            BinaryExprValue bndArom;
            int begIdx = pair[0] == null ? state.atomidx.get(pair[1].getBegin()) : state.atomidx.get(pair[0].getBegin());
            int endIdx = pair[0] == null ? state.atomidx.get(pair[1].getEnd()) : state.atomidx.get(pair[0].getEnd());
            if (pair[1] != null && (bndArom = Smirks.isAromatic(pair[1])).ok() && bndArom.val == 1) {
                BinaryExprValue begArom = Smirks.isAromatic(pair[1].getBegin());
                BinaryExprValue endArom = Smirks.isAromatic(pair[1].getEnd());
                if (begArom.equals(BinaryExprValue.FALSE) || endArom.equals(BinaryExprValue.FALSE)) {
                    state.warning("Aromatic bond ':' connected to an aliphatic atom", pair[1]);
                }
            }
            BinaryExprValue lft = Smirks.getBondOrder(pair[0]);
            BinaryExprValue rgt = Smirks.getBondOrder(pair[1]);
            if (pair[0] != null && pair[1] == null) {
                ops.add(new TransformOp(TransformOp.Type.DeleteBond, begIdx, endIdx, Smirks.getBondOrder((IBond)pair[0]).val));
                continue;
            }
            if (pair[0] == null && pair[1] != null) {
                if (!rgt.ok()) {
                    BinaryExprValue begArom = Smirks.isAromatic(pair[1].getBegin());
                    BinaryExprValue endArom = Smirks.isAromatic(pair[1].getEnd());
                    if (begArom.equals(BinaryExprValue.FALSE) || endArom.equals(BinaryExprValue.FALSE)) {
                        state.warning("Cannot determine bond order for newly created bond (presumed aliphatic single due to attached atoms)", pair[1]);
                        ops.add(new TransformOp(TransformOp.Type.NewBond, begIdx, endIdx, 1, 0));
                        continue;
                    }
                    if (begArom.equals(BinaryExprValue.TRUE) && endArom.equals(BinaryExprValue.TRUE)) {
                        state.warning("Cannot determine bond order for newly created bond (presumed aromatic single due to attached atoms)", pair[1]);
                        ops.add(new TransformOp(TransformOp.Type.NewBond, begIdx, endIdx, 1, 1));
                        continue;
                    }
                    if (state.opts.contains((Object)SmirksOption.PEDANTIC)) {
                        return state.error("Cannot determine bond order for newly created bond");
                    }
                    state.warning("Cannot determine bond order for newly created bond (presumed aliphatic single)", pair[1]);
                    ops.add(new TransformOp(TransformOp.Type.NewBond, begIdx, endIdx, 1, 0));
                    continue;
                }
                ops.add(new TransformOp(TransformOp.Type.NewBond, begIdx, endIdx, rgt.val, 0));
                continue;
            }
            if (!rgt.ok()) {
                if (Smirks.isAnyBond(pair[1])) continue;
                state.warning("Ignored query bond (implicit: -,:), use '~' to suppress this warning", pair[1]);
                continue;
            }
            if (Smirks.changed(lft, rgt)) {
                if (lft.ok()) {
                    ops.add(new TransformOp(TransformOp.Type.BondOrder, begIdx, endIdx, rgt.val, lft.val));
                } else {
                    ops.add(new TransformOp(TransformOp.Type.BondOrder, begIdx, endIdx, rgt.val));
                }
            }
            if (!Smirks.changed(lft = Smirks.isAromatic(pair[0]), rgt = Smirks.isAromatic(pair[1]))) continue;
            ops.add(new TransformOp(TransformOp.Type.AromaticBond, begIdx, endIdx, rgt.val, 0));
        }
        return true;
    }

    private static void determineStereoChanges(List<TransformOp> ops, SmirksState state) {
        ArrayList<IStereoElement> stereoElements = new ArrayList<IStereoElement>();
        block6: for (IStereoElement se : state.query.stereoElements()) {
            switch (se.getConfigClass()) {
                case 16896: {
                    BinaryExprValue val;
                    if (Smirks.isProduct((IAtom)se.getFocus())) {
                        IStereoElement th = se;
                        val = Smirks.getProperty((IAtom)th.getFocus(), Expr.Type.STEREOCHEMISTRY);
                        if (val.val == 1) {
                            ops.add(new TransformOp(TransformOp.Type.Tetrahedral, state.atomidx.get(th.getFocus()).intValue(), state.atomidx.get(th.getCarriers().get(0)).intValue(), state.atomidx.get(th.getCarriers().get(1)).intValue(), state.atomidx.get(th.getCarriers().get(2)).intValue()));
                            break;
                        }
                        if (val.val != 2) continue block6;
                        ops.add(new TransformOp(TransformOp.Type.Tetrahedral, state.atomidx.get(th.getFocus()).intValue(), state.atomidx.get(th.getCarriers().get(0)).intValue(), state.atomidx.get(th.getCarriers().get(2)).intValue(), state.atomidx.get(th.getCarriers().get(1)).intValue()));
                        break;
                    }
                    stereoElements.add(se);
                    break;
                }
                case 8448: {
                    BinaryExprValue val;
                    if (Smirks.isProduct(((IBond)se.getFocus()).getBegin()) && Smirks.isProduct(((IBond)se.getFocus()).getEnd())) {
                        IStereoElement db = se;
                        val = Smirks.getProperty((IBond)db.getFocus(), Expr.Type.STEREOCHEMISTRY);
                        IAtom a = ((IBond)db.getFocus()).getBegin();
                        IAtom b = ((IBond)db.getFocus()).getEnd();
                        IAtom c = ((IBond)db.getCarriers().get(0)).getOther(a);
                        IAtom d = ((IBond)db.getCarriers().get(1)).getOther(b);
                        if (val.val == 1) {
                            ops.add(new TransformOp(TransformOp.Type.DbOpposite, state.atomidx.get(a).intValue(), state.atomidx.get(b).intValue(), state.atomidx.get(c).intValue(), state.atomidx.get(d).intValue()));
                            break;
                        }
                        ops.add(new TransformOp(TransformOp.Type.DbTogether, state.atomidx.get(a).intValue(), state.atomidx.get(b).intValue(), state.atomidx.get(c).intValue(), state.atomidx.get(d).intValue()));
                        break;
                    }
                    stereoElements.add(se);
                    break;
                }
                case 17152: 
                case 17664: 
                case 20992: 
                case 24832: {
                    if (Smirks.isProduct((IAtom)se.getFocus())) {
                        state.warning("Ignored setting atom stereo on right hand side - unsupported stereo class: " + se.getConfigClass());
                        break;
                    }
                    stereoElements.add(se);
                    break;
                }
                case 8704: 
                case 17408: {
                    if (Smirks.isProduct(((IBond)se.getFocus()).getBegin()) && Smirks.isProduct(((IBond)se.getFocus()).getEnd())) {
                        state.warning("Ignored setting bond stereo on right hand side - unsupported stereo class: " + se.getConfigClass());
                        break;
                    }
                    stereoElements.add(se);
                    break;
                }
                default: {
                    state.warning("Ignored stereo on right hand side - unsupported stereo class: " + se.getConfigClass());
                }
            }
        }
        state.query.setStereoElements(stereoElements);
    }

    private static void prepareQuery(SmirksState state) {
        HashSet<IAtom> toremove = new HashSet<IAtom>();
        for (IAtom atom : state.query.atoms()) {
            if (Smirks.isProduct(atom) || Smirks.isSuppressibleH((IAtomContainer)state.query, atom)) {
                toremove.add(atom);
                continue;
            }
            atom.setProperty((Object)"cdk:ReactionRole", null);
            atom.setProperty((Object)"cdk:AtomAtomMapping", (Object)state.atomidx.get(atom));
            Smirks.stripRxnRole(atom);
            Smirks.constrainMinHydrogenCount(atom, state.hmin[state.atomidx.get(atom)]);
        }
        for (IAtom atom : toremove) {
            state.query.removeAtom(atom);
        }
    }

    private static void update(Map<Integer, Integer> map, int key, int adj) {
        Integer v = map.get(key);
        if (v == null) {
            v = 0;
        }
        map.put(key, v + adj);
    }

    private static void checkValence(SmirksState state, List<TransformOp> ops) {
        if (!state.opts.contains((Object)SmirksOption.PEDANTIC)) {
            return;
        }
        HashMap<Integer, Integer> valence = new HashMap<Integer, Integer>();
        HashSet<Integer> unknown = new HashSet<Integer>();
        HashMap<Integer, Integer> hcnts = new HashMap<Integer, Integer>();
        for (TransformOp op : ops) {
            switch (op.type()) {
                case BondOrder: {
                    if (op.argD() != 0) {
                        Smirks.update(valence, op.argA(), op.argC() - op.argD());
                        Smirks.update(valence, op.argB(), op.argC() - op.argD());
                        break;
                    }
                    unknown.add(op.argA());
                    unknown.add(op.argB());
                    break;
                }
                case DeleteBond: {
                    Smirks.update(valence, op.argA(), -op.argC());
                    Smirks.update(valence, op.argB(), -op.argC());
                    break;
                }
                case NewBond: {
                    Smirks.update(valence, op.argA(), op.argC());
                    Smirks.update(valence, op.argB(), op.argC());
                    break;
                }
                case PromoteH: {
                    Smirks.update(valence, op.argA(), -1);
                    break;
                }
                case MoveH: {
                    Smirks.update(valence, op.argA(), -1);
                    Smirks.update(valence, op.argB(), 1);
                    break;
                }
                case AdjustH: {
                    Smirks.update(valence, op.argA(), op.argB());
                    break;
                }
                case Charge: {
                    unknown.add(op.argA());
                    break;
                }
                case TotalH: 
                case ImplH: {
                    hcnts.put(op.argA(), op.argB());
                }
            }
        }
        for (IAtom[] pair : state.atomPairs) {
            Integer diff;
            Integer id;
            if (pair[0] == null || pair[1] == null || unknown.contains(id = state.atomidx.get(pair[0])) || (diff = (Integer)valence.get(id)) == null || diff == 0) continue;
            Integer hcnt = (Integer)hcnts.get(id);
            if (hcnt != null) {
                state.warning("Possible valence change, add H" + (hcnt + diff) + " to reactant to supress", pair[0]);
                continue;
            }
            state.warning("Possible valence change", pair[0]);
        }
    }

    private static Integer getExplValence(QueryAtomContainer query, IAtom atom) {
        int count = 0;
        for (IBond bond : query.getConnectedBondsList(atom)) {
            BinaryExprValue result = Smirks.getBondOrder(bond, BinaryExprValue.FALSE);
            if (!result.ok()) {
                return null;
            }
            count += result.val;
        }
        return count;
    }

    private static void constrainMinHydrogenCount(IAtom atom, int hcount) {
        if (hcount <= 0) {
            return;
        }
        QueryAtom qatom = (QueryAtom)atom;
        Expr expr = qatom.getExpression();
        for (int i = 0; i < hcount; ++i) {
            expr.and(new Expr(Expr.Type.TOTAL_H_COUNT, i).negate());
        }
        qatom.setExpression(expr);
    }

    private static void stripRxnRole(IAtom atom) {
        QueryAtom qatom = (QueryAtom)atom;
        qatom.setExpression(Smirks.stripRxnRole(qatom.getExpression()));
    }

    private static Expr stripRxnRole(Expr e) {
        switch (e.type()) {
            case REACTION_ROLE: {
                return new Expr(Expr.Type.TRUE);
            }
            case OR: {
                return Smirks.stripRxnRole(e.left()).or(Smirks.stripRxnRole(e.right()));
            }
            case AND: {
                return Smirks.stripRxnRole(e.left()).and(Smirks.stripRxnRole(e.right()));
            }
        }
        return e;
    }

    private static boolean isProduct(IAtom end) {
        return end.getProperty((Object)"cdk:ReactionRole") == ReactionRole.Product;
    }

    private static boolean isSuppressibleH(Expr e) {
        return (e.type() == Expr.Type.ELEMENT || e.type() == Expr.Type.ALIPHATIC_ELEMENT) && e.value() == 1;
    }

    private static boolean isExplHWithOptRole(Expr e) {
        if (e.type() == Expr.Type.AND) {
            Expr l = e.left();
            Expr r = e.right();
            return Smirks.isSuppressibleH(l) && r.type() == Expr.Type.REACTION_ROLE || Smirks.isSuppressibleH(r) && l.type() == Expr.Type.REACTION_ROLE;
        }
        return Smirks.isSuppressibleH(e);
    }

    private static boolean isSuppressibleH(IAtomContainer mol, IAtom a) {
        if (a == null) {
            return false;
        }
        if (!Smirks.isExplHWithOptRole(((QueryAtom)a).getExpression())) {
            return false;
        }
        List bonds = mol.getConnectedBondsList(a);
        return bonds.size() == 1 && Smirks.getAtomicNumber((IAtom)((IBond)bonds.get((int)0)).getOther((IAtom)a)).val != 1;
    }

    private static boolean isHydrogen(IAtomContainer mol, IAtom a) {
        if (a == null) {
            return false;
        }
        return Smirks.getAtomicNumber((IAtom)a).val == 1;
    }

    private static boolean changed(BinaryExprValue lft, BinaryExprValue rgt) {
        return rgt.ok() && !lft.equals(rgt);
    }

    private static Integer getMapIdx(IAtom atom) {
        Integer x = (Integer)atom.getProperty((Object)"cdk:AtomAtomMapping");
        return x != null ? x : 0;
    }

    private static BinaryExprValue getAtomicNumber(IAtom atom) {
        return atom == null ? BinaryExprValue.UNDEF : Smirks.getAtomicNumber(((QueryAtom)atom).getExpression());
    }

    private static BinaryExprValue getAtomicNumber(Expr expr) {
        switch (expr.type()) {
            case ELEMENT: 
            case ALIPHATIC_ELEMENT: 
            case AROMATIC_ELEMENT: {
                return new BinaryExprValue(expr.value());
            }
            case AND: {
                return Smirks.getAtomicNumber(expr.left()).and(Smirks.getAtomicNumber(expr.right()));
            }
            case OR: {
                return Smirks.getAtomicNumber(expr.left()).or(Smirks.getAtomicNumber(expr.right()));
            }
            case NOT: {
                return Smirks.getAtomicNumber(expr.left()).not();
            }
        }
        return BinaryExprValue.UNDEF;
    }

    private static BinaryExprValue isAromatic(Expr expr) {
        return Smirks.isAromatic(expr, BinaryExprValue.UNDEF);
    }

    private static BinaryExprValue isAromatic(Expr expr, BinaryExprValue context) {
        switch (expr.type()) {
            case ELEMENT: {
                switch (expr.value()) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 51: 
                    case 52: {
                        return BinaryExprValue.UNDEF;
                    }
                }
                return BinaryExprValue.FALSE;
            }
            case AROMATIC_ELEMENT: 
            case IS_AROMATIC: {
                return BinaryExprValue.TRUE;
            }
            case SINGLE_OR_AROMATIC: 
            case DOUBLE_OR_AROMATIC: {
                if (context == BinaryExprValue.TRUE) {
                    return BinaryExprValue.TRUE;
                }
                if (context == BinaryExprValue.FALSE) {
                    return BinaryExprValue.FALSE;
                }
                return BinaryExprValue.UNDEF;
            }
            case ALIPHATIC_ELEMENT: 
            case IS_ALIPHATIC: 
            case IS_IN_CHAIN: 
            case IS_ALIPHATIC_HETERO: 
            case ALIPHATIC_ORDER: 
            case SINGLE_OR_DOUBLE: {
                return BinaryExprValue.FALSE;
            }
            case TOTAL_H_COUNT: 
            case IMPL_H_COUNT: {
                if (expr.value() > 1) {
                    return BinaryExprValue.FALSE;
                }
                return BinaryExprValue.UNDEF;
            }
            case AND: {
                return Smirks.isAromatic(expr.left()).and(Smirks.isAromatic(expr.right()));
            }
            case OR: {
                return Smirks.isAromatic(expr.left()).or(Smirks.isAromatic(expr.right()));
            }
            case NOT: {
                return Smirks.isAromatic(expr.left()).not();
            }
        }
        return BinaryExprValue.UNDEF;
    }

    private static BinaryExprValue isAromatic(IAtom atom) {
        if (atom == null) {
            return BinaryExprValue.UNDEF;
        }
        return Smirks.isAromatic(((QueryAtom)atom).getExpression());
    }

    private static BinaryExprValue isAromatic(IBond bond) {
        BinaryExprValue begIsArom = Smirks.isAromatic(bond.getBegin());
        BinaryExprValue endIsArom = Smirks.isAromatic(bond.getEnd());
        BinaryExprValue aromContext = begIsArom.equals(BinaryExprValue.TRUE) && endIsArom.equals(BinaryExprValue.TRUE) ? BinaryExprValue.TRUE : (begIsArom.equals(BinaryExprValue.FALSE) || endIsArom.equals(BinaryExprValue.FALSE) ? BinaryExprValue.FALSE : BinaryExprValue.UNDEF);
        return Smirks.isAromatic(((QueryBond)bond).getExpression(), aromContext);
    }

    private static BinaryExprValue getProperty(Expr expr, Expr.Type type) {
        switch (expr.type()) {
            case AND: {
                return Smirks.getProperty(expr.left(), type).and(Smirks.getProperty(expr.right(), type));
            }
            case OR: {
                return Smirks.getProperty(expr.left(), type).or(Smirks.getProperty(expr.right(), type));
            }
            case NOT: {
                return BinaryExprValue.CONFLICTING;
            }
        }
        if (type == Expr.Type.ISOTOPE && expr.type() == Expr.Type.HAS_UNSPEC_ISOTOPE) {
            return new BinaryExprValue(0);
        }
        if (expr.type() == type) {
            return new BinaryExprValue(expr.value());
        }
        return BinaryExprValue.UNDEF;
    }

    private static BinaryExprValue getProperty(IAtom atom, Expr.Type type) {
        return atom == null ? BinaryExprValue.UNDEF : Smirks.getProperty(((QueryAtom)atom).getExpression(), type);
    }

    private static BinaryExprValue getProperty(IBond bond, Expr.Type type) {
        return bond == null ? BinaryExprValue.UNDEF : Smirks.getProperty(((QueryBond)bond).getExpression(), type);
    }

    private static boolean isAnyBond(IBond bond) {
        return bond != null && Smirks.isAnyBond(((QueryBond)bond).getExpression());
    }

    private static boolean isAnyBond(Expr expr) {
        return expr.type() == Expr.Type.TRUE;
    }

    private static BinaryExprValue getBondOrder(IBond bond) {
        if (bond == null) {
            return BinaryExprValue.UNDEF;
        }
        BinaryExprValue begIsArom = Smirks.isAromatic(bond.getBegin());
        BinaryExprValue endIsArom = Smirks.isAromatic(bond.getEnd());
        BinaryExprValue aromContext = begIsArom.equals(BinaryExprValue.TRUE) && endIsArom.equals(BinaryExprValue.TRUE) ? BinaryExprValue.TRUE : (begIsArom.equals(BinaryExprValue.FALSE) || endIsArom.equals(BinaryExprValue.FALSE) ? BinaryExprValue.FALSE : BinaryExprValue.UNDEF);
        return Smirks.getBondOrder(bond, aromContext);
    }

    private static BinaryExprValue getBondOrder(IBond bond, BinaryExprValue aromContext) {
        if (bond == null) {
            return BinaryExprValue.UNDEF;
        }
        return Smirks.getBondOrder(((QueryBond)bond).getExpression(), aromContext);
    }

    private static BinaryExprValue getBondOrder(Expr expr, BinaryExprValue aromContext) {
        switch (expr.type()) {
            case IS_AROMATIC: {
                return new BinaryExprValue(5);
            }
            case SINGLE_OR_AROMATIC: {
                if (aromContext == BinaryExprValue.TRUE) {
                    return new BinaryExprValue(5);
                }
                if (aromContext == BinaryExprValue.FALSE) {
                    return new BinaryExprValue(1);
                }
                return BinaryExprValue.UNDEF;
            }
            case DOUBLE_OR_AROMATIC: {
                if (aromContext == BinaryExprValue.TRUE) {
                    return new BinaryExprValue(5);
                }
                if (aromContext == BinaryExprValue.FALSE) {
                    return new BinaryExprValue(2);
                }
                return BinaryExprValue.UNDEF;
            }
            case SINGLE_OR_DOUBLE: {
                return BinaryExprValue.CONFLICTING;
            }
            case ALIPHATIC_ORDER: 
            case ORDER: {
                return new BinaryExprValue(expr.value());
            }
            case AND: {
                return Smirks.getBondOrder(expr.left(), aromContext).and(Smirks.getBondOrder(expr.right(), aromContext));
            }
            case OR: {
                return Smirks.getBondOrder(expr.left(), aromContext).or(Smirks.getBondOrder(expr.right(), aromContext));
            }
            case NOT: {
                return Smirks.getBondOrder(expr.left(), aromContext).not();
            }
        }
        return BinaryExprValue.UNDEF;
    }

    static List<TransformOp> atomTypeOps(IAtom before, IAtom after) {
        return Smirks.atomTypeOps(0, before, after, 0, new SmirksState(new QueryAtomContainer(null), null, EnumSet.noneOf(SmirksOption.class)));
    }

    private static List<TransformOp> atomTypeOps(int aidx, IAtom before, IAtom after, int hAdjust, SmirksState state) {
        ArrayList<TransformOp> ops = new ArrayList<TransformOp>(4);
        BinaryExprValue lft = Smirks.getAtomicNumber(before);
        BinaryExprValue rgt = Smirks.getAtomicNumber(after);
        if (before == null) {
            ops.add(new TransformOp(TransformOp.Type.NewAtom, aidx, rgt.val, hAdjust, Smirks.isAromatic((IAtom)after).val));
        } else {
            if (Smirks.changed(lft, rgt)) {
                if (state.opts.contains((Object)SmirksOption.IGNORE_SET_ELEM)) {
                    state.warning("Ignored attempt to change the element type", after);
                } else {
                    ops.add(new TransformOp(TransformOp.Type.Element, aidx, rgt.val));
                }
            }
            if (rgt.ok() && Smirks.changed(lft = Smirks.isAromatic(before), rgt = Smirks.isAromatic(after))) {
                ops.add(new TransformOp(TransformOp.Type.Aromatic, aidx, rgt.val));
            }
        }
        lft = Smirks.getProperty(before, Expr.Type.FORMAL_CHARGE);
        rgt = Smirks.getProperty(after, Expr.Type.FORMAL_CHARGE);
        if (Smirks.changed(lft, rgt)) {
            ops.add(new TransformOp(TransformOp.Type.Charge, aidx, rgt.val));
        }
        if (Smirks.changed(lft = Smirks.getProperty(before, Expr.Type.IMPL_H_COUNT), rgt = Smirks.getProperty(after, Expr.Type.IMPL_H_COUNT))) {
            if (state.opts.contains((Object)SmirksOption.IGNORE_IMPL_H)) {
                if (state.opts.contains((Object)SmirksOption.PEDANTIC)) {
                    state.warning("Ignored attempt to set the implicit hydrogen count", after);
                }
            } else {
                ops.add(new TransformOp(TransformOp.Type.ImplH, aidx, rgt.val));
            }
        } else if (before != null && hAdjust != 0) {
            ops.add(new TransformOp(TransformOp.Type.AdjustH, aidx, hAdjust));
        }
        if (Smirks.changed(lft = Smirks.getProperty(before, Expr.Type.TOTAL_H_COUNT), rgt = Smirks.getProperty(after, Expr.Type.TOTAL_H_COUNT))) {
            if (state.opts.contains((Object)SmirksOption.IGNORE_TOTAL_H) || state.opts.contains((Object)SmirksOption.IGNORE_TOTAL_H0) && rgt.equals(BinaryExprValue.ZERO)) {
                if (state.opts.contains((Object)SmirksOption.PEDANTIC)) {
                    state.warning("Ignored attempt to set the total hydrogen count", after);
                }
            } else if (lft.ok() && rgt.ok()) {
                ops.add(new TransformOp(TransformOp.Type.AdjustH, aidx, rgt.val - lft.val));
            } else {
                ops.add(new TransformOp(TransformOp.Type.TotalH, aidx, rgt.val));
            }
        }
        if (Smirks.changed(lft = Smirks.getProperty(before, Expr.Type.ISOTOPE), rgt = Smirks.getProperty(after, Expr.Type.ISOTOPE))) {
            ops.add(new TransformOp(TransformOp.Type.Mass, aidx, rgt.val));
        }
        return ops;
    }

    private static final class SmirksState {
        Set<SmirksOption> opts = EnumSet.noneOf(SmirksOption.class);
        Set<String> errors = new LinkedHashSet<String>();
        Set<String> warnings = new LinkedHashSet<String>();
        QueryAtomContainer query;
        SmartsResult input;
        int numAtoms = 1;
        int numPairs = 0;
        Map<IAtom, Integer> atomidx = new HashMap<IAtom, Integer>();
        Map<Integer, Integer> remap = new HashMap<Integer, Integer>();
        List<IAtom[]> atomPairs = new ArrayList<IAtom[]>();
        List<IBond[]> bondPairs = new ArrayList<IBond[]>();
        int[] hcount;
        int[] hmin;

        SmirksState(QueryAtomContainer query, SmartsResult input, Set<SmirksOption> options) {
            this.query = query;
            this.input = input;
            this.hcount = new int[query.getAtomCount() + 1];
            this.hmin = new int[query.getAtomCount() + 1];
            this.opts = options;
        }

        private int calcImplH(IAtom atom) {
            if (atom.getProperty((Object)"cdk.smarts.iscomplex") == null) {
                int elem = Smirks.getAtomicNumber((IAtom)atom).val;
                Integer valence = Smirks.getExplValence(this.query, atom);
                if (valence == null) {
                    this.warning("Created (right hand side) unbracketed " + Elements.ofNumber((int)elem).symbol() + " atom was connected with bond expressions", atom);
                    return 0;
                }
                if (Smirks.isAromatic((IAtom)atom).val == 1) {
                    Integer n = valence;
                    valence = valence + 1;
                }
                switch (elem) {
                    case 0: {
                        return 0;
                    }
                    case 5: {
                        if (valence > 3) break;
                        return 3 - valence;
                    }
                    case 6: {
                        if (valence > 4) break;
                        return 4 - valence;
                    }
                    case 7: 
                    case 15: {
                        if (valence <= 3) {
                            return 3 - valence;
                        }
                        if (valence > 5) break;
                        return 5 - valence;
                    }
                    case 8: {
                        if (valence > 2) break;
                        return 2 - valence;
                    }
                    case 16: {
                        if (valence <= 2) {
                            return 2 - valence;
                        }
                        if (valence <= 4) {
                            return 4 - valence;
                        }
                        if (valence > 6) break;
                        return 6 - valence;
                    }
                    case 9: 
                    case 17: 
                    case 35: 
                    case 53: {
                        if (valence <= 1) {
                            return 1 - valence;
                        }
                        if (valence <= 3) {
                            return 3 - valence;
                        }
                        if (valence <= 5) {
                            return 5 - valence;
                        }
                        if (valence > 7) break;
                        return 7 - valence;
                    }
                    default: {
                        throw new IllegalStateException("No default valence for element=" + elem);
                    }
                }
            }
            return 0;
        }

        boolean error(String s) {
            this.errors.add(s);
            return false;
        }

        boolean error(String s, IBond bond) {
            this.errors.add(s + "\n" + this.input.displayErrorLocation(this.input.getBondLocation(this.query.indexOf(bond))));
            return false;
        }

        void warning(String s) {
            this.warnings.add(s);
        }

        void warning(String s, IBond bond) {
            this.warnings.add(s + "\n" + this.input.displayErrorLocation(this.input.getBondLocation(this.query.indexOf(bond))));
        }

        void warning(String s, IAtom atom) {
            this.warnings.add(s + "\n" + this.input.displayErrorLocation(this.input.getAtomLocation(this.query.indexOf(atom))));
        }

        String getMessage() {
            if (this.errors.isEmpty() && this.warnings.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (String e : this.errors) {
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
                    sb.append('\n');
                }
                sb.append(e);
            }
            if (sb.length() == 0) {
                for (String w : this.warnings) {
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
                        sb.append('\n');
                    }
                    sb.append(w);
                }
            }
            return sb.toString();
        }
    }

    private static final class BondKey {
        int beg;
        int end;

        BondKey(int beg, int end) {
            this.beg = beg;
            this.end = end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BondKey key = (BondKey)o;
            return this.beg == key.beg && this.end == key.end || this.beg == key.end && this.end == key.beg;
        }

        public int hashCode() {
            return Objects.hash(Math.min(this.beg, this.end), Math.max(this.beg, this.end));
        }
    }
}

