/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tautomers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.invariant.InChINumbersTools;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.AtomMatcher;
import org.openscience.cdk.isomorphism.BondMatcher;
import org.openscience.cdk.isomorphism.VentoFoggia;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public final class InChITautomerGenerator {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(InChITautomerGenerator.class);
    private static final SmilesGenerator CANSMI = new SmilesGenerator(1);
    public static final int KETO_ENOL = 1;
    public static final int ONE_FIVE_SHIFT = 2;
    private final int flags;

    public InChITautomerGenerator(int flags) {
        this.flags = flags;
    }

    public InChITautomerGenerator() {
        this(0);
    }

    public List<IAtomContainer> getTautomers(IAtomContainer mol) throws CDKException, CloneNotSupportedException {
        String opt = "";
        if ((this.flags & 1) != 0) {
            opt = opt + " -KET";
        }
        if ((this.flags & 2) != 0) {
            opt = opt + " -15T";
        }
        InChIGenerator gen = InChIGeneratorFactory.getInstance().getInChIGenerator(mol, opt);
        String inchi = gen.getInchi();
        String aux = gen.getAuxInfo();
        long[] amap = new long[mol.getAtomCount()];
        InChINumbersTools.parseAuxInfo((String)aux, (long[])amap);
        if (inchi == null) {
            throw new CDKException(InChIGenerator.class + " failed to create an InChI for the provided molecule, InChI -> null.");
        }
        return this.getTautomers(mol, inchi, amap);
    }

    @Deprecated
    public List<IAtomContainer> getTautomers(IAtomContainer mol, String inchi) throws CDKException, CloneNotSupportedException {
        return this.getTautomers(mol, inchi, null);
    }

    private List<IAtomContainer> getTautomers(IAtomContainer mol, String inchi, long[] amap) throws CDKException, CloneNotSupportedException {
        if (mol == null || inchi == null) {
            throw new CDKException("Please provide a valid input molecule and its corresponding InChI value.");
        }
        mol = (IAtomContainer)mol.getBuilder().newInstance(IAtomContainer.class, new Object[]{mol});
        List<IAtomContainer> tautomers = new ArrayList<IAtomContainer>();
        if (!inchi.contains("(H")) {
            tautomers.add(mol);
            return tautomers;
        }
        Map<Integer, IAtom> inchiAtomsByPosition = this.getElementsByPosition(inchi, mol);
        IAtomContainer inchiMolGraph = this.connectAtoms(inchi, mol, inchiAtomsByPosition);
        if (amap != null && amap.length == mol.getAtomCount()) {
            for (int i = 0; i < amap.length; ++i) {
                mol.getAtom(i).setID(Long.toString(amap[i]));
            }
            mol = AtomContainerManipulator.suppressHydrogens((IAtomContainer)mol);
        } else {
            mol = AtomContainerManipulator.suppressHydrogens((IAtomContainer)mol);
            this.mapInputMoleculeToInchiMolgraph(inchiMolGraph, mol);
        }
        ArrayList<Integer> mobHydrAttachPositions = new ArrayList<Integer>();
        int totalMobHydrCount = this.parseMobileHydrogens(mobHydrAttachPositions, inchi);
        tautomers = this.constructTautomers(mol, mobHydrAttachPositions, totalMobHydrCount);
        return this.removeDuplicates(tautomers);
    }

    private Map<Integer, IAtom> getElementsByPosition(String inputInchi, IAtomContainer inputMolecule) throws CDKException {
        HashMap<Integer, IAtom> inchiAtomsByPosition = new HashMap<Integer, IAtom>();
        int position = 0;
        String inchi = inputInchi;
        String formula = (inchi = inchi.substring(inchi.indexOf(47) + 1)).substring(0, inchi.indexOf(47));
        if (formula.contains(".")) {
            throw new CDKException("Cannot parse InChI, formula contains dot (unsupported feature). Input formula=" + formula);
        }
        Pattern formulaPattern = Pattern.compile("\\.?[0-9]*[A-Z]{1}[a-z]?[0-9]*");
        Matcher match = formulaPattern.matcher(formula);
        while (match.find()) {
            String symbolAndCount = match.group();
            String elementSymbol = symbolAndCount.split("[0-9]")[0];
            if (elementSymbol.equals("H")) continue;
            int elementCnt = 1;
            if (elementSymbol.length() != symbolAndCount.length()) {
                elementCnt = Integer.valueOf(symbolAndCount.substring(elementSymbol.length()));
            }
            for (int i = 0; i < elementCnt; ++i) {
                IAtom atom = (IAtom)inputMolecule.getBuilder().newInstance(IAtom.class, new Object[]{elementSymbol});
                atom.setID(++position + "");
                inchiAtomsByPosition.put(position, atom);
            }
        }
        return inchiAtomsByPosition;
    }

    private IAtomContainer connectAtoms(String inputInchi, IAtomContainer inputMolecule, Map<Integer, IAtom> inchiAtomsByPosition) throws CDKException {
        String inchi = inputInchi;
        inchi = inchi.substring(inchi.indexOf(47) + 1);
        inchi = inchi.substring(inchi.indexOf(47) + 1);
        String connections = inchi.substring(1, inchi.indexOf(47));
        Pattern connectionPattern = Pattern.compile("(-|\\(|\\)|,|([0-9])*)");
        Matcher match = connectionPattern.matcher(connections);
        Stack<IAtom> atomStack = new Stack<IAtom>();
        IAtomContainer inchiMolGraph = (IAtomContainer)inputMolecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        boolean pop = false;
        boolean push = true;
        while (match.find()) {
            String group = match.group();
            push = true;
            if (group.isEmpty()) continue;
            if (group.matches("[0-9]*")) {
                IAtom atom = inchiAtomsByPosition.get(Integer.valueOf(group));
                if (!inchiMolGraph.contains(atom)) {
                    inchiMolGraph.addAtom(atom);
                }
                IAtom prevAtom = null;
                if (atomStack.size() != 0) {
                    prevAtom = pop ? (IAtom)atomStack.pop() : (IAtom)atomStack.get(atomStack.size() - 1);
                    IBond bond = (IBond)inputMolecule.getBuilder().newInstance(IBond.class, new Object[]{prevAtom, atom, IBond.Order.SINGLE});
                    inchiMolGraph.addBond(bond);
                }
                if (!push) continue;
                atomStack.push(atom);
                continue;
            }
            if (group.equals("-")) {
                pop = true;
                push = true;
                continue;
            }
            if (group.equals(",")) {
                atomStack.pop();
                pop = false;
                push = false;
                continue;
            }
            if (group.equals("(")) {
                pop = false;
                push = true;
                continue;
            }
            if (group.equals(")")) {
                atomStack.pop();
                pop = true;
                push = true;
                continue;
            }
            throw new CDKException("Unexpected token " + group + " in connection table encountered.");
        }
        for (IAtom at : inchiAtomsByPosition.values()) {
            if (inchiMolGraph.contains(at)) continue;
            inchiMolGraph.addAtom(at);
        }
        return inchiMolGraph;
    }

    private void mapInputMoleculeToInchiMolgraph(IAtomContainer inchiMolGraph, IAtomContainer mol) throws CDKException {
        Iterator iter = VentoFoggia.findIdentical((IAtomContainer)inchiMolGraph, (AtomMatcher)AtomMatcher.forElement(), (BondMatcher)BondMatcher.forAny()).matchAll(mol).limit(1).toAtomMap().iterator();
        if (iter.hasNext()) {
            for (Map.Entry e : ((Map)iter.next()).entrySet()) {
                IAtom src = (IAtom)e.getKey();
                IAtom dst = (IAtom)e.getValue();
                String position = src.getID();
                dst.setID(position);
                LOGGER.debug((Object)"Mapped InChI ", new Object[]{src.getSymbol(), " ", src.getID(), " to ", dst.getSymbol(), " " + dst.getID()});
            }
        } else {
            throw new IllegalArgumentException(CANSMI.create(inchiMolGraph) + " " + CANSMI.create(mol));
        }
    }

    private int parseMobileHydrogens(List<Integer> mobHydrAttachPositions, String inputInchi) {
        int totalMobHydrCount = 0;
        String hydrogens = "";
        String inchi = inputInchi;
        if (inchi.indexOf("/h") != -1) {
            hydrogens = inchi.substring(inchi.indexOf("/h") + 2);
            if (hydrogens.indexOf(47) != -1) {
                hydrogens = hydrogens.substring(0, hydrogens.indexOf(47));
            }
            String mobileHydrogens = hydrogens.substring(hydrogens.indexOf(40));
            Pattern mobileHydrPattern = Pattern.compile("\\((.)*?\\)");
            Matcher match = mobileHydrPattern.matcher(mobileHydrogens);
            while (match.find()) {
                String mobileHGroup = match.group();
                int mobHCount = 0;
                String head = mobileHGroup.substring(0, mobileHGroup.indexOf(44) + 1);
                if (head.contains("H,")) {
                    head = head.replace("H,", "H1,");
                }
                if (head.contains("-,")) {
                    head = head.replace("-,", "-1,");
                }
                head = head.substring(2);
                Pattern subPattern = Pattern.compile("[0-9]*");
                Matcher subMatch = subPattern.matcher(head);
                while (subMatch.find()) {
                    if (subMatch.group().equals("")) continue;
                    mobHCount += Integer.valueOf(subMatch.group()).intValue();
                }
                totalMobHydrCount += mobHCount;
                mobileHGroup = mobileHGroup.substring(mobileHGroup.indexOf(44) + 1).replace(")", "");
                StringTokenizer tokenizer = new StringTokenizer(mobileHGroup, ",");
                while (tokenizer.hasMoreTokens()) {
                    Integer position = Integer.valueOf(tokenizer.nextToken());
                    mobHydrAttachPositions.add(position);
                }
            }
        }
        LOGGER.debug((Object)"#total mobile hydrogens: ", new Object[]{totalMobHydrCount});
        return totalMobHydrCount;
    }

    private List<IAtomContainer> constructTautomers(IAtomContainer inputMolecule, List<Integer> mobHydrAttachPositions, int totalMobHydrCount) throws CloneNotSupportedException {
        Object bond32;
        ArrayList<IAtomContainer> tautomers = new ArrayList<IAtomContainer>();
        IAtomContainer skeleton = inputMolecule.clone();
        boolean atomsToRemove = true;
        ArrayList<IAtom> removedAtoms = new ArrayList<IAtom>();
        boolean atomRemoved = false;
        while (atomsToRemove) {
            block7: for (IAtom atom : skeleton.atoms()) {
                atomRemoved = false;
                int position = Integer.valueOf(atom.getID());
                if (!mobHydrAttachPositions.contains(position) && atom.getHybridization().equals((Object)IAtomType.Hybridization.SP3)) {
                    skeleton.removeAtomOnly(atom);
                    removedAtoms.add(atom);
                    atomRemoved = true;
                    break;
                }
                for (IBond bond : skeleton.bonds()) {
                    if (!bond.contains(atom) || !bond.getOrder().equals((Object)IBond.Order.TRIPLE)) continue;
                    skeleton.removeAtomOnly(atom);
                    removedAtoms.add(atom);
                    atomRemoved = true;
                    break block7;
                }
            }
            if (atomRemoved) continue;
            atomsToRemove = false;
        }
        boolean bondsToRemove = true;
        boolean bondRemoved = false;
        while (bondsToRemove) {
            block10: for (Object bond32 : skeleton.bonds()) {
                bondRemoved = false;
                for (IAtom removedAtom : removedAtoms) {
                    if (!bond32.contains(removedAtom)) continue;
                    IAtom iAtom = bond32.getOther(removedAtom);
                    int decValence = 0;
                    switch (bond32.getOrder()) {
                        case SINGLE: {
                            decValence = 1;
                            break;
                        }
                        case DOUBLE: {
                            decValence = 2;
                            break;
                        }
                        case TRIPLE: {
                            decValence = 3;
                            break;
                        }
                        case QUADRUPLE: {
                            decValence = 4;
                        }
                    }
                    iAtom.setValency(Integer.valueOf(iAtom.getValency() - decValence));
                    skeleton.removeBond((IBond)bond32);
                    bondRemoved = true;
                    break block10;
                }
            }
            if (bondRemoved) continue;
            bondsToRemove = false;
        }
        int doubleBondCount = 0;
        for (IBond bond2 : skeleton.bonds()) {
            if (!bond2.getOrder().equals((Object)IBond.Order.DOUBLE)) continue;
            ++doubleBondCount;
        }
        bond32 = mobHydrAttachPositions.iterator();
        while (bond32.hasNext()) {
            int hPosition = (Integer)bond32.next();
            IAtom atom = this.findAtomByPosition(skeleton, hPosition);
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
        }
        for (IBond bond4 : skeleton.bonds()) {
            if (!bond4.getOrder().equals((Object)IBond.Order.DOUBLE)) continue;
            bond4.setOrder(IBond.Order.SINGLE);
        }
        ArrayList<List<Integer>> combinations = new ArrayList<List<Integer>>();
        this.combineHydrogenPositions(new ArrayList<Integer>(), combinations, skeleton, totalMobHydrCount, mobHydrAttachPositions);
        Stack<List<Integer>> solutions = new Stack<List<Integer>>();
        for (List list : combinations) {
            IAtom atom;
            Object hPos22;
            IAtomContainer tautomerSkeleton = skeleton.clone();
            for (Object hPos22 : list) {
                atom = this.findAtomByPosition(tautomerSkeleton, (Integer)hPos22);
                atom.setImplicitHydrogenCount(Integer.valueOf(atom.getImplicitHydrogenCount() + 1));
            }
            ArrayList<IAtom> atomsInNeedOfFix = new ArrayList<IAtom>();
            hPos22 = tautomerSkeleton.atoms().iterator();
            while (hPos22.hasNext()) {
                atom = (IAtom)hPos22.next();
                if (atom.getValency() - atom.getFormalCharge() == atom.getImplicitHydrogenCount() + this.getConnectivity(atom, tautomerSkeleton)) continue;
                atomsInNeedOfFix.add(atom);
            }
            List<Integer> dblBondPositions = this.tryDoubleBondCombinations(tautomerSkeleton, 0, 0, doubleBondCount, atomsInNeedOfFix);
            if (dblBondPositions == null) continue;
            solutions.push(dblBondPositions);
            solutions.push((List<Integer>)tautomerSkeleton);
        }
        LOGGER.debug((Object)"#possible solutions : ", new Object[]{solutions.size()});
        if (solutions.size() == 0) {
            LOGGER.error((Object)"Could not generate any tautomers for the input. Is input in Kekule form? ");
            tautomers.add(inputMolecule);
        } else {
            while (solutions.size() != 0) {
                IAtomContainer tautomerSkeleton = (IAtomContainer)solutions.pop();
                List list = (List)solutions.pop();
                IAtomContainer tautomer = inputMolecule.clone();
                for (IAtom skAtom1 : tautomerSkeleton.atoms()) {
                    for (IAtom atom1 : tautomer.atoms()) {
                        if (!atom1.getID().equals(skAtom1.getID())) continue;
                        atom1.setImplicitHydrogenCount(skAtom1.getImplicitHydrogenCount());
                        for (int bondIdx = 0; bondIdx < tautomerSkeleton.getBondCount(); ++bondIdx) {
                            IBond skBond = tautomerSkeleton.getBond(bondIdx);
                            if (!skBond.contains(skAtom1)) continue;
                            IAtom skAtom2 = skBond.getOther(skAtom1);
                            for (IAtom atom2 : tautomer.atoms()) {
                                if (!atom2.getID().equals(skAtom2.getID())) continue;
                                IBond tautBond = tautomer.getBond(atom1, atom2);
                                if (list.contains(bondIdx)) {
                                    tautBond.setOrder(IBond.Order.DOUBLE);
                                    continue;
                                }
                                tautBond.setOrder(IBond.Order.SINGLE);
                            }
                        }
                    }
                }
                for (IAtom atom : tautomer.atoms()) {
                    atom.setFlag(32, false);
                    atom.setValency(null);
                }
                for (IBond bond5 : tautomer.bonds()) {
                    bond5.setFlag(32, false);
                }
                tautomers.add(tautomer);
            }
        }
        LOGGER.debug((Object)"# initial tautomers generated : ", new Object[]{tautomers.size()});
        return tautomers;
    }

    private List<IAtomContainer> removeDuplicates(List<IAtomContainer> tautomers) throws CDKException {
        HashSet<String> cansmis = new HashSet<String>();
        ArrayList<IAtomContainer> result = new ArrayList<IAtomContainer>();
        for (IAtomContainer tautomer : tautomers) {
            if (!cansmis.add(CANSMI.create(tautomer))) continue;
            result.add(tautomer);
        }
        LOGGER.debug((Object)"# tautomers after clean up : ", new Object[]{tautomers.size()});
        return result;
    }

    private void combineHydrogenPositions(List<Integer> taken, List<List<Integer>> combinations, IAtomContainer skeleton, int totalMobHydrCount, List<Integer> mobHydrAttachPositions) {
        if (taken.size() != totalMobHydrCount) {
            for (int i = 0; i < mobHydrAttachPositions.size(); ++i) {
                int pos = mobHydrAttachPositions.get(i);
                IAtom atom = this.findAtomByPosition(skeleton, pos);
                int conn = this.getConnectivity(atom, skeleton);
                int hCnt = 0;
                for (int t : taken) {
                    if (t != pos) continue;
                    ++hCnt;
                }
                if (atom.getValency() - atom.getFormalCharge() <= hCnt + conn) continue;
                taken.add(pos);
                this.combineHydrogenPositions(taken, combinations, skeleton, totalMobHydrCount, mobHydrAttachPositions);
                taken.remove(taken.size() - 1);
            }
        } else {
            ArrayList<Integer> addList = new ArrayList<Integer>(taken.size());
            addList.addAll(taken);
            Collections.sort(addList);
            if (!combinations.contains(addList)) {
                combinations.add(addList);
            }
        }
    }

    private IAtom findAtomByPosition(IAtomContainer container, int position) {
        String pos = String.valueOf(position);
        for (IAtom atom : container.atoms()) {
            if (!atom.getID().equals(pos)) continue;
            return atom;
        }
        return null;
    }

    private List<Integer> tryDoubleBondCombinations(IAtomContainer container, int dblBondsAdded, int bondOffSet, int doubleBondMax, List<IAtom> atomsInNeedOfFix) {
        List<Integer> dblBondPositions = null;
        for (int offSet = bondOffSet; offSet < container.getBondCount() && dblBondPositions == null; ++offSet) {
            IBond bond = container.getBond(offSet);
            if (!atomsInNeedOfFix.contains(bond.getBegin()) || !atomsInNeedOfFix.contains(bond.getEnd())) continue;
            bond.setOrder(IBond.Order.DOUBLE);
            if (++dblBondsAdded == doubleBondMax) {
                boolean validDoubleBondConfig = true;
                for (IAtom atom : container.atoms()) {
                    if (atom.getValency() == atom.getImplicitHydrogenCount() + this.getConnectivity(atom, container)) continue;
                    validDoubleBondConfig = false;
                    break;
                }
                if (validDoubleBondConfig) {
                    dblBondPositions = new ArrayList<Integer>();
                    for (int idx = 0; idx < container.getBondCount(); ++idx) {
                        if (!container.getBond(idx).getOrder().equals((Object)IBond.Order.DOUBLE)) continue;
                        dblBondPositions.add(idx);
                    }
                    return dblBondPositions;
                }
            } else {
                dblBondPositions = this.tryDoubleBondCombinations(container, dblBondsAdded, offSet + 1, doubleBondMax, atomsInNeedOfFix);
            }
            bond.setOrder(IBond.Order.SINGLE);
            --dblBondsAdded;
        }
        return dblBondPositions;
    }

    private int getConnectivity(IAtom atom, IAtomContainer container) {
        int connectivity = 0;
        block6: for (IBond bond : container.bonds()) {
            if (!bond.contains(atom)) continue;
            switch (bond.getOrder()) {
                case SINGLE: {
                    ++connectivity;
                    continue block6;
                }
                case DOUBLE: {
                    connectivity += 2;
                    continue block6;
                }
                case TRIPLE: {
                    connectivity += 3;
                    continue block6;
                }
                case QUADRUPLE: {
                    connectivity += 4;
                    continue block6;
                }
            }
            connectivity += 10;
        }
        return connectivity;
    }
}

