/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.indices;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.XContentParser;

public class IndexTemplateMetadata {
    private static final ConstructingObjectParser<IndexTemplateMetadata, String> PARSER = new ConstructingObjectParser("IndexTemplateMetadata", true, (a, name) -> {
        List alias = (List)a[5];
        ImmutableOpenMap aliasMap = new ImmutableOpenMap.Builder().putAll(alias.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).build();
        return new IndexTemplateMetadata((String)name, (Integer)a[0], (Integer)a[1], (List)a[2], (Settings)a[3], (MappingMetadata)a[4], (ImmutableOpenMap<String, AliasMetadata>)aliasMap);
    });
    private final String name;
    private final int order;
    @Nullable
    private final Integer version;
    private final List<String> patterns;
    private final Settings settings;
    private final MappingMetadata mappings;
    private final ImmutableOpenMap<String, AliasMetadata> aliases;

    public IndexTemplateMetadata(String name, int order, Integer version, List<String> patterns, Settings settings, MappingMetadata mappings, ImmutableOpenMap<String, AliasMetadata> aliases) {
        if (patterns == null || patterns.isEmpty()) {
            throw new IllegalArgumentException("Index patterns must not be null or empty; got " + patterns);
        }
        this.name = name;
        this.order = order;
        this.version = version;
        this.patterns = patterns;
        this.settings = settings;
        this.mappings = mappings;
        this.aliases = aliases;
    }

    public String name() {
        return this.name;
    }

    public int order() {
        return this.order;
    }

    @Nullable
    public Integer version() {
        return this.version;
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public Settings settings() {
        return this.settings;
    }

    public MappingMetadata mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, AliasMetadata> aliases() {
        return this.aliases;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTemplateMetadata that = (IndexTemplateMetadata)o;
        return this.order == that.order && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.patterns, that.patterns) && Objects.equals(this.settings, that.settings) && Objects.equals(this.mappings, that.mappings) && Objects.equals(this.aliases, that.aliases);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.order, this.version, this.patterns, this.settings, this.mappings, this.aliases);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("order", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("version", new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("index_patterns", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            Settings.Builder templateSettingsBuilder = Settings.builder();
            templateSettingsBuilder.put(Settings.fromXContent((XContentParser)p));
            templateSettingsBuilder.normalizePrefix("index.");
            return templateSettingsBuilder.build();
        }, new ParseField("settings", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            Map mapping = p.map();
            if (mapping.isEmpty()) {
                return null;
            }
            return new MappingMetadata("_doc", mapping);
        }, new ParseField("mappings", new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, name) -> new AbstractMap.SimpleEntry<String, AliasMetadata>(name, AliasMetadata.Builder.fromXContent((XContentParser)p)), new ParseField("aliases", new String[0]));
    }

    public static class Builder {
        private String name;
        private int order;
        private Integer version;
        private List<String> indexPatterns;
        private Settings settings = Settings.Builder.EMPTY_SETTINGS;
        private MappingMetadata mappings;
        private final ImmutableOpenMap.Builder<String, AliasMetadata> aliases;

        public Builder(String name) {
            this.name = name;
            this.mappings = null;
            this.aliases = ImmutableOpenMap.builder();
        }

        public Builder(IndexTemplateMetadata indexTemplateMetadata) {
            this.name = indexTemplateMetadata.name();
            this.order(indexTemplateMetadata.order());
            this.version(indexTemplateMetadata.version());
            this.patterns(indexTemplateMetadata.patterns());
            this.settings(indexTemplateMetadata.settings());
            this.mappings = indexTemplateMetadata.mappings();
            this.aliases = ImmutableOpenMap.builder(indexTemplateMetadata.aliases());
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder patterns(List<String> indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder mapping(MappingMetadata mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder putAlias(AliasMetadata aliasMetadata) {
            this.aliases.put((Object)aliasMetadata.alias(), (Object)aliasMetadata);
            return this;
        }

        public Builder putAlias(AliasMetadata.Builder aliasMetadata) {
            this.aliases.put((Object)aliasMetadata.alias(), (Object)aliasMetadata.build());
            return this;
        }

        public IndexTemplateMetadata build() {
            return new IndexTemplateMetadata(this.name, this.order, this.version, this.indexPatterns, this.settings, this.mappings, (ImmutableOpenMap<String, AliasMetadata>)this.aliases.build());
        }

        public static IndexTemplateMetadata fromXContent(XContentParser parser, String templateName) throws IOException {
            return (IndexTemplateMetadata)PARSER.parse(parser, (Object)templateName);
        }
    }
}

