/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.cfg;

import java.io.InputStream;
import java.util.Properties;
import org.opensearch.hadoop.cfg.Settings;

public class FilteredSettings
extends Settings {
    private final Settings parent;
    private final String excludePrefix;

    FilteredSettings(Settings parent, String excludePrefix) {
        this.parent = parent;
        this.excludePrefix = excludePrefix.endsWith(".") ? excludePrefix : excludePrefix + ".";
    }

    private boolean validKey(String key) {
        return !key.startsWith(this.excludePrefix);
    }

    @Override
    public InputStream loadResource(String location) {
        return this.parent.loadResource(location);
    }

    @Override
    public Settings copy() {
        return new FilteredSettings(this.parent.copy(), this.excludePrefix);
    }

    @Override
    public String getProperty(String name) {
        if (this.validKey(name)) {
            return this.parent.getProperty(name);
        }
        return null;
    }

    @Override
    public void setProperty(String name, String value) {
        if (this.validKey(name)) {
            this.parent.setProperty(name, value);
        }
    }

    @Override
    public Properties asProperties() {
        Properties parentSettings = this.parent.asProperties();
        Properties filteredProperties = new Properties();
        for (Object keyObject : parentSettings.keySet()) {
            String key = keyObject.toString();
            if (!this.validKey(key)) continue;
            filteredProperties.put(key, parentSettings.getProperty(key));
        }
        return filteredProperties;
    }
}

