/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.cfg;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.cfg.HadoopSettings;
import org.opensearch.hadoop.cfg.PropertiesSettings;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.cfg.SettingsManager;

public class HadoopSettingsManager
implements SettingsManager<Object> {
    private static final Class<?> HADOOP_CONFIGURATION;

    public static Settings loadFrom(Object configuration) {
        if (configuration instanceof Properties) {
            return new PropertiesSettings((Properties)configuration);
        }
        if (HADOOP_CONFIGURATION != null && HADOOP_CONFIGURATION.isInstance(configuration)) {
            return FromHadoopConfiguration.create(configuration);
        }
        throw new OpenSearchHadoopIllegalArgumentException("Don't know how to create Settings from configuration " + configuration);
    }

    @Override
    public Settings load(Object configuration) {
        return HadoopSettingsManager.loadFrom(configuration);
    }

    static {
        Class<?> cfgClass = null;
        try {
            cfgClass = Class.forName("org.apache.hadoop.conf.Configuration", false, HadoopSettingsManager.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        HADOOP_CONFIGURATION = cfgClass;
    }

    private static abstract class FromHadoopConfiguration {
        private FromHadoopConfiguration() {
        }

        public static Settings create(Object cfg) {
            return new HadoopSettings((Configuration)cfg);
        }
    }
}

