/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.cfg;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.cfg.FieldPresenceValidation;
import org.opensearch.hadoop.cfg.FilteredSettings;
import org.opensearch.hadoop.cfg.InternalConfigurationOptions;
import org.opensearch.hadoop.cfg.SettingsView;
import org.opensearch.hadoop.security.AuthenticationMethod;
import org.opensearch.hadoop.util.ClusterInfo;
import org.opensearch.hadoop.util.ClusterName;
import org.opensearch.hadoop.util.IOUtils;
import org.opensearch.hadoop.util.OpenSearchMajorVersion;
import org.opensearch.hadoop.util.StringUtils;
import org.opensearch.hadoop.util.unit.Booleans;
import org.opensearch.hadoop.util.unit.ByteSizeValue;
import org.opensearch.hadoop.util.unit.TimeValue;

public abstract class Settings {
    public OpenSearchMajorVersion getInternalVersionOrThrow() {
        String version = this.getProperty("opensearch.internal.opensearch.version", null);
        if (version == null) {
            throw new IllegalArgumentException("OpenSearch version:[ opensearch.internal.opensearch.version] not present in configuration");
        }
        return OpenSearchMajorVersion.parse(version);
    }

    @Deprecated
    public OpenSearchMajorVersion getInternalVersionOrLatest() {
        String version = this.getProperty("opensearch.internal.opensearch.version", null);
        if (version == null) {
            return OpenSearchMajorVersion.LATEST;
        }
        return OpenSearchMajorVersion.parse(version);
    }

    public ClusterInfo getClusterInfoOrThrow() {
        ClusterInfo clusterInfo = this.getClusterInfoOrNull();
        if (clusterInfo == null) {
            throw new IllegalArgumentException("OpenSearch cluster name:[ opensearch.internal.opensearch.cluster.name] not present in configuration");
        }
        return clusterInfo;
    }

    public ClusterInfo getClusterInfoOrNull() {
        String clusterName = this.getProperty("opensearch.internal.opensearch.cluster.name");
        if (clusterName == null) {
            return null;
        }
        String clusterUUID = this.getProperty("opensearch.internal.opensearch.cluster.uuid");
        OpenSearchMajorVersion version = this.getInternalVersionOrThrow();
        return new ClusterInfo(new ClusterName(clusterName, clusterUUID), version);
    }

    @Deprecated
    public ClusterInfo getClusterInfoOrUnnamedLatest() {
        String clusterName = this.getProperty("opensearch.internal.opensearch.cluster.name");
        if (clusterName == null) {
            return ClusterInfo.unnamedLatest();
        }
        String clusterUUID = this.getProperty("opensearch.internal.opensearch.cluster.uuid");
        OpenSearchMajorVersion version = this.getInternalVersionOrLatest();
        return new ClusterInfo(new ClusterName(clusterName, clusterUUID), version);
    }

    public String getNodes() {
        return this.getProperty("opensearch.nodes", "localhost");
    }

    public int getPort() {
        return Integer.valueOf(this.getProperty("opensearch.port", "9200"));
    }

    public boolean getNodesDiscovery() {
        return Booleans.parseBoolean(this.getProperty("opensearch.nodes.discovery"), !this.getNodesWANOnly());
    }

    public String getShardPreference() {
        return this.getProperty("opensearch.read.shard.preference", "");
    }

    public String getNodesPathPrefix() {
        return this.getProperty("opensearch.nodes.path.prefix", "");
    }

    public boolean getNodesDataOnly() {
        return Booleans.parseBoolean(this.getProperty("opensearch.nodes.data.only"), !this.getNodesWANOnly() && !this.getNodesClientOnly() && !this.getNodesIngestOnly());
    }

    public boolean getNodesIngestOnly() {
        return Booleans.parseBoolean(this.getProperty("opensearch.nodes.ingest.only", "false"));
    }

    public boolean getNodesClientOnly() {
        return Booleans.parseBoolean(this.getProperty("opensearch.nodes.client.only", "false"));
    }

    public boolean getNodesWANOnly() {
        return Booleans.parseBoolean(this.getProperty("opensearch.nodes.wan.only", "false"));
    }

    public long getHttpTimeout() {
        return TimeValue.parseTimeValue(this.getProperty("opensearch.http.timeout", "1m")).getMillis();
    }

    public int getHttpRetries() {
        return Integer.valueOf(this.getProperty("opensearch.http.retries", "3"));
    }

    public int getBatchSizeInBytes() {
        return ByteSizeValue.parseBytesSizeValue(this.getProperty("opensearch.batch.size.bytes", "1mb")).bytesAsInt();
    }

    public int getBatchSizeInEntries() {
        return Integer.valueOf(this.getProperty("opensearch.batch.size.entries", "1000"));
    }

    public int getBatchWriteRetryCount() {
        return Integer.parseInt(this.getProperty("opensearch.batch.write.retry.count", "3"));
    }

    public int getBatchWriteRetryLimit() {
        return Integer.parseInt(this.getProperty("opensearch.batch.write.retry.limit", "50"));
    }

    public long getBatchWriteRetryWait() {
        return TimeValue.parseTimeValue(this.getProperty("opensearch.batch.write.retry.wait", "10s")).getMillis();
    }

    public String getBatchWriteRetryPolicy() {
        return this.getProperty("opensearch.batch.write.retry.policy", "simple");
    }

    public boolean getBatchRefreshAfterWrite() {
        return Booleans.parseBoolean(this.getProperty("opensearch.batch.write.refresh", "true"));
    }

    public boolean getBatchFlushManual() {
        return Booleans.parseBoolean(this.getProperty("opensearch.batch.flush.manual", "false"));
    }

    public long getScrollKeepAlive() {
        return TimeValue.parseTimeValue(this.getProperty("opensearch.scroll.keepalive", "5m")).getMillis();
    }

    public long getScrollSize() {
        return Long.valueOf(this.getProperty("opensearch.scroll.size", "1000"));
    }

    public long getScrollLimit() {
        return Long.valueOf(this.getProperty("opensearch.scroll.limit", "-1"));
    }

    public String getScrollFields() {
        return this.getProperty("opensearch.internal.mr.target.fields");
    }

    public boolean getExcludeSource() {
        return Booleans.parseBoolean(this.getProperty("opensearch.internal.exclude.source", "false"));
    }

    public String getSerializerValueWriterClassName() {
        return this.getProperty("opensearch.ser.writer.value.class");
    }

    public String getSerializerBytesConverterClassName() {
        return this.getProperty("opensearch.ser.writer.bytes.class");
    }

    public String getSerializerValueReaderClassName() {
        return this.getProperty("opensearch.ser.reader.value.class");
    }

    public boolean getIndexAutoCreate() {
        return Booleans.parseBoolean(this.getProperty("opensearch.index.auto.create", "yes"));
    }

    public boolean getIndexReadMissingAsEmpty() {
        return Booleans.parseBoolean(this.getProperty("opensearch.index.read.missing.as.empty", "false"));
    }

    public boolean getIndexReadAllowRedStatus() {
        return Booleans.parseBoolean(this.getProperty("opensearch.index.read.allow.red.status", "false"));
    }

    public boolean getInputAsJson() {
        return Booleans.parseBoolean(this.getProperty("opensearch.input.json", "no"));
    }

    public boolean getOutputAsJson() {
        return Booleans.parseBoolean(this.getProperty("opensearch.output.json", "no"));
    }

    public String getOperation() {
        return this.getProperty("opensearch.write.operation", "index").toLowerCase(Locale.ROOT);
    }

    public String getMappingId() {
        return this.getProperty("opensearch.mapping.id");
    }

    public String getMappingParent() {
        return this.getProperty("opensearch.mapping.parent");
    }

    public String getMappingJoin() {
        return this.getProperty("opensearch.mapping.join");
    }

    public String getMappingVersion() {
        return this.getProperty("opensearch.mapping.version");
    }

    public boolean hasMappingVersionType() {
        String versionType = this.getMappingVersionType();
        return StringUtils.hasText(this.getMappingVersion()) && StringUtils.hasText(versionType) && !versionType.equals("internal");
    }

    public String getMappingVersionType() {
        return this.getProperty("opensearch.mapping.version.type", "external");
    }

    public String getMappingRouting() {
        return this.getProperty("opensearch.mapping.routing");
    }

    public String getMappingDefaultClassExtractor() {
        return this.getProperty("opensearch.mapping.default.extractor.class");
    }

    public String getMappingMetadataExtractorClassName() {
        return this.getProperty("opensearch.mapping.metadata.extractor.class");
    }

    public String getMappingIdExtractorClassName() {
        return this.getProperty("opensearch.mapping.id.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingParentExtractorClassName() {
        return this.getProperty("opensearch.mapping.parent.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingJoinExtractorClassName() {
        return this.getProperty("opensearch.mapping.join.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingVersionExtractorClassName() {
        return this.getProperty("opensearch.mapping.version.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingRoutingExtractorClassName() {
        return this.getProperty("opensearch.mapping.routing.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingIndexExtractorClassName() {
        return this.getProperty("opensearch.mapping.index.extractor.class", InternalConfigurationOptions.OPENSEARCH_MAPPING_DEFAULT_INDEX_EXTRACTOR_CLASS);
    }

    public String getMappingIndexFormatterClassName() {
        return this.getProperty("opensearch.mapping.index.formatter.class", InternalConfigurationOptions.OPENSEARCH_MAPPING_DEFAULT_INDEX_FORMATTER_CLASS);
    }

    public String getMappingParamsExtractorClassName() {
        return this.getProperty("opensearch.mapping.params.extractor.class", InternalConfigurationOptions.OPENSEARCH_MAPPING_PARAMS_DEFAULT_EXTRACTOR_CLASS);
    }

    public boolean getMappingConstantAutoQuote() {
        return Booleans.parseBoolean(this.getProperty("opensearch.mapping.constant.auto.quote", "true"));
    }

    public boolean getMappingDateRich() {
        return Booleans.parseBoolean(this.getProperty("opensearch.mapping.date.rich", "true"));
    }

    public String getMappingIncludes() {
        return this.getProperty("opensearch.mapping.include", "");
    }

    public String getMappingExcludes() {
        return this.getProperty("opensearch.mapping.exclude", "");
    }

    public String getIngestPipeline() {
        return this.getProperty("opensearch.ingest.pipeline", "");
    }

    public int getUpdateRetryOnConflict() {
        return Integer.parseInt(this.getProperty("opensearch.update.retry.on.conflict", "0"));
    }

    public String getUpdateScript() {
        return this.getProperty("opensearch.update.script");
    }

    public String getUpdateScriptInline() {
        return this.getLegacyProperty("opensearch.update.script", "opensearch.update.script.inline", null);
    }

    public Boolean getUpdateScriptUpsert() {
        return Booleans.parseBoolean(this.getProperty("opensearch.update.script.upsert", "false"));
    }

    public String getUpdateScriptFile() {
        return this.getProperty("opensearch.update.script.file");
    }

    public String getUpdateScriptStored() {
        return this.getProperty("opensearch.update.script.stored");
    }

    public String getUpdateScriptLang() {
        return this.getProperty("opensearch.update.script.lang");
    }

    public String getUpdateScriptParams() {
        return this.getProperty("opensearch.update.script.params");
    }

    public String getUpdateScriptParamsJson() {
        return this.getProperty("opensearch.update.script.params.json");
    }

    public boolean hasUpdateScript() {
        String op = this.getOperation();
        boolean hasScript = false;
        if ("update".equals(op) || "upsert".equals(op)) {
            hasScript = StringUtils.hasText(this.getUpdateScriptInline());
            hasScript |= StringUtils.hasText(this.getUpdateScriptFile());
            hasScript |= StringUtils.hasText(this.getUpdateScriptStored());
        }
        return hasScript;
    }

    public boolean hasUpdateScriptParams() {
        return this.hasUpdateScript() && StringUtils.hasText(this.getUpdateScriptParams());
    }

    public boolean hasUpdateScriptParamsJson() {
        return this.hasUpdateScript() && StringUtils.hasText(this.getUpdateScriptParamsJson());
    }

    public boolean hasScriptUpsert() {
        String op = this.getOperation();
        return "upsert".equals(op) && this.getUpdateScriptUpsert() != false;
    }

    private String getLegacyProperty(String legacyProperty, String newProperty, String defaultValue) {
        String legacy = this.getProperty(legacyProperty);
        if (StringUtils.hasText(legacy)) {
            LogFactory.getLog(Settings.class).warn((Object)String.format(Locale.ROOT, "[%s] property has been deprecated - use [%s] instead", legacyProperty, newProperty));
            return legacy;
        }
        return this.getProperty(newProperty, defaultValue);
    }

    public boolean getReadFieldEmptyAsNull() {
        return Booleans.parseBoolean(this.getLegacyProperty("opensearch.field.read.empty.as.null", "opensearch.read.field.empty.as.null", "yes"));
    }

    public FieldPresenceValidation getReadFieldExistanceValidation() {
        return FieldPresenceValidation.valueOf(this.getLegacyProperty("opensearch.field.read.validate.presence", "opensearch.read.field.validate.presence", "warn").toUpperCase(Locale.ENGLISH));
    }

    public String getReadFieldInclude() {
        return this.getProperty("opensearch.read.field.include", "");
    }

    public String getReadFieldExclude() {
        return this.getProperty("opensearch.read.field.exclude", "");
    }

    public String getReadFieldAsArrayInclude() {
        return this.getProperty("opensearch.read.field.as.array.include", "");
    }

    public String getReadFieldAsArrayExclude() {
        return this.getProperty("opensearch.read.field.as.array.exclude", "");
    }

    public String getReadSourceFilter() {
        return this.getProperty("opensearch.read.source.filter", "");
    }

    public TimeValue getHeartBeatLead() {
        return TimeValue.parseTimeValue(this.getProperty("opensearch.action.heart.beat.lead", "15s"));
    }

    public TimeValue getTransportPoolingExpirationTimeout() {
        return TimeValue.parseTimeValue(this.getProperty("opensearch.net.transport.pooling.expiration.timeout", "5m"));
    }

    public boolean getNetworkSSLEnabled() {
        return Booleans.parseBoolean(this.getProperty("opensearch.net.ssl", "false"));
    }

    public String getNetworkSSLKeyStoreLocation() {
        return this.getProperty("opensearch.net.ssl.keystore.location");
    }

    public String getNetworkSSLProtocol() {
        return this.getProperty("opensearch.net.ssl.protocol", "TLS");
    }

    public String getNetworkSSLKeyStoreType() {
        return this.getProperty("opensearch.net.ssl.keystore.type", "JKS");
    }

    @Deprecated
    public String getNetworkSSLKeyStorePass() {
        return this.getProperty("opensearch.net.ssl.keystore.pass");
    }

    public String getNetworkSSLTrustStoreLocation() {
        return this.getProperty("opensearch.net.ssl.truststore.location");
    }

    @Deprecated
    public String getNetworkSSLTrustStorePass() {
        return this.getProperty("opensearch.net.ssl.truststore.pass");
    }

    public boolean getNetworkSSLAcceptSelfSignedCert() {
        return Booleans.parseBoolean(this.getProperty("opensearch.net.ssl.cert.allow.self.signed", "false"));
    }

    public String getNetworkHttpAuthUser() {
        return this.getProperty("opensearch.net.http.auth.user");
    }

    @Deprecated
    public String getNetworkHttpAuthPass() {
        return this.getProperty("opensearch.net.http.auth.pass");
    }

    public String getNetworkSpnegoAuthElasticsearchPrincipal() {
        return this.getProperty("opensearch.net.spnego.auth.opensearch.principal");
    }

    public boolean getNetworkSpnegoAuthMutual() {
        return Booleans.parseBoolean(this.getProperty("opensearch.net.spnego.auth.mutual", "false"));
    }

    public String getNetworkProxyHttpHost() {
        return this.getProperty("opensearch.net.proxy.http.host");
    }

    public int getNetworkProxyHttpPort() {
        return Integer.valueOf(this.getProperty("opensearch.net.proxy.http.port", "-1"));
    }

    public String getNetworkProxyHttpUser() {
        return this.getProperty("opensearch.net.proxy.http.user");
    }

    @Deprecated
    public String getNetworkProxyHttpPass() {
        return this.getProperty("opensearch.net.proxy.http.pass");
    }

    public boolean getNetworkHttpUseSystemProperties() {
        return Booleans.parseBoolean(this.getProperty("opensearch.net.proxy.http.use.system.props", "yes"));
    }

    public String getNetworkProxyHttpsHost() {
        return this.getProperty("opensearch.net.proxy.https.host");
    }

    public int getNetworkProxyHttpsPort() {
        return Integer.valueOf(this.getProperty("opensearch.net.proxy.https.port", "-1"));
    }

    public String getNetworkProxyHttpsUser() {
        return this.getProperty("opensearch.net.proxy.https.user");
    }

    @Deprecated
    public String getNetworkProxyHttpsPass() {
        return this.getProperty("opensearch.net.proxy.https.pass");
    }

    public boolean getNetworkHttpsUseSystemProperties() {
        return Booleans.parseBoolean(this.getProperty("opensearch.net.proxy.https.use.system.props", "yes"));
    }

    public String getNetworkProxySocksHost() {
        return this.getProperty("opensearch.net.proxy.socks.host");
    }

    public int getNetworkProxySocksPort() {
        return Integer.valueOf(this.getProperty("opensearch.net.proxy.socks.port", "-1"));
    }

    public String getNetworkProxySocksUser() {
        return this.getProperty("opensearch.net.proxy.socks.user");
    }

    @Deprecated
    public String getNetworkProxySocksPass() {
        return this.getProperty("opensearch.net.proxy.socks.pass");
    }

    public boolean getNetworkSocksUseSystemProperties() {
        return Booleans.parseBoolean(this.getProperty("opensearch.net.proxy.socks.use.system.props", "yes"));
    }

    public boolean getNodesResolveHostnames() {
        return Booleans.parseBoolean(this.getProperty("opensearch.nodes.resolve.hostname"), !this.getNodesWANOnly());
    }

    public Settings setInternalClusterInfo(ClusterInfo clusterInfo) {
        this.setProperty("opensearch.internal.opensearch.cluster.name", clusterInfo.getClusterName().getName());
        if (clusterInfo.getClusterName().getUUID() != null) {
            this.setProperty("opensearch.internal.opensearch.cluster.uuid", clusterInfo.getClusterName().getUUID());
        }
        this.setProperty("opensearch.internal.opensearch.version", clusterInfo.getMajorVersion().toString());
        return this;
    }

    @Deprecated
    public Settings setInternalVersion(OpenSearchMajorVersion version) {
        this.setProperty("opensearch.internal.opensearch.version", version.toString());
        return this;
    }

    public Settings setNodes(String hosts) {
        this.setProperty("opensearch.nodes", hosts);
        return this;
    }

    @Deprecated
    public Settings setHosts(String hosts) {
        return this.setNodes(hosts);
    }

    public Settings setPort(int port) {
        this.setProperty("opensearch.port", "" + port);
        return this;
    }

    public Settings setResourceRead(String index) {
        this.setProperty("opensearch.resource.read", index);
        return this;
    }

    public Settings setResourceWrite(String index) {
        this.setProperty("opensearch.resource.write", index);
        return this;
    }

    public Settings setQuery(String query) {
        this.setProperty("opensearch.query", StringUtils.hasText(query) ? query : "");
        return this;
    }

    public Settings setMaxDocsPerPartition(int size) {
        this.setProperty("opensearch.input.max.docs.per.partition", Integer.toString(size));
        return this;
    }

    protected String getResource() {
        return this.getProperty("opensearch.resource");
    }

    public String getResourceRead() {
        return this.getProperty("opensearch.resource.read", this.getResource());
    }

    public String getResourceWrite() {
        return this.getProperty("opensearch.resource.write", this.getResource());
    }

    public String getQuery() {
        return this.getProperty("opensearch.query");
    }

    public Integer getMaxDocsPerPartition() {
        String value = this.getProperty("opensearch.input.max.docs.per.partition");
        if (StringUtils.hasText(value)) {
            return Integer.parseInt(value);
        }
        return null;
    }

    public boolean getReadMetadata() {
        return Booleans.parseBoolean(this.getProperty("opensearch.read.metadata", "false"));
    }

    public String getReadMetadataField() {
        return this.getProperty("opensearch.read.metadata.field", "_metadata");
    }

    public boolean getReadMetadataVersion() {
        return Booleans.parseBoolean(this.getProperty("opensearch.read.metadata.version", "false"));
    }

    public boolean getReadMappingMissingFieldsIgnore() {
        return Booleans.parseBoolean(this.getProperty("opensearch.read.unmapped.fields.ignore", "true"));
    }

    public boolean getDataFrameWriteNullValues() {
        return Booleans.parseBoolean(this.getProperty("opensearch.spark.dataframe.write.null", "false"));
    }

    public AuthenticationMethod getSecurityAuthenticationMethod() {
        AuthenticationMethod authMode = null;
        String authSetting = this.getProperty("opensearch.security.authentication");
        if (authSetting != null && (authMode = AuthenticationMethod.get(authSetting)) == null) {
            throw new OpenSearchHadoopIllegalArgumentException("Could not determine auth mode. Property [opensearch.security.authentication] was set to unknown mode [" + authSetting + "]. Use a valid auth mode from the following: " + AuthenticationMethod.getAvailableMethods());
        }
        if (authMode == null && this.getNetworkHttpAuthUser() != null) {
            authMode = AuthenticationMethod.BASIC;
        } else if (authMode == null) {
            authMode = AuthenticationMethod.SIMPLE;
        }
        return authMode;
    }

    public String getSecurityUserProviderClass() {
        return this.getProperty("opensearch.security.user.provider.class");
    }

    public abstract InputStream loadResource(String var1);

    public abstract Settings copy();

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (!StringUtils.hasText(value)) {
            return defaultValue;
        }
        return value;
    }

    public abstract String getProperty(String var1);

    public abstract void setProperty(String var1, String var2);

    public Settings getSettingsView(String name) {
        return new SettingsView(this, name);
    }

    public Settings excludeFilter(String prefix) {
        return new FilteredSettings(this, prefix);
    }

    public Settings merge(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return this;
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        Object prop = null;
        while (propertyNames.hasMoreElements()) {
            prop = propertyNames.nextElement();
            if (!(prop instanceof String)) continue;
            Object value = properties.get(prop);
            this.setProperty(prop, value.toString());
        }
        return this;
    }

    public Settings merge(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Settings load(String source) {
        Properties copy = IOUtils.propsFromString(source);
        this.merge(copy);
        return this;
    }

    public String save() {
        Properties copy = this.asProperties();
        return IOUtils.propsToString(copy);
    }

    public abstract Properties asProperties();

    public Settings setOpaqueId(String opaqueId) {
        this.setProperty("opensearch.net.http.header.X-Opaque-ID", this.cleanOpaqueId(opaqueId));
        return this;
    }

    private String cleanOpaqueId(String opaqueId) {
        char[] chars = opaqueId.toCharArray();
        StringBuilder cleanedOpaqueId = new StringBuilder(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            char character = chars[i];
            if (character <= '\u001f' || character >= '\u007f') continue;
            cleanedOpaqueId.append(chars[i]);
        }
        return cleanedOpaqueId.toString();
    }

    public String getOpaqueId() {
        return this.getProperty("opensearch.net.http.header.X-Opaque-ID");
    }

    public Settings setUserAgent(String userAgent) {
        this.setProperty("opensearch.net.http.header.User-Agent", this.cleanOpaqueId(userAgent));
        return this;
    }

    public Boolean getAwsSigV4Enabled() {
        return Booleans.parseBoolean(this.getProperty("opensearch.aws.sigv4.enabled", "false"));
    }

    public String getAwsSigV4Region() {
        return this.getProperty("opensearch.aws.sigv4.region", "us-east-1");
    }

    public String getAwsSigV4ServiceName() {
        return this.getProperty("opensearch.aws.sigv4.service.name", "es");
    }
}

