/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.handler.impl.opensearch;

import java.io.IOException;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import org.opensearch.hadoop.handler.Exceptional;
import org.opensearch.hadoop.handler.impl.opensearch.EventConverter;
import org.opensearch.hadoop.rest.OpenSearchHadoopRemoteException;
import org.opensearch.hadoop.util.BytesArray;
import org.opensearch.hadoop.util.ecs.ElasticCommonSchema;
import org.opensearch.hadoop.util.ecs.MessageTemplate;

public abstract class BaseEventConverter<E extends Exceptional>
implements EventConverter<E> {
    private final String eventType;
    private final String eventMessage;

    public BaseEventConverter(String eventType, String eventMessage) {
        this.eventType = eventType;
        this.eventMessage = eventMessage;
    }

    @Override
    public ElasticCommonSchema.TemplateBuilder configureTemplate(ElasticCommonSchema.TemplateBuilder templateBuilder) {
        return templateBuilder.setEventType(this.eventType);
    }

    @Override
    public BytesArray generateEvent(E event, MessageTemplate template) throws IOException {
        String timestamp = this.getTimestamp(event);
        String eventMessage = this.renderEventMessage(event);
        String exceptionType = this.renderExceptionType(event);
        String exceptionMessage = this.renderExceptionMessage(event);
        String rawEvent = this.getRawEvent(event);
        return template.generateMessage(timestamp, eventMessage, exceptionType, exceptionMessage, rawEvent);
    }

    public String getTimestamp(E event) {
        long millis = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return DatatypeConverter.printDateTime((Calendar)cal);
    }

    public String renderEventMessage(E event) {
        return this.eventMessage;
    }

    public String renderExceptionType(E event) {
        Exception exception = event.getException();
        if (exception instanceof OpenSearchHadoopRemoteException) {
            OpenSearchHadoopRemoteException remoteException = (OpenSearchHadoopRemoteException)exception;
            return remoteException.getType();
        }
        String classText = exception.getClass().getSimpleName();
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (char c : classText.toCharArray()) {
            if (Character.isUpperCase(c)) {
                if (first) {
                    first = false;
                } else {
                    builder.append("_");
                }
                builder.append(Character.toLowerCase(c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public String renderExceptionMessage(E event) {
        return event.getException().getMessage();
    }

    public abstract String getRawEvent(E var1) throws IOException;
}

