/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.mr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.util.Progressable;
import org.opensearch.hadoop.cfg.HadoopSettings;
import org.opensearch.hadoop.cfg.HadoopSettingsManager;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.mr.HadoopCfgUtils;
import org.opensearch.hadoop.mr.HeartBeat;
import org.opensearch.hadoop.mr.LinkedMapWritable;
import org.opensearch.hadoop.mr.ReportingUtils;
import org.opensearch.hadoop.mr.WritableValueReader;
import org.opensearch.hadoop.mr.compat.CompatHandler;
import org.opensearch.hadoop.mr.compat.TaskAttemptContext;
import org.opensearch.hadoop.mr.security.HadoopUserProvider;
import org.opensearch.hadoop.rest.InitializationUtils;
import org.opensearch.hadoop.rest.PartitionDefinition;
import org.opensearch.hadoop.rest.RestRepository;
import org.opensearch.hadoop.rest.RestService;
import org.opensearch.hadoop.rest.ScrollQuery;
import org.opensearch.hadoop.rest.SearchRequestBuilder;
import org.opensearch.hadoop.rest.stats.Stats;
import org.opensearch.hadoop.serialization.ScrollReader;

public class OpenSearchInputFormat<K, V>
extends InputFormat<K, V>
implements org.apache.hadoop.mapred.InputFormat<K, V> {
    private static Log log = LogFactory.getLog(OpenSearchInputFormat.class);

    public List<org.apache.hadoop.mapreduce.InputSplit> getSplits(JobContext context) throws IOException {
        JobConf conf = HadoopCfgUtils.asJobConf(CompatHandler.jobContext(context).getConfiguration());
        return Arrays.asList((org.apache.hadoop.mapreduce.InputSplit[])this.getSplits(conf, conf.getNumMapTasks()));
    }

    public OpenSearchInputRecordReader<K, V> createRecordReader(org.apache.hadoop.mapreduce.InputSplit split, org.apache.hadoop.mapreduce.TaskAttemptContext context) {
        return this.isOutputAsJson(CompatHandler.taskAttemptContext(context).getConfiguration()) ? new JsonWritableOpenSearchInputRecordReader() : new WritableOpenSearchInputRecordReader();
    }

    @Deprecated
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Settings settings = HadoopSettingsManager.loadFrom(job);
        List<PartitionDefinition> partitions = RestService.findPartitions(settings, log);
        InputSplit[] splits = new OpenSearchInputSplit[partitions.size()];
        int index = 0;
        for (PartitionDefinition part : partitions) {
            splits[index++] = new OpenSearchInputSplit(part);
        }
        log.info((Object)String.format("Created [%d] splits", splits.length));
        return splits;
    }

    @Deprecated
    public OpenSearchInputRecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) {
        return this.isOutputAsJson((Configuration)job) ? new JsonWritableOpenSearchInputRecordReader(split, (Configuration)job, reporter) : new WritableOpenSearchInputRecordReader(split, (Configuration)job, reporter);
    }

    protected boolean isOutputAsJson(Configuration cfg) {
        return new HadoopSettings(cfg).getOutputAsJson();
    }

    protected static class JsonWritableOpenSearchInputRecordReader
    extends AbstractWritableOpenSearchInputRecordReader<Text> {
        public JsonWritableOpenSearchInputRecordReader() {
        }

        public JsonWritableOpenSearchInputRecordReader(InputSplit split, Configuration job, Reporter reporter) {
            super(split, job, reporter);
        }

        @Override
        public Text createValue() {
            return new Text();
        }

        @Override
        protected Text setCurrentValue(Text hadoopValue, Object object) {
            if (hadoopValue != null) {
                hadoopValue.set(object.toString());
            }
            return hadoopValue;
        }
    }

    protected static class WritableOpenSearchInputRecordReader
    extends AbstractWritableOpenSearchInputRecordReader<Map<Writable, Writable>> {
        private boolean useLinkedMapWritable = true;

        public WritableOpenSearchInputRecordReader() {
        }

        public WritableOpenSearchInputRecordReader(InputSplit split, Configuration job, Reporter reporter) {
            super(split, job, reporter);
        }

        @Override
        void init(OpenSearchInputSplit openSearchSplit, Configuration cfg, Progressable progressable) {
            this.useLinkedMapWritable = !MapWritable.class.getName().equals(HadoopCfgUtils.getMapValueClass(cfg));
            super.init(openSearchSplit, cfg, progressable);
        }

        @Override
        public Map<Writable, Writable> createValue() {
            return this.useLinkedMapWritable ? new LinkedMapWritable() : new MapWritable();
        }

        @Override
        protected Map<Writable, Writable> setCurrentValue(Map<Writable, Writable> hadoopValue, Object object) {
            if (hadoopValue != null) {
                hadoopValue.clear();
                Map val = (Map)object;
                hadoopValue.putAll(val);
            }
            return hadoopValue;
        }
    }

    protected static class OpenSearchInputSplit
    extends org.apache.hadoop.mapreduce.InputSplit
    implements InputSplit {
        private PartitionDefinition partition;

        public OpenSearchInputSplit() {
        }

        public OpenSearchInputSplit(PartitionDefinition partition) {
            this.partition = partition;
        }

        public long getLength() {
            return 1L;
        }

        public String[] getLocations() {
            return this.partition.getHostNames();
        }

        public void write(DataOutput out) throws IOException {
            this.partition.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.partition = new PartitionDefinition(in);
        }

        public PartitionDefinition getPartition() {
            return this.partition;
        }

        public String toString() {
            return "OpenSearchInputSplit{" + (this.partition == null ? "NULL" : this.partition.toString()) + "}";
        }
    }

    protected static abstract class OpenSearchInputRecordReader<K, V>
    extends RecordReader<K, V>
    implements org.apache.hadoop.mapred.RecordReader<K, V> {
        private int read = 0;
        private OpenSearchInputSplit openSearchSplit;
        private ScrollReader scrollReader;
        private RestRepository client;
        private SearchRequestBuilder queryBuilder;
        private ScrollQuery scrollQuery;
        private K currentKey;
        private V currentValue;
        private long size = 0L;
        private HeartBeat beat;
        private Progressable progressable;

        public OpenSearchInputRecordReader() {
        }

        public OpenSearchInputRecordReader(InputSplit split, Configuration job, Reporter reporter) {
            reporter.setStatus(split.toString());
            this.init((OpenSearchInputSplit)split, job, (Progressable)reporter);
        }

        public void initialize(org.apache.hadoop.mapreduce.InputSplit split, org.apache.hadoop.mapreduce.TaskAttemptContext context) throws IOException {
            TaskAttemptContext compatContext = CompatHandler.taskAttemptContext(context);
            compatContext.setStatus(split.toString());
            this.init((OpenSearchInputSplit)split, compatContext.getConfiguration(), compatContext);
        }

        void init(OpenSearchInputSplit openSearchSplit, Configuration cfg, Progressable progressable) {
            Settings settings = HadoopSettingsManager.loadFrom(cfg).copy().load(openSearchSplit.getPartition().getSerializedSettings());
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Init shard reader from cfg %s", HadoopCfgUtils.asProperties(cfg)));
                log.trace((Object)String.format("Init shard reader w/ settings %s", settings));
            }
            this.openSearchSplit = openSearchSplit;
            InitializationUtils.setValueReaderIfNotSet(settings, WritableValueReader.class, log);
            InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, log);
            PartitionDefinition part = openSearchSplit.getPartition();
            RestService.PartitionReader partitionReader = RestService.createReader(settings, part, log);
            this.scrollReader = partitionReader.scrollReader;
            this.client = partitionReader.client;
            this.queryBuilder = partitionReader.queryBuilder;
            this.progressable = progressable;
            if (progressable != null) {
                this.beat = new HeartBeat(progressable, cfg, settings.getHeartBeatLead(), log);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Initializing RecordReader for [%s]", new Object[]{openSearchSplit}));
            }
        }

        public boolean nextKeyValue() throws IOException {
            this.currentKey = this.createKey();
            this.currentValue = this.createValue();
            return this.next(this.currentKey, this.currentValue);
        }

        public K getCurrentKey() throws IOException {
            return this.currentKey;
        }

        public V getCurrentValue() {
            return this.currentValue;
        }

        public float getProgress() {
            return this.size == 0L ? 0.0f : (float)this.getPos() / (float)this.size;
        }

        public void close() throws IOException {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Closing RecordReader for [%s]", new Object[]{this.openSearchSplit}));
                }
                if (this.beat != null) {
                    this.beat.stop();
                }
                if (this.scrollQuery != null) {
                    this.scrollQuery.close();
                }
                if (this.client != null) {
                    this.client.close();
                }
            }
            finally {
                Stats stats = new Stats();
                if (this.client != null) {
                    stats.aggregate(this.client.stats());
                    this.client = null;
                }
                if (this.scrollQuery != null) {
                    stats.aggregate(this.scrollQuery.stats());
                    this.scrollQuery = null;
                }
                ReportingUtils.report(this.progressable, stats);
            }
        }

        public boolean next(K key, V value) throws IOException {
            boolean hasNext;
            if (this.scrollQuery == null) {
                if (this.beat != null) {
                    this.beat.start();
                }
                this.scrollQuery = this.queryBuilder.build(this.client, this.scrollReader);
                this.size = this.scrollQuery.getSize();
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Received scroll [%s],  size [%d] for query [%s]", this.scrollQuery, this.size, this.queryBuilder));
                }
            }
            if (!(hasNext = this.scrollQuery.hasNext())) {
                return false;
            }
            Object[] next = this.scrollQuery.next();
            this.currentKey = this.setCurrentKey(key, next[0]);
            this.currentValue = this.setCurrentValue(value, next[1]);
            ++this.read;
            return true;
        }

        public abstract K createKey();

        public abstract V createValue();

        protected abstract K setCurrentKey(K var1, Object var2);

        protected abstract V setCurrentValue(V var1, Object var2);

        public long getPos() {
            return this.read;
        }
    }

    protected static abstract class AbstractWritableOpenSearchInputRecordReader<V>
    extends OpenSearchInputRecordReader<Text, V> {
        public AbstractWritableOpenSearchInputRecordReader() {
        }

        public AbstractWritableOpenSearchInputRecordReader(InputSplit split, Configuration job, Reporter reporter) {
            super(split, job, reporter);
        }

        @Override
        public Text createKey() {
            return new Text();
        }

        @Override
        protected Text setCurrentKey(Text hadoopKey, Object object) {
            if (hadoopKey != null) {
                hadoopKey.set(object.toString());
            }
            return hadoopKey;
        }
    }
}

