/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.mr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.opensearch.hadoop.cfg.HadoopSettingsManager;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.mr.security.HadoopUserProvider;
import org.opensearch.hadoop.mr.security.TokenUtil;
import org.opensearch.hadoop.rest.InitializationUtils;
import org.opensearch.hadoop.rest.RestClient;
import org.opensearch.hadoop.security.User;
import org.opensearch.hadoop.security.UserProvider;
import org.opensearch.hadoop.util.ClusterInfo;

public final class OpenSearchMapReduceUtil {
    private static final Log LOG = LogFactory.getLog(OpenSearchMapReduceUtil.class);

    private OpenSearchMapReduceUtil() {
    }

    public static void initCredentials(Job job) {
        Configuration configuration = job.getConfiguration();
        Settings settings = HadoopSettingsManager.loadFrom(configuration);
        InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, LOG);
        UserProvider userProvider = UserProvider.create(settings);
        if (userProvider.isOpenSearchKerberosEnabled()) {
            User user = userProvider.getUser();
            ClusterInfo clusterInfo = settings.getClusterInfoOrNull();
            try (RestClient bootstrap = new RestClient(settings);){
                if (clusterInfo == null) {
                    clusterInfo = bootstrap.mainInfo();
                }
                TokenUtil.addTokenForJob(bootstrap, clusterInfo.getClusterName(), user, job);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Ignoring OpenSearch credentials since Kerberos Auth is not enabled.");
        }
    }

    public static void initCredentials(JobConf jobConf) {
        Settings settings = HadoopSettingsManager.loadFrom(jobConf);
        InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, LOG);
        UserProvider userProvider = UserProvider.create(settings);
        if (userProvider.isOpenSearchKerberosEnabled()) {
            User user = userProvider.getUser();
            ClusterInfo clusterInfo = settings.getClusterInfoOrNull();
            try (RestClient bootstrap = new RestClient(settings);){
                if (clusterInfo == null) {
                    clusterInfo = bootstrap.mainInfo();
                }
                TokenUtil.addTokenForJobConf(bootstrap, clusterInfo.getClusterName(), user, jobConf);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Ignoring OpenSearch credentials since Kerberos Auth is not enabled.");
        }
    }
}

