/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.mr.security;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.UUID;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.token.Token;
import org.opensearch.hadoop.OpenSearchHadoopException;
import org.opensearch.hadoop.mr.security.OpenSearchTokenIdentifier;
import org.opensearch.hadoop.rest.RestClient;
import org.opensearch.hadoop.security.OpenSearchToken;
import org.opensearch.hadoop.security.User;
import org.opensearch.hadoop.util.Assert;
import org.opensearch.hadoop.util.ClusterName;

public class TokenUtil {
    private static Log LOG = LogFactory.getLog(TokenUtil.class);
    public static final String KEY_NAME_PREFIX = "OPENSEARCHHADOOP_";

    private static String newKeyName() {
        return KEY_NAME_PREFIX + UUID.randomUUID().toString();
    }

    private static OpenSearchToken obtainOpenSearchToken(final RestClient client, User user) {
        KerberosPrincipal principal = user.getKerberosPrincipal();
        if (user.isProxyUser()) {
            principal = user.getRealUserProvider().getUser().getKerberosPrincipal();
        }
        Assert.isTrue(principal != null, "Kerberos credentials are missing on current user");
        return user.doAs(new PrivilegedExceptionAction<OpenSearchToken>(){

            @Override
            public OpenSearchToken run() {
                return client.createNewApiToken(TokenUtil.newKeyName());
            }
        });
    }

    public static Token<OpenSearchTokenIdentifier> obtainToken(RestClient client, User user) {
        OpenSearchToken opensearchToken = TokenUtil.obtainOpenSearchToken(client, user);
        return OpenSearchTokenIdentifier.createTokenFrom(opensearchToken);
    }

    public static void obtainAndCache(RestClient client, User user) throws IOException {
        OpenSearchToken token = TokenUtil.obtainOpenSearchToken(client, user);
        if (token == null) {
            throw new IOException("No token returned for user " + user.getKerberosPrincipal().getName());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Obtained token " + OpenSearchTokenIdentifier.KIND_NAME + " for user " + user.getKerberosPrincipal().getName()));
        }
        user.addOpenSearchToken(token);
    }

    public static void obtainTokenForJob(RestClient client, User user, Job job) {
        Token<OpenSearchTokenIdentifier> token = TokenUtil.obtainToken(client, user);
        if (token == null) {
            throw new OpenSearchHadoopException("No token returned for user " + user.getKerberosPrincipal().getName());
        }
        Text clusterName = token.getService();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Obtained token " + OpenSearchTokenIdentifier.KIND_NAME.toString() + " for user " + user.getKerberosPrincipal().getName() + " on cluster " + clusterName.toString()));
        }
        job.getCredentials().addToken(clusterName, token);
    }

    public static void obtainTokenForJob(RestClient client, User user, JobConf jobConf) {
        Token<OpenSearchTokenIdentifier> token = TokenUtil.obtainToken(client, user);
        if (token == null) {
            throw new OpenSearchHadoopException("No token returned for user " + user.getKerberosPrincipal().getName());
        }
        Text clusterName = token.getService();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Obtained token " + OpenSearchTokenIdentifier.KIND_NAME.toString() + " for user " + user.getKerberosPrincipal().getName() + " on cluster " + clusterName.toString()));
        }
        jobConf.getCredentials().addToken(clusterName, token);
    }

    public static void addTokenForJob(RestClient client, ClusterName clusterName, User user, Job job) {
        Token<OpenSearchTokenIdentifier> token = TokenUtil.getAuthToken(clusterName, user);
        if (token == null) {
            token = TokenUtil.obtainToken(client, user);
        }
        job.getCredentials().addToken(token.getService(), token);
    }

    public static void addTokenForJobConf(RestClient client, ClusterName clusterName, User user, JobConf job) {
        Token<OpenSearchTokenIdentifier> token = TokenUtil.getAuthToken(clusterName, user);
        if (token == null) {
            token = TokenUtil.obtainToken(client, user);
        }
        job.getCredentials().addToken(token.getService(), token);
    }

    private static Token<OpenSearchTokenIdentifier> getAuthToken(ClusterName clusterName, User user) {
        OpenSearchToken opensearchToken = TokenUtil.getOpenSearchAuthToken(clusterName, user);
        if (opensearchToken == null) {
            return null;
        }
        return OpenSearchTokenIdentifier.createTokenFrom(opensearchToken);
    }

    private static OpenSearchToken getOpenSearchAuthToken(ClusterName clusterName, User user) {
        return user.getOpenSearchToken(clusterName.getName());
    }
}

