/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.OpenSearchHadoopIllegalStateException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.rest.Resource;
import org.opensearch.hadoop.rest.RestClient;
import org.opensearch.hadoop.rest.RestRepository;
import org.opensearch.hadoop.security.UserProvider;
import org.opensearch.hadoop.serialization.BytesConverter;
import org.opensearch.hadoop.serialization.builder.NoOpValueWriter;
import org.opensearch.hadoop.serialization.builder.ValueReader;
import org.opensearch.hadoop.serialization.builder.ValueWriter;
import org.opensearch.hadoop.serialization.bulk.MetadataExtractor;
import org.opensearch.hadoop.serialization.dto.NodeInfo;
import org.opensearch.hadoop.serialization.field.FieldExtractor;
import org.opensearch.hadoop.util.Assert;
import org.opensearch.hadoop.util.ClusterInfo;
import org.opensearch.hadoop.util.ClusterName;
import org.opensearch.hadoop.util.OpenSearchMajorVersion;
import org.opensearch.hadoop.util.SettingsUtils;
import org.opensearch.hadoop.util.StringUtils;

public abstract class InitializationUtils {
    private static final Log LOG = LogFactory.getLog(InitializationUtils.class);

    public static void checkIdForOperation(Settings settings) {
        String operation = settings.getOperation();
        if ("update".equals(operation) || "upsert".equals(operation)) {
            Assert.isTrue(StringUtils.hasText(settings.getMappingId()), String.format("Operation [%s] requires an id but none (%s) was specified", operation, "opensearch.mapping.id"));
        }
    }

    public static void checkIndexNameForRead(Settings settings) {
        Resource readResource = new Resource(settings, true);
        if (readResource.index().contains("{") && readResource.index().contains("}")) {
            throw new OpenSearchHadoopIllegalArgumentException("Cannot read indices that have curly brace field extraction patterns in them: " + readResource.index());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIndexStatus(Settings settings) {
        if (!settings.getIndexReadAllowRedStatus()) {
            RestClient bootstrap = new RestClient(settings);
            Resource readResource = new Resource(settings, true);
            try {
                RestClient.Health status;
                if (bootstrap.indexExists(readResource.index()) && (status = bootstrap.getHealth(readResource.index())) == RestClient.Health.RED) {
                    throw new OpenSearchHadoopIllegalStateException("Index specified [" + readResource.index() + "] is either red or includes an index that is red, and thus all requested data cannot be safely and fully loaded. Bailing out...");
                }
            }
            finally {
                bootstrap.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NodeInfo> discoverNodesIfNeeded(Settings settings, Log log) {
        if (settings.getNodesDiscovery()) {
            try (RestClient bootstrap = new RestClient(settings);){
                List<NodeInfo> discoveredNodes = bootstrap.getHttpNodes(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Nodes discovery enabled - found %s", discoveredNodes));
                }
                SettingsUtils.addDiscoveredNodes(settings, discoveredNodes);
                List<NodeInfo> list = discoveredNodes;
                return list;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterNonClientNodesIfNeeded(Settings settings, Log log) {
        if (!settings.getNodesClientOnly()) {
            return;
        }
        try (RestClient bootstrap = new RestClient(settings);){
            String message = "Client-only routing specified but no client nodes with HTTP-enabled available";
            List<NodeInfo> clientNodes = bootstrap.getHttpClientNodes();
            if (clientNodes.isEmpty()) {
                throw new OpenSearchHadoopIllegalArgumentException(message);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found client nodes %s", clientNodes));
            }
            ArrayList<String> toRetain = new ArrayList<String>(clientNodes.size());
            for (NodeInfo node : clientNodes) {
                toRetain.add(node.getPublishAddress());
            }
            List<String> ddNodes = SettingsUtils.discoveredOrDeclaredNodes(settings);
            ddNodes.retainAll(toRetain);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Filtered discovered only nodes %s to client-only %s", SettingsUtils.discoveredOrDeclaredNodes(settings), ddNodes));
            }
            if (ddNodes.isEmpty()) {
                message = settings.getNodesDiscovery() ? message + String.format("; looks like the client nodes discovered have been removed; is the cluster in a stable state? %s", clientNodes) : message + String.format("; node discovery is disabled and none of nodes specified fit the criterion %s", SettingsUtils.discoveredOrDeclaredNodes(settings));
                throw new OpenSearchHadoopIllegalArgumentException(message);
            }
            SettingsUtils.setDiscoveredNodes(settings, ddNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterNonDataNodesIfNeeded(Settings settings, Log log) {
        if (!settings.getNodesDataOnly()) {
            return;
        }
        try (RestClient bootstrap = new RestClient(settings);){
            String message = "No data nodes with HTTP-enabled available";
            List<NodeInfo> dataNodes = bootstrap.getHttpDataNodes();
            if (dataNodes.isEmpty()) {
                throw new OpenSearchHadoopIllegalArgumentException(message);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found data nodes %s", dataNodes));
            }
            ArrayList<String> toRetain = new ArrayList<String>(dataNodes.size());
            for (NodeInfo node : dataNodes) {
                toRetain.add(node.getPublishAddress());
            }
            List<String> ddNodes = SettingsUtils.discoveredOrDeclaredNodes(settings);
            ddNodes.retainAll(toRetain);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Filtered discovered only nodes %s to data-only %s", SettingsUtils.discoveredOrDeclaredNodes(settings), ddNodes));
            }
            if (ddNodes.isEmpty()) {
                message = settings.getNodesDiscovery() ? message + String.format("; looks like the data nodes discovered have been removed; is the cluster in a stable state? %s", dataNodes) : message + String.format("; node discovery is disabled and none of nodes specified fit the criterion %s", SettingsUtils.discoveredOrDeclaredNodes(settings));
                throw new OpenSearchHadoopIllegalArgumentException(message);
            }
            SettingsUtils.setDiscoveredNodes(settings, ddNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterNonIngestNodesIfNeeded(Settings settings, Log log) {
        if (!settings.getNodesIngestOnly()) {
            return;
        }
        try (RestClient bootstrap = new RestClient(settings);){
            String message = "Ingest-only routing specified but no ingest nodes with HTTP-enabled available";
            List<NodeInfo> clientNodes = bootstrap.getHttpIngestNodes();
            if (clientNodes.isEmpty()) {
                throw new OpenSearchHadoopIllegalArgumentException(message);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found ingest nodes %s", clientNodes));
            }
            ArrayList<String> toRetain = new ArrayList<String>(clientNodes.size());
            for (NodeInfo node : clientNodes) {
                toRetain.add(node.getPublishAddress());
            }
            List<String> ddNodes = SettingsUtils.discoveredOrDeclaredNodes(settings);
            ddNodes.retainAll(toRetain);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Filtered discovered only nodes %s to ingest-only %s", SettingsUtils.discoveredOrDeclaredNodes(settings), ddNodes));
            }
            if (ddNodes.isEmpty()) {
                message = settings.getNodesDiscovery() ? message + String.format("; looks like the ingest nodes discovered have been removed; is the cluster in a stable state? %s", clientNodes) : message + String.format("; node discovery is disabled and none of nodes specified fit the criterion %s", SettingsUtils.discoveredOrDeclaredNodes(settings));
                throw new OpenSearchHadoopIllegalArgumentException(message);
            }
            SettingsUtils.setDiscoveredNodes(settings, ddNodes);
        }
    }

    public static void validateSettings(Settings settings) {
        String[] scripts;
        boolean[] restrictions;
        if (settings.getNodesWANOnly()) {
            Assert.isTrue(!settings.getNodesDiscovery(), "Discovery cannot be enabled when running in WAN mode");
            Assert.isTrue(!settings.getNodesClientOnly(), "Client-only nodes cannot be enabled when running in WAN mode");
            Assert.isTrue(!settings.getNodesDataOnly(), "Data-only nodes cannot be enabled when running in WAN mode");
            Assert.isTrue(!settings.getNodesIngestOnly(), "Ingest-only nodes cannot be enabled when running in WAN mode");
        }
        boolean alreadyRestricted = false;
        for (boolean restriction : restrictions = new boolean[]{settings.getNodesClientOnly(), settings.getNodesDataOnly(), settings.getNodesIngestOnly()}) {
            Assert.isTrue(!(alreadyRestricted && restriction), "Use either client-only or data-only or ingest-only nodes but not a combination");
            alreadyRestricted = alreadyRestricted || restriction;
        }
        if (settings.getInputAsJson()) {
            Assert.isTrue(settings.getMappingIncludes().isEmpty(), "When writing data as JSON, the field inclusion feature is ignored. This is most likely not what the user intended. Bailing out...");
            Assert.isTrue(settings.getMappingExcludes().isEmpty(), "When writing data as JSON, the field exclusion feature is ignored. This is most likely not what the user intended. Bailing out...");
        }
        if ("delete".equals(settings.getOperation())) {
            Assert.isTrue(!settings.getInputAsJson(), "When using delete operation, providing data as JSON is not coherent because this operation does not need document as a payload. This is most likely not what the user intended. Bailing out...");
            Assert.isTrue(settings.getMappingIncludes().isEmpty(), "When using delete operation, the field inclusion feature is ignored. This is most likely not what the user intended. Bailing out...");
            Assert.isTrue(settings.getMappingExcludes().isEmpty(), "When using delete operation, the field exclusion feature is ignored. This is most likely not what the user intended. Bailing out...");
            Assert.isTrue(settings.getMappingId() != null && !"".equals(settings.getMappingId()), "When using delete operation, the property opensearch.mapping.id must be set and must not be empty since we need the document id in order to delete it. Bailing out...");
        }
        boolean hasScript = false;
        for (String script : scripts = new String[]{settings.getUpdateScriptInline(), settings.getUpdateScriptFile(), settings.getUpdateScriptStored()}) {
            boolean isSet = StringUtils.hasText(script);
            Assert.isTrue(!(hasScript && isSet), "Multiple scripts are specified. Please specify only one via [opensearch.update.script.inline], [opensearch.update.script.file], or [opensearch.update.script.stored]");
            hasScript = hasScript || isSet;
        }
        SettingsUtils.determineSourceFields(settings);
    }

    public static void validateSettingsForReading(Settings settings) {
        InitializationUtils.checkIndexNameForRead(settings);
        InitializationUtils.checkIndexStatus(settings);
    }

    public static ClusterInfo discoverAndValidateClusterInfo(Settings settings, Log log) {
        ClusterInfo mainInfo;
        try (RestClient bootstrap = new RestClient(settings);){
            mainInfo = bootstrap.mainInfo();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Discovered OpenSearch cluster [%s/%s], version [%s]", mainInfo.getClusterName().getName(), mainInfo.getClusterName().getUUID(), mainInfo.getMajorVersion()));
            }
        }
        String clusterName = settings.getProperty("opensearch.internal.opensearch.cluster.name");
        String clusterUUID = settings.getProperty("opensearch.internal.opensearch.cluster.uuid");
        String version = settings.getProperty("opensearch.internal.opensearch.version");
        if (StringUtils.hasText(clusterName) && StringUtils.hasText(version)) {
            if (!mainInfo.getClusterName().getName().equals(clusterName)) {
                log.warn((Object)String.format("Discovered incorrect cluster name in settings. Expected [%s] but received [%s]; replacing...", mainInfo.getClusterName().getName(), clusterName));
            }
            if (!mainInfo.getClusterName().getUUID().equals(clusterUUID)) {
                log.warn((Object)String.format("Discovered incorrect cluster UUID in settings. Expected [%s] but received [%s]; replacing...", mainInfo.getClusterName().getUUID(), clusterUUID));
            }
            OpenSearchMajorVersion existingVersion = OpenSearchMajorVersion.parse(version);
            if (!mainInfo.getMajorVersion().equals(existingVersion)) {
                log.warn((Object)String.format("Discovered incorrect cluster version in settings. Expected [%s] but received [%s]; replacing...", mainInfo.getMajorVersion(), existingVersion));
            }
        }
        settings.setInternalClusterInfo(mainInfo);
        return mainInfo;
    }

    public static ClusterInfo discoverClusterInfo(Settings settings, Log log) {
        ClusterName remoteClusterName = null;
        OpenSearchMajorVersion remoteVersion = null;
        String clusterName = settings.getProperty("opensearch.internal.opensearch.cluster.name");
        String clusterUUID = settings.getProperty("opensearch.internal.opensearch.cluster.uuid");
        String version = settings.getProperty("opensearch.internal.opensearch.version");
        if (StringUtils.hasText(clusterName) && StringUtils.hasText(version)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("OpenSearch cluster [NAME:%s][UUID:%s][VERSION:%s] already present in configuration; skipping discovery", clusterName, clusterUUID, version));
            }
            remoteClusterName = new ClusterName(clusterName, clusterUUID);
            remoteVersion = OpenSearchMajorVersion.parse(version);
            return new ClusterInfo(remoteClusterName, remoteVersion);
        }
        try (RestClient bootstrap = new RestClient(settings);){
            ClusterInfo mainInfo = bootstrap.mainInfo();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Discovered OpenSearch cluster [%s/%s], version [%s]", mainInfo.getClusterName().getName(), mainInfo.getClusterName().getUUID(), mainInfo.getMajorVersion()));
            }
            settings.setInternalClusterInfo(mainInfo);
            ClusterInfo clusterInfo = mainInfo;
            return clusterInfo;
        }
    }

    public static void checkIndexExistence(RestRepository client) {
        if (!client.getSettings().getIndexAutoCreate()) {
            InitializationUtils.doCheckIndexExistence(client.getSettings(), client);
        }
    }

    public static void checkIndexExistence(Settings settings) {
        if (!settings.getIndexAutoCreate()) {
            try (RestRepository repository = new RestRepository(settings);){
                InitializationUtils.doCheckIndexExistence(settings, repository);
            }
        }
    }

    private static void doCheckIndexExistence(Settings settings, RestRepository client) {
        if (!client.resourceExists(false)) {
            throw new OpenSearchHadoopIllegalArgumentException(String.format("Target index [%s] does not exist and auto-creation is disabled [setting '%s' is '%s']", settings.getResourceWrite(), "opensearch.index.auto.create", settings.getIndexAutoCreate()));
        }
    }

    public static boolean setMetadataExtractorIfNotSet(Settings settings, Class<? extends MetadataExtractor> clazz, Log log) {
        if (!StringUtils.hasText(settings.getMappingMetadataExtractorClassName())) {
            Log logger = log != null ? log : LogFactory.getLog(clazz);
            String name = clazz.getName();
            settings.setProperty("opensearch.mapping.metadata.extractor.class", name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Using pre-defined metadata extractor [%s] as default", settings.getMappingMetadataExtractorClassName()));
            }
            return true;
        }
        return false;
    }

    public static boolean setFieldExtractorIfNotSet(Settings settings, Class<? extends FieldExtractor> clazz, Log log) {
        if (!StringUtils.hasText(settings.getMappingIdExtractorClassName())) {
            Log logger = log != null ? log : LogFactory.getLog(clazz);
            String name = clazz.getName();
            settings.setProperty("opensearch.mapping.default.extractor.class", name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Using pre-defined field extractor [%s] as default", settings.getMappingIdExtractorClassName()));
            }
            return true;
        }
        return false;
    }

    public static boolean setValueWriterIfNotSet(Settings settings, Class<? extends ValueWriter<?>> clazz, Log log) {
        if (!StringUtils.hasText(settings.getSerializerValueWriterClassName())) {
            Log logger = log != null ? log : LogFactory.getLog(clazz);
            String name = clazz.getName();
            if (settings.getInputAsJson()) {
                name = NoOpValueWriter.class.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("OpenSearch input marked as JSON; bypassing serialization through [%s] instead of [%s]", name, clazz));
                }
            }
            settings.setProperty("opensearch.ser.writer.value.class", name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Using pre-defined writer serializer [%s] as default", settings.getSerializerValueWriterClassName()));
            }
            return true;
        }
        return false;
    }

    public static boolean setBytesConverterIfNeeded(Settings settings, Class<? extends BytesConverter> clazz, Log log) {
        if (settings.getInputAsJson() && !StringUtils.hasText(settings.getSerializerBytesConverterClassName())) {
            Log logger;
            settings.setProperty("opensearch.ser.writer.bytes.class", clazz.getName());
            Log log2 = logger = log != null ? log : LogFactory.getLog(clazz);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("JSON input specified; using pre-defined bytes/json converter [%s] as default", settings.getSerializerBytesConverterClassName()));
            }
            return true;
        }
        return false;
    }

    public static boolean setValueReaderIfNotSet(Settings settings, Class<? extends ValueReader> clazz, Log log) {
        if (!StringUtils.hasText(settings.getSerializerValueReaderClassName())) {
            Log logger;
            settings.setProperty("opensearch.ser.reader.value.class", clazz.getName());
            Log log2 = logger = log != null ? log : LogFactory.getLog(clazz);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Using pre-defined reader serializer [%s] as default", settings.getSerializerValueReaderClassName()));
            }
            return true;
        }
        return false;
    }

    public static boolean setUserProviderIfNotSet(Settings settings, Class<? extends UserProvider> clazz, Log log) {
        if (!StringUtils.hasText(settings.getSecurityUserProviderClass())) {
            Log logger;
            settings.setProperty("opensearch.security.user.provider.class", clazz.getName());
            Log log2 = logger = log != null ? log : LogFactory.getLog(clazz);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Using pre-defined user provider [%s] as default", settings.getSecurityUserProviderClass()));
            }
            return true;
        }
        return false;
    }
}

