/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest;

import org.opensearch.hadoop.rest.Request;
import org.opensearch.hadoop.util.ByteSequence;
import org.opensearch.hadoop.util.StringUtils;

public class SimpleRequest
implements Request {
    private final Request.Method method;
    private final CharSequence uri;
    private final CharSequence path;
    private final CharSequence params;
    private final ByteSequence body;

    public SimpleRequest(Request.Method method, CharSequence uri, CharSequence path) {
        this(method, uri, path, null, null);
    }

    public SimpleRequest(Request.Method method, CharSequence uri, CharSequence path, CharSequence params) {
        this(method, uri, path, params, null);
    }

    public SimpleRequest(Request.Method method, CharSequence uri, CharSequence path, ByteSequence body) {
        this(method, uri, path, null, body);
    }

    public SimpleRequest(Request.Method method, CharSequence uri, CharSequence path, CharSequence params, ByteSequence body) {
        this.method = method;
        this.uri = uri;
        int queryMark = String.valueOf(path).indexOf(63);
        if (StringUtils.hasText(params) && queryMark >= 0) {
            throw new IllegalArgumentException("Found Request with Query in Path, as well as specified within the params option.");
        }
        if (queryMark >= 0) {
            this.path = path.subSequence(0, queryMark);
            this.params = path.subSequence(queryMark + 1, path.length());
        } else {
            this.path = path;
            this.params = params;
        }
        this.body = body;
    }

    @Override
    public Request.Method method() {
        return this.method;
    }

    @Override
    public CharSequence uri() {
        return this.uri;
    }

    @Override
    public CharSequence path() {
        return this.path;
    }

    @Override
    public CharSequence params() {
        return this.params;
    }

    @Override
    public ByteSequence body() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleRequest request = (SimpleRequest)o;
        if (this.method != request.method) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(request.uri) : request.uri != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(request.path) : request.path != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(request.params) : request.params != null) {
            return false;
        }
        return this.body != null ? this.body.equals(request.body) : request.body == null;
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.method.name());
        sb.append("@");
        sb.append(this.uri);
        sb.append("/");
        sb.append(this.path);
        if (this.params != null) {
            sb.append("?");
            sb.append(this.params);
        }
        return sb.toString();
    }
}

