/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest.bulk.handler.impl;

import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.handler.ErrorHandler;
import org.opensearch.hadoop.handler.impl.AbortOnFailure;
import org.opensearch.hadoop.handler.impl.AbstractHandlerLoader;
import org.opensearch.hadoop.handler.impl.DropAndLog;
import org.opensearch.hadoop.handler.impl.opensearch.OpenSearchHandler;
import org.opensearch.hadoop.rest.bulk.handler.IBulkWriteErrorHandler;
import org.opensearch.hadoop.rest.bulk.handler.impl.BulkErrorEventConverter;
import org.opensearch.hadoop.rest.bulk.handler.impl.BulkLogRenderer;
import org.opensearch.hadoop.rest.bulk.handler.impl.DelegatingErrorHandler;

public class BulkWriteHandlerLoader
extends AbstractHandlerLoader<IBulkWriteErrorHandler> {
    public static final String OPENSEARCH_WRITE_REST_ERROR_HANDLERS = "opensearch.write.rest.error.handlers";
    public static final String OPENSEARCH_WRITE_REST_ERROR_HANDLER = "opensearch.write.rest.error.handler";

    public BulkWriteHandlerLoader() {
        super(IBulkWriteErrorHandler.class);
    }

    @Override
    protected String getHandlersPropertyName() {
        return OPENSEARCH_WRITE_REST_ERROR_HANDLERS;
    }

    @Override
    protected String getHandlerPropertyName() {
        return OPENSEARCH_WRITE_REST_ERROR_HANDLER;
    }

    @Override
    protected IBulkWriteErrorHandler loadBuiltInHandler(AbstractHandlerLoader.NamedHandlers handlerName) {
        ErrorHandler genericHandler;
        switch (handlerName) {
            case FAIL: {
                genericHandler = AbortOnFailure.create();
                break;
            }
            case LOG: {
                genericHandler = DropAndLog.create(new BulkLogRenderer());
                break;
            }
            case OPENSEARCH: {
                genericHandler = OpenSearchHandler.create(this.getSettings(), new BulkErrorEventConverter());
                break;
            }
            default: {
                throw new OpenSearchHadoopIllegalArgumentException("Could not find default implementation for built in handler type [" + (Object)((Object)handlerName) + "]");
            }
        }
        return new DelegatingErrorHandler(genericHandler);
    }
}

