/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest.commonshttp.auth.aws;

import com.amazonaws.DefaultRequest;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.http.HttpMethodName;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.rest.Request;
import org.opensearch.hadoop.thirdparty.apache.commons.httpclient.Header;
import org.opensearch.hadoop.thirdparty.apache.commons.httpclient.HttpMethod;
import org.opensearch.hadoop.thirdparty.google.common.base.Splitter;
import org.opensearch.hadoop.thirdparty.google.common.base.Strings;

public class AwsV4SignerSupport {
    private final Settings settings;
    private final String httpInfo;
    private final AWSCredentials credentials;
    private Date overriddenSigningDate;

    public AwsV4SignerSupport(Settings settings, String httpInfo, AWSCredentials credentials) {
        this.settings = settings;
        this.httpInfo = httpInfo;
        this.credentials = credentials;
    }

    void overrideSigningDate(Date signingDate) {
        this.overriddenSigningDate = signingDate;
    }

    public void sign(Request request, HttpMethod http) throws UnsupportedEncodingException {
        String awsRegion = this.settings.getAwsSigV4Region();
        String awsServiceName = this.settings.getAwsSigV4ServiceName();
        AWS4Signer aws4Signer = new AWS4Signer();
        aws4Signer.setRegionName(awsRegion);
        aws4Signer.setServiceName(awsServiceName);
        if (this.overriddenSigningDate != null) {
            aws4Signer.setOverrideDate(this.overriddenSigningDate);
        }
        DefaultRequest req = new DefaultRequest(awsServiceName);
        req.setHttpMethod(HttpMethodName.valueOf((String)request.method().name()));
        String path = request.path().toString();
        req.setResourcePath(path);
        Splitter queryStringSplitter = Splitter.on('&').trimResults().omitEmptyStrings();
        List<String> rawParams = request.params() != null ? queryStringSplitter.split(request.params()) : Collections.emptyList();
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        for (String string : rawParams) {
            if (Strings.isNullOrEmpty(string)) continue;
            String pair = URLDecoder.decode(string, StandardCharsets.UTF_8.name());
            int index = pair.indexOf(61);
            if (index > 0) {
                String key = pair.substring(0, index);
                String value = pair.substring(index + 1);
                queryParams.put(key, Collections.singletonList(value));
                continue;
            }
            queryParams.put(pair, Collections.singletonList(""));
        }
        req.setParameters(queryParams);
        try {
            req.setEndpoint(new URI(this.httpInfo));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid request URI: " + this.httpInfo);
        }
        req.setContent(request.body() != null ? request.body().toInputStream() : new ByteArrayInputStream(new byte[0]));
        for (Header header : http.getRequestHeaders()) {
            if (header.getName().equalsIgnoreCase("user-agent")) continue;
            req.addHeader(header.getName(), header.getValue());
        }
        req.addHeader("x-amz-content-sha256", "required");
        aws4Signer.sign((SignableRequest)req, this.credentials);
        for (Map.Entry entry : req.getHeaders().entrySet()) {
            http.setRequestHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

