/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest.commonshttp.auth.bearer;

import org.apache.commons.codec.binary.Base64;
import org.opensearch.hadoop.rest.commonshttp.auth.bearer.OpenSearchApiKeyCredentials;
import org.opensearch.hadoop.security.OpenSearchToken;
import org.opensearch.hadoop.thirdparty.apache.commons.httpclient.Credentials;
import org.opensearch.hadoop.thirdparty.apache.commons.httpclient.HttpMethod;
import org.opensearch.hadoop.thirdparty.apache.commons.httpclient.auth.AuthenticationException;
import org.opensearch.hadoop.thirdparty.apache.commons.httpclient.auth.BasicScheme;
import org.opensearch.hadoop.thirdparty.apache.commons.httpclient.auth.MalformedChallengeException;
import org.opensearch.hadoop.util.StringUtils;

public class OpenSearchApiKeyAuthScheme
extends BasicScheme {
    private boolean complete = false;

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public String getSchemeName() {
        return "ApiKey";
    }

    @Override
    public void processChallenge(String challenge) throws MalformedChallengeException {
        this.complete = true;
    }

    private String authenticate(Credentials credentials) throws AuthenticationException {
        if (!(credentials instanceof OpenSearchApiKeyCredentials)) {
            throw new AuthenticationException("Incorrect credentials type provided. Expected [" + OpenSearchApiKeyCredentials.class.getName() + "] but got [" + credentials.getClass().getName() + "]");
        }
        OpenSearchApiKeyCredentials opensearchApiKeyCredentials = (OpenSearchApiKeyCredentials)credentials;
        String authString = null;
        if (opensearchApiKeyCredentials.getToken() != null && StringUtils.hasText(opensearchApiKeyCredentials.getToken().getName())) {
            OpenSearchToken token = opensearchApiKeyCredentials.getToken();
            String keyComponents = token.getId() + ":" + token.getApiKey();
            byte[] base64Encoded = Base64.encodeBase64((byte[])keyComponents.getBytes(StringUtils.UTF_8));
            String tokenText = new String(base64Encoded, StringUtils.UTF_8);
            authString = "ApiKey " + tokenText;
        }
        return authString;
    }

    @Override
    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        return this.authenticate(credentials);
    }

    @Override
    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        return this.authenticate(credentials);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public String getParameter(String name) {
        return null;
    }

    @Override
    public String getID() {
        return this.getSchemeName();
    }
}

