/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest.commonshttp.auth.bearer;

import org.opensearch.hadoop.security.OpenSearchToken;
import org.opensearch.hadoop.security.User;
import org.opensearch.hadoop.security.UserProvider;
import org.opensearch.hadoop.thirdparty.apache.commons.httpclient.Credentials;
import org.opensearch.hadoop.util.Assert;

public class OpenSearchApiKeyCredentials
implements Credentials {
    private final UserProvider userProvider;
    private final OpenSearchToken providedToken;
    private final String clusterName;

    public OpenSearchApiKeyCredentials(UserProvider userProvider, String clusterName) {
        Assert.notNull(userProvider, "userProvider must not be null");
        Assert.notNull(clusterName, "clusterName must not be null");
        this.userProvider = userProvider;
        this.providedToken = null;
        this.clusterName = clusterName;
    }

    public OpenSearchApiKeyCredentials(OpenSearchToken providedToken) {
        Assert.notNull(providedToken, "providedToken must not be null");
        this.userProvider = null;
        this.providedToken = providedToken;
        this.clusterName = null;
    }

    public OpenSearchToken getToken() {
        OpenSearchToken opensearchToken = null;
        if (this.providedToken != null) {
            opensearchToken = this.providedToken;
        } else {
            User user = this.userProvider.getUser();
            if (user != null) {
                opensearchToken = user.getOpenSearchToken(this.clusterName);
            }
        }
        return opensearchToken;
    }
}

