/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest.pooling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.hadoop.OpenSearchHadoopException;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.rest.Transport;
import org.opensearch.hadoop.rest.TransportFactory;
import org.opensearch.hadoop.rest.pooling.TransportPool;
import org.opensearch.hadoop.security.SecureSettings;
import org.opensearch.hadoop.util.SettingsUtils;

final class PooledHttpTransportFactory
implements TransportFactory {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map<String, TransportPool> hostPools = new HashMap<String, TransportPool>();
    private final String jobKey;

    PooledHttpTransportFactory(String jobKey) {
        this.jobKey = jobKey;
    }

    @Override
    public synchronized Transport create(Settings settings, SecureSettings secureSettings, String hostInfo) {
        this.assertCorrectJobId(settings);
        return this.borrowFrom(this.getOrCreateTransportPool(hostInfo, settings, secureSettings), hostInfo);
    }

    private void assertCorrectJobId(Settings settings) {
        SettingsUtils.ensureJobTransportPoolingKey(settings);
        String requestingJobKey = SettingsUtils.getJobTransportPoolingKey(settings);
        if (!this.jobKey.equals(requestingJobKey)) {
            throw new OpenSearchHadoopIllegalArgumentException("Settings object passed does not have the same job pooling key property as when this pool was created. Job key requested was [" + requestingJobKey + "] but this pool services job [" + this.jobKey + "]. This could be a different job incorrectly polluting the TransportPool. Bailing out...");
        }
    }

    private TransportPool getOrCreateTransportPool(String hostInfo, Settings settings, SecureSettings secureSettings) {
        TransportPool pool = this.hostPools.get(hostInfo);
        if (pool == null) {
            pool = new TransportPool(this.jobKey, hostInfo, settings, secureSettings);
            this.hostPools.put(hostInfo, pool);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating new TransportPool for job [" + this.jobKey + "] for host [" + hostInfo + "]"));
            }
        }
        return pool;
    }

    private Transport borrowFrom(TransportPool pool, String hostInfo) {
        if (!pool.getJobPoolingKey().equals(this.jobKey)) {
            throw new OpenSearchHadoopIllegalArgumentException("PooledTransportFactory found a pool with a different owner than this job. This could be a different job incorrectly polluting the TransportPool. Bailing out...");
        }
        try {
            return pool.borrowTransport();
        }
        catch (Exception ex) {
            throw new OpenSearchHadoopException(String.format("Could not get a Transport from the Transport Pool for host [%s]", hostInfo), ex);
        }
    }

    synchronized int cleanPools() {
        int totalConnectionsRemaining = 0;
        ArrayList<String> hostsToRemove = new ArrayList<String>();
        for (Map.Entry<String, TransportPool> hostPool : this.hostPools.entrySet()) {
            String host = hostPool.getKey();
            TransportPool pool = hostPool.getValue();
            int connectionsRemaining = pool.removeOldConnections();
            if (connectionsRemaining == 0) {
                hostsToRemove.add(host);
                continue;
            }
            totalConnectionsRemaining += connectionsRemaining;
        }
        for (String hostToRemove : hostsToRemove) {
            this.hostPools.remove(hostToRemove);
        }
        return totalConnectionsRemaining;
    }
}

