/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensearch.hadoop.rest.query.QueryBuilder;
import org.opensearch.hadoop.serialization.Generator;

public class BoolQueryBuilder
extends QueryBuilder {
    private final List<QueryBuilder> mustClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> mustNotClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> filterClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> shouldClauses = new ArrayList<QueryBuilder>();

    public BoolQueryBuilder should(QueryBuilder query) {
        this.shouldClauses.add(query);
        return this;
    }

    public BoolQueryBuilder filter(QueryBuilder filter) {
        this.filterClauses.add(filter);
        return this;
    }

    public BoolQueryBuilder filters(Collection<QueryBuilder> filters) {
        this.filterClauses.addAll(filters);
        return this;
    }

    public BoolQueryBuilder must(QueryBuilder query) {
        this.mustClauses.add(query);
        return this;
    }

    public BoolQueryBuilder mustNot(QueryBuilder query) {
        this.mustNotClauses.add(query);
        return this;
    }

    @Override
    public void toJson(Generator out) {
        out.writeFieldName("bool");
        out.writeBeginObject();
        if (this.mustClauses.size() > 0) {
            out.writeFieldName("must");
            out.writeBeginArray();
            for (QueryBuilder innerQuery : this.mustClauses) {
                out.writeBeginObject();
                innerQuery.toJson(out);
                out.writeEndObject();
            }
            out.writeEndArray();
        }
        if (this.shouldClauses.size() > 0) {
            out.writeFieldName("should");
            out.writeBeginArray();
            for (QueryBuilder innerQuery : this.shouldClauses) {
                out.writeBeginObject();
                innerQuery.toJson(out);
                out.writeEndObject();
            }
            out.writeEndArray();
        }
        if (this.filterClauses.size() > 0) {
            out.writeFieldName("filter");
            out.writeBeginArray();
            for (QueryBuilder innerQuery : this.filterClauses) {
                out.writeBeginObject();
                innerQuery.toJson(out);
                out.writeEndObject();
            }
            out.writeEndArray();
        }
        if (this.mustNotClauses.size() > 0) {
            out.writeFieldName("must_not");
            out.writeBeginArray();
            for (QueryBuilder innerQuery : this.mustNotClauses) {
                out.writeBeginObject();
                innerQuery.toJson(out);
                out.writeEndObject();
            }
            out.writeEndArray();
        }
        out.writeEndObject();
    }
}

