/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.security;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.opensearch.hadoop.OpenSearchHadoopException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.security.JdkUserProvider;
import org.opensearch.hadoop.security.OpenSearchToken;
import org.opensearch.hadoop.security.User;
import org.opensearch.hadoop.security.UserProvider;

public class JdkUser
implements User {
    private final Subject subject;
    private final Settings providerSettings;

    public JdkUser(Subject subject, Settings providerSettings) {
        this.subject = subject;
        this.providerSettings = providerSettings;
    }

    @Override
    public <T> T doAs(PrivilegedAction<T> action) {
        return Subject.doAs(this.subject, action);
    }

    @Override
    public <T> T doAs(PrivilegedExceptionAction<T> action) throws OpenSearchHadoopException {
        try {
            return Subject.doAs(this.subject, action);
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof OpenSearchHadoopException) {
                throw (OpenSearchHadoopException)e.getCause();
            }
            throw new OpenSearchHadoopException(e.getCause());
        }
    }

    @Override
    public OpenSearchToken getOpenSearchToken(String clusterName) {
        if (clusterName == null || clusterName.equals("") || clusterName.equals("!UNNAMED!")) {
            return null;
        }
        Set<OpenSearchTokenHolder> credSet = this.subject.getPrivateCredentials(OpenSearchTokenHolder.class);
        if (credSet.isEmpty()) {
            return null;
        }
        OpenSearchTokenHolder holder = credSet.iterator().next();
        return holder.getCred(clusterName);
    }

    @Override
    public Iterable<OpenSearchToken> getAllOpenSearchTokens() {
        Set<OpenSearchTokenHolder> credSet = this.subject.getPrivateCredentials(OpenSearchTokenHolder.class);
        if (credSet.isEmpty()) {
            return Collections.emptyList();
        }
        OpenSearchTokenHolder holder = credSet.iterator().next();
        ArrayList<OpenSearchToken> tokens = new ArrayList<OpenSearchToken>();
        tokens.addAll(holder.getCreds());
        return Collections.unmodifiableList(tokens);
    }

    @Override
    public void addOpenSearchToken(OpenSearchToken opensearchToken) {
        Iterator<OpenSearchTokenHolder> credSet = this.subject.getPrivateCredentials(OpenSearchTokenHolder.class).iterator();
        OpenSearchTokenHolder creds = null;
        if (credSet.hasNext()) {
            creds = credSet.next();
        } else {
            creds = new OpenSearchTokenHolder();
            this.subject.getPrivateCredentials().add(creds);
        }
        creds.setCred(opensearchToken.getClusterName(), opensearchToken);
    }

    @Override
    public String getUserName() {
        KerberosPrincipal principal = this.getKerberosPrincipal();
        if (principal == null) {
            return null;
        }
        return principal.getName();
    }

    @Override
    public KerberosPrincipal getKerberosPrincipal() {
        Iterator<KerberosPrincipal> iter = this.subject.getPrincipals(KerberosPrincipal.class).iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    @Override
    public boolean isProxyUser() {
        return false;
    }

    @Override
    public UserProvider getRealUserProvider() {
        JdkUserProvider sameProvider = new JdkUserProvider();
        sameProvider.setSettings(this.providerSettings);
        return sameProvider;
    }

    public String toString() {
        return "JdkUser{subject=" + this.subject + '}';
    }

    static class OpenSearchTokenHolder {
        private Map<String, OpenSearchToken> creds = new HashMap<String, OpenSearchToken>();

        OpenSearchTokenHolder() {
        }

        OpenSearchToken getCred(String alias) {
            return this.creds.get(alias);
        }

        Collection<OpenSearchToken> getCreds() {
            return this.creds.values();
        }

        void setCred(String alias, OpenSearchToken cred) {
            this.creds.put(alias, cred);
        }
    }
}

