/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.security;

import java.io.IOException;
import org.opensearch.hadoop.OpenSearchHadoopException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.security.KeystoreWrapper;
import org.opensearch.hadoop.security.OpenSearchHadoopSecurityException;

public class SecureSettings {
    private final Settings settings;
    private KeystoreWrapper keystoreWrapper;

    public SecureSettings(Settings settings) {
        this.settings = settings;
        String keystoreLocation = settings.getProperty("opensearch.keystore.location");
        if (keystoreLocation != null) {
            KeystoreWrapper.KeystoreBuilder builder = KeystoreWrapper.loadStore(keystoreLocation);
            try {
                this.keystoreWrapper = builder.build();
            }
            catch (OpenSearchHadoopSecurityException e) {
                throw new OpenSearchHadoopException("Could not load keystore", e);
            }
            catch (IOException e) {
                throw new OpenSearchHadoopException("Could not load keystore", e);
            }
        } else {
            this.keystoreWrapper = null;
        }
    }

    public String getSecureProperty(String key) {
        String value = null;
        if (this.keystoreWrapper != null) {
            try {
                value = this.keystoreWrapper.getSecureSetting(key);
            }
            catch (OpenSearchHadoopSecurityException e) {
                throw new OpenSearchHadoopException("Could not read secure setting [" + key + "]", e);
            }
        }
        if (value == null) {
            value = this.settings.getProperty(key);
        }
        return value;
    }
}

