/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.serialization.SettingsAware;
import org.opensearch.hadoop.serialization.builder.ValueWriter;
import org.opensearch.hadoop.serialization.field.FieldFilter;
import org.opensearch.hadoop.util.StringUtils;

public abstract class FilteringValueWriter<T>
implements ValueWriter<T>,
SettingsAware {
    private List<FieldFilter.NumberedInclude> includes;
    private List<String> excludes;
    private Boolean writeNullValues = Boolean.parseBoolean("false");

    @Override
    public void setSettings(Settings settings) {
        List<String> includeAsStrings = StringUtils.tokenize(settings.getMappingIncludes());
        this.includes = includeAsStrings.isEmpty() ? Collections.emptyList() : new ArrayList(includeAsStrings.size());
        for (String include : includeAsStrings) {
            this.includes.add(new FieldFilter.NumberedInclude(include));
        }
        this.excludes = StringUtils.tokenize(settings.getMappingExcludes());
        this.writeNullValues = settings.getDataFrameWriteNullValues();
    }

    protected boolean shouldKeep(String parentField, String name) {
        name = StringUtils.hasText(parentField) ? parentField + "." + name : name;
        return FieldFilter.filter((String)name, this.includes, this.excludes).matched;
    }

    protected boolean hasWriteNullValues() {
        return this.writeNullValues;
    }
}

