/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.bulk;

import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.serialization.bulk.AbstractBulkFactory;
import org.opensearch.hadoop.serialization.bulk.BulkCommand;
import org.opensearch.hadoop.serialization.bulk.CreateBulkFactory;
import org.opensearch.hadoop.serialization.bulk.DeleteBulkFactory;
import org.opensearch.hadoop.serialization.bulk.IndexBulkFactory;
import org.opensearch.hadoop.serialization.bulk.MetadataExtractor;
import org.opensearch.hadoop.serialization.bulk.UpdateBulkFactory;
import org.opensearch.hadoop.util.OpenSearchMajorVersion;

public abstract class BulkCommands {
    public static BulkCommand create(Settings settings, MetadataExtractor metaExtractor, OpenSearchMajorVersion version) {
        String operation = settings.getOperation();
        AbstractBulkFactory factory = null;
        if ("create".equals(operation)) {
            factory = new CreateBulkFactory(settings, metaExtractor, version);
        } else if ("index".equals(operation)) {
            factory = new IndexBulkFactory(settings, metaExtractor, version);
        } else if ("update".equals(operation)) {
            factory = new UpdateBulkFactory(settings, metaExtractor, version);
        } else if ("upsert".equals(operation)) {
            factory = new UpdateBulkFactory(settings, true, metaExtractor, version);
        } else if ("delete".equals(operation)) {
            factory = new DeleteBulkFactory(settings, metaExtractor, version);
        } else {
            throw new OpenSearchHadoopIllegalArgumentException("Unsupported bulk operation " + operation);
        }
        return factory.createBulk();
    }
}

