/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.bulk;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.hadoop.OpenSearchHadoopException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.handler.HandlerResult;
import org.opensearch.hadoop.handler.OpenSearchHadoopAbortHandlerException;
import org.opensearch.hadoop.serialization.OpenSearchHadoopSerializationException;
import org.opensearch.hadoop.serialization.bulk.BulkCommand;
import org.opensearch.hadoop.serialization.handler.SerdeErrorCollector;
import org.opensearch.hadoop.serialization.handler.write.ISerializationErrorHandler;
import org.opensearch.hadoop.serialization.handler.write.SerializationFailure;
import org.opensearch.hadoop.serialization.handler.write.impl.SerializationHandlerLoader;
import org.opensearch.hadoop.util.Assert;
import org.opensearch.hadoop.util.BytesRef;

public class BulkEntryWriter {
    private static final Log LOG = LogFactory.getLog(BulkEntryWriter.class);
    private final BulkCommand bulkCommand;
    private final List<ISerializationErrorHandler> serializationErrorHandlers;

    public BulkEntryWriter(Settings settings, BulkCommand bulkCommand) {
        this.bulkCommand = bulkCommand;
        SerializationHandlerLoader loader = new SerializationHandlerLoader();
        loader.setSettings(settings);
        this.serializationErrorHandlers = loader.loadHandlers();
    }

    public BytesRef writeBulkEntry(Object object) {
        Object toRead = object;
        BytesRef writeResult = null;
        boolean retryWrite = false;
        boolean skip = false;
        int attempts = 0;
        do {
            try {
                retryWrite = false;
                writeResult = this.bulkCommand.write(toRead);
            }
            catch (Exception serializationException) {
                ArrayList<String> passReasons = new ArrayList<String>();
                SerializationFailure entry = new SerializationFailure(serializationException, object, passReasons);
                SerdeErrorCollector errorCollector = new SerdeErrorCollector();
                Exception abortException = serializationException;
                block11: for (ISerializationErrorHandler serializationErrorHandler : this.serializationErrorHandlers) {
                    HandlerResult result;
                    try {
                        result = serializationErrorHandler.onError(entry, errorCollector);
                    }
                    catch (OpenSearchHadoopAbortHandlerException ahe) {
                        result = HandlerResult.ABORT;
                        abortException = new OpenSearchHadoopSerializationException(ahe.getMessage(), ahe.getCause());
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Could not handle serialization error event due to an exception in error handler. Serialization exception:", (Throwable)serializationException);
                        throw new OpenSearchHadoopException("Encountered unexpected exception during error handler execution.", e);
                    }
                    switch (result) {
                        case HANDLED: {
                            Assert.isTrue(errorCollector.getAndClearMessage() == null, "Found pass message with Handled response. Be sure to return the value returned from the pass(String) call.");
                            if (errorCollector.receivedRetries()) {
                                Object retryObject = errorCollector.getAndClearRetryValue();
                                if (retryObject != null) {
                                    toRead = retryObject;
                                }
                                if (attempts >= 50) {
                                    throw new OpenSearchHadoopException("Maximum retry attempts (50) reached for serialization errors.");
                                }
                                retryWrite = true;
                                ++attempts;
                                break block11;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Skipping a record that resulted in error while reading: [" + object.toString() + "]"));
                            } else {
                                LOG.info((Object)"Skipping a record that resulted in error while reading. (DEBUG for more info).");
                            }
                            skip = true;
                            break block11;
                        }
                        case PASS: {
                            String reason = errorCollector.getAndClearMessage();
                            if (reason == null) continue block11;
                            passReasons.add(reason);
                            continue block11;
                        }
                        case ABORT: {
                            errorCollector.getAndClearMessage();
                            if (abortException instanceof OpenSearchHadoopSerializationException) {
                                throw (OpenSearchHadoopSerializationException)abortException;
                            }
                            throw new OpenSearchHadoopSerializationException(abortException);
                        }
                        default: {
                            continue block11;
                        }
                    }
                }
            }
        } while (retryWrite);
        if (writeResult == null && !skip) {
            throw new OpenSearchHadoopSerializationException("Could not write record to bulk request.");
        }
        return writeResult;
    }

    public void close() {
        for (ISerializationErrorHandler errorHandler : this.serializationErrorHandlers) {
            errorHandler.close();
        }
    }
}

