/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.bulk;

import java.util.Collection;
import java.util.List;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.serialization.builder.ContentBuilder;
import org.opensearch.hadoop.serialization.builder.ValueWriter;
import org.opensearch.hadoop.serialization.bulk.AbstractBulkFactory;
import org.opensearch.hadoop.serialization.bulk.BulkCommand;
import org.opensearch.hadoop.util.BytesArray;
import org.opensearch.hadoop.util.BytesRef;
import org.opensearch.hadoop.util.FastByteArrayOutputStream;

class TemplatedBulk
implements BulkCommand {
    protected final Collection<Object> beforeObject;
    protected final Collection<Object> afterObject;
    protected BytesArray scratchPad = new BytesArray(1024);
    protected BytesRef ref = new BytesRef();
    private final ValueWriter valueWriter;

    TemplatedBulk(Collection<Object> beforeObject, Collection<Object> afterObject, ValueWriter<?> valueWriter) {
        this.beforeObject = beforeObject;
        this.afterObject = afterObject;
        this.valueWriter = valueWriter;
    }

    @Override
    public BytesRef write(Object object) {
        this.ref.reset();
        this.scratchPad.reset();
        Object processed = this.preProcess(object, this.scratchPad);
        this.writeTemplate(this.beforeObject, processed);
        this.doWriteObject(processed, this.scratchPad, this.valueWriter);
        this.ref.add(this.scratchPad);
        this.writeTemplate(this.afterObject, processed);
        return this.ref;
    }

    protected Object preProcess(Object object, BytesArray storage) {
        return object;
    }

    protected void doWriteObject(Object object, BytesArray storage, ValueWriter<?> writer) {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(storage);
        ContentBuilder.generate(bos, writer).value(object).flush().close();
    }

    protected void writeTemplate(Collection<Object> template, Object object) {
        for (Object item : template) {
            if (item instanceof BytesArray) {
                this.ref.add((BytesArray)item);
                continue;
            }
            if (item instanceof AbstractBulkFactory.FieldWriter) {
                this.ref.add(((AbstractBulkFactory.FieldWriter)item).write(object));
                continue;
            }
            if (item instanceof AbstractBulkFactory.DynamicContentRef) {
                List<Object> dynamicContent = ((AbstractBulkFactory.DynamicContentRef)item).getDynamicContent();
                this.writeTemplate(dynamicContent, object);
                continue;
            }
            throw new OpenSearchHadoopIllegalArgumentException(String.format("Unknown object type received [%s][%s]", item, item.getClass()));
        }
    }
}

