/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.dto.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.serialization.FieldType;
import org.opensearch.hadoop.serialization.dto.mapping.Field;
import org.opensearch.hadoop.serialization.dto.mapping.Mapping;
import org.opensearch.hadoop.serialization.dto.mapping.MappingSet;

public final class FieldParser {
    private FieldParser() {
    }

    public static MappingSet parseTypedMappings(Map<String, Object> content) {
        return FieldParser.parseMappings(content, true);
    }

    public static MappingSet parseTypelessMappings(Map<String, Object> content) {
        return FieldParser.parseMappings(content, false);
    }

    public static MappingSet parseMappings(Map<String, Object> content, boolean includeTypeName) {
        Iterator<Map.Entry<String, Object>> indices = content.entrySet().iterator();
        ArrayList<Mapping> indexMappings = new ArrayList<Mapping>();
        while (indices.hasNext()) {
            FieldParser.parseIndexMappings(indices.next(), indexMappings, includeTypeName);
        }
        return new MappingSet(indexMappings);
    }

    private static void parseIndexMappings(Map.Entry<String, Object> indexToMappings, List<Mapping> collector, boolean includeTypeName) {
        String indexName = indexToMappings.getKey();
        if (!(indexToMappings.getValue() instanceof Map)) {
            throw new OpenSearchHadoopIllegalArgumentException("invalid mapping received " + indexToMappings + "; Invalid mapping structure for [" + indexName + "]");
        }
        Map mappingsObject = (Map)indexToMappings.getValue();
        if (!(mappingsObject.get("mappings") instanceof Map)) {
            throw new OpenSearchHadoopIllegalArgumentException("invalid mapping received " + indexToMappings + "; Missing mappings under [" + indexName + "]");
        }
        Map mappingEntries = (Map)mappingsObject.get("mappings");
        if (includeTypeName) {
            for (Map.Entry<String, Object> entry : mappingEntries.entrySet()) {
                String typeName = (String)entry.getKey();
                Mapping mapping = FieldParser.parseMapping(indexName, typeName, entry);
                collector.add(mapping);
            }
        } else {
            String typeName = "";
            if (mappingsObject.entrySet().size() > 1) {
                throw new OpenSearchHadoopIllegalArgumentException("invalid mapping received " + indexToMappings + "; Index [" + indexName + "] contains invalid mapping structure.");
            }
            Map.Entry<String, Object> entry = mappingsObject.entrySet().iterator().next();
            Mapping mapping = FieldParser.parseMapping(indexName, typeName, entry);
            collector.add(mapping);
        }
    }

    private static Mapping parseMapping(String indexName, String typeName, Map.Entry<String, Object> mapping) {
        Field field = FieldParser.parseField(mapping, null);
        if (field == null) {
            throw new OpenSearchHadoopIllegalArgumentException("Could not parse mapping contents from [" + mapping + "]");
        }
        return new Mapping(indexName, typeName, field.properties());
    }

    private static Field parseField(Map.Entry<String, Object> entry, String previousKey) {
        String key = entry.getKey();
        Object value = entry.getValue();
        if (value instanceof Map) {
            Map content = (Map)value;
            FieldType fieldType = FieldType.OBJECT;
            Object type = content.get("type");
            if (type instanceof String) {
                fieldType = FieldType.parse(type.toString());
                if (FieldType.isRelevant(fieldType)) {
                    if (!FieldType.isCompound(fieldType)) {
                        return new Field(key, fieldType);
                    }
                } else {
                    return null;
                }
            }
            if (FieldType.JOIN == fieldType) {
                return new Field(key, fieldType, new Field[]{new Field("name", FieldType.KEYWORD), new Field("parent", FieldType.KEYWORD)});
            }
            ArrayList<Field> fields = new ArrayList<Field>(content.size());
            for (Map.Entry<String, Object> entry2 : content.entrySet()) {
                if (!(entry2.getValue() instanceof Map)) continue;
                Field fl = FieldParser.parseField(entry2, key);
                if (fl != null && fl.type() == FieldType.OBJECT && "properties".equals(fl.name()) && !FieldParser.isFieldNamedProperties(entry2.getValue())) {
                    return new Field(key, fieldType, fl.properties());
                }
                if (fl == null) continue;
                fields.add(fl);
            }
            return new Field(key, fieldType, fields);
        }
        throw new OpenSearchHadoopIllegalArgumentException("invalid map received " + entry);
    }

    private static boolean isFieldNamedProperties(Object fieldValue) {
        Map fieldValueAsMap;
        return fieldValue instanceof Map && ((fieldValueAsMap = (Map)fieldValue).containsKey("type") && fieldValueAsMap.get("type") instanceof String || fieldValueAsMap.containsKey("properties") && !FieldParser.isFieldNamedProperties(fieldValueAsMap.get("properties")));
    }
}

