/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.dto.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.cfg.FieldPresenceValidation;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.serialization.FieldType;
import org.opensearch.hadoop.serialization.dto.mapping.Field;
import org.opensearch.hadoop.serialization.dto.mapping.GeoField;
import org.opensearch.hadoop.serialization.dto.mapping.GeoPointType;
import org.opensearch.hadoop.serialization.dto.mapping.GeoShapeType;
import org.opensearch.hadoop.serialization.dto.mapping.Mapping;
import org.opensearch.hadoop.util.StringUtils;

public abstract class MappingUtils {
    private static final Set<String> BUILT_IN_FIELDS = new HashSet<String>();

    public static void validateMapping(String fields, Mapping mapping, FieldPresenceValidation validation, Log log) {
        if (StringUtils.hasText(fields)) {
            MappingUtils.validateMapping(StringUtils.tokenize(fields), mapping, validation, log);
        }
    }

    public static void validateMapping(Collection<String> fields, Mapping mapping, FieldPresenceValidation validation, Log log) {
        if (mapping == null || fields == null || fields.isEmpty() || validation == null || FieldPresenceValidation.IGNORE == validation) {
            return;
        }
        List[] results = MappingUtils.findTypos(fields, mapping);
        if (results == null) {
            return;
        }
        String message = String.format("Field(s) [%s] not found in the OpenSearch mapping specified; did you mean [%s]?", MappingUtils.removeDoubleBrackets(results[0]), MappingUtils.removeDoubleBrackets(results[1]));
        if (validation != FieldPresenceValidation.WARN) {
            throw new OpenSearchHadoopIllegalArgumentException(message);
        }
        log.warn((Object)message);
    }

    static List[] findTypos(Collection<String> fields, Mapping mapping) {
        Set<String> keys = mapping.flatten().keySet();
        ArrayList<String> missing = new ArrayList<String>(fields.size());
        for (String string : fields) {
            if (keys.contains(string) || MappingUtils.isBuiltIn(string)) continue;
            missing.add(string);
        }
        if (missing.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> unwrapped = new LinkedHashMap<String, String>();
        for (String key : keys) {
            String string;
            int match = key.lastIndexOf(".");
            if (match > 0 && !unwrapped.containsKey(string = key.substring(match + 1))) {
                unwrapped.put(string, key);
            }
            unwrapped.put(key, key);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> similar = unwrapped.keySet();
        for (String string : missing) {
            List<String> matches = StringUtils.findSimiliar(string, similar);
            for (String match : matches) {
                arrayList.add((String)unwrapped.get(match));
            }
        }
        return new List[]{missing, arrayList};
    }

    private static boolean isBuiltIn(String field) {
        return BUILT_IN_FIELDS.contains(field);
    }

    private static String removeDoubleBrackets(List col) {
        if (col.isEmpty()) {
            return "<no-similar-match-found>";
        }
        if (col.size() == 1) {
            return col.get(0).toString();
        }
        return col.toString();
    }

    public static Mapping filterMapping(Mapping mapping, Settings cfg) {
        String readIncludeCfg = cfg.getReadFieldInclude();
        String readExcludeCfg = cfg.getReadFieldExclude();
        return mapping.filter(StringUtils.tokenize(readIncludeCfg), StringUtils.tokenize(readExcludeCfg));
    }

    public static Map<String, GeoField.GeoType> geoFields(Mapping rootMapping) {
        if (rootMapping == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, GeoField.GeoType> geoFields = new LinkedHashMap<String, GeoField.GeoType>();
        for (Field nestedField : rootMapping.getFields()) {
            MappingUtils.findGeo(nestedField, null, geoFields);
        }
        return geoFields;
    }

    private static void findGeo(Field field, String parentName, Map<String, GeoField.GeoType> geoFields) {
        String fieldName;
        String string = fieldName = parentName != null ? parentName + "." + field.name() : field.name();
        if (FieldType.GEO_POINT == field.type()) {
            geoFields.put(fieldName, GeoField.GeoType.GEO_POINT);
        } else if (FieldType.GEO_SHAPE == field.type()) {
            geoFields.put(fieldName, GeoField.GeoType.GEO_SHAPE);
        } else if (FieldType.isCompound(field.type())) {
            for (Field nestedField : field.properties()) {
                MappingUtils.findGeo(nestedField, fieldName, geoFields);
            }
        }
    }

    public static GeoField parseGeoInfo(GeoField.GeoType geoType, Object parsedContent) {
        if (geoType == GeoField.GeoType.GEO_POINT) {
            return MappingUtils.doParseGeoPointInfo(parsedContent);
        }
        if (geoType == GeoField.GeoType.GEO_SHAPE) {
            return MappingUtils.doParseGeoShapeInfo(parsedContent);
        }
        throw new OpenSearchHadoopIllegalArgumentException(String.format(Locale.ROOT, "Unknown GeoType %s", new Object[]{geoType}));
    }

    private static GeoField doParseGeoPointInfo(Object parsedContent) {
        Object content;
        if (parsedContent instanceof List && (content = ((List)parsedContent).get(0)) instanceof Double) {
            return GeoPointType.LON_LAT_ARRAY;
        }
        if (parsedContent instanceof String) {
            return ((String)parsedContent).contains(",") ? GeoPointType.LAT_LON_STRING : GeoPointType.GEOHASH;
        }
        return GeoPointType.LAT_LON_OBJECT;
    }

    private static GeoField doParseGeoShapeInfo(Object parsedContent) {
        if (parsedContent instanceof Map) {
            Map geoShape = (Map)parsedContent;
            Object typ = geoShape.get("type");
            if (typ == null) {
                throw new OpenSearchHadoopIllegalArgumentException(String.format(Locale.ROOT, "Invalid GeoShape [%s]", parsedContent));
            }
            String type = typ.toString();
            GeoShapeType found = GeoShapeType.parse(type);
            if (found != null) {
                return found;
            }
        }
        throw new OpenSearchHadoopIllegalArgumentException(String.format(Locale.ROOT, "Unknown GeoShape [%s]", parsedContent));
    }

    public static String joinParentField(Settings settings) {
        if (StringUtils.hasText(settings.getMappingJoin())) {
            return settings.getMappingJoin().concat(".parent");
        }
        return null;
    }

    static {
        BUILT_IN_FIELDS.addAll(Arrays.asList("_uid", "_id", "_type", "_source", "_all", "_analyzer", "_boost", "_parent", "_routing", "_index", "_size", "_field_names", "_meta"));
    }
}

