/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.handler.read.impl;

import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.handler.ErrorHandler;
import org.opensearch.hadoop.handler.impl.AbortOnFailure;
import org.opensearch.hadoop.handler.impl.AbstractHandlerLoader;
import org.opensearch.hadoop.handler.impl.DropAndLog;
import org.opensearch.hadoop.handler.impl.opensearch.OpenSearchHandler;
import org.opensearch.hadoop.serialization.handler.read.IDeserializationErrorHandler;
import org.opensearch.hadoop.serialization.handler.read.impl.DelegatingErrorHandler;
import org.opensearch.hadoop.serialization.handler.read.impl.DeserializationEventConverter;
import org.opensearch.hadoop.serialization.handler.read.impl.DeserializationLogRenderer;

public class DeserializationHandlerLoader
extends AbstractHandlerLoader<IDeserializationErrorHandler> {
    public static final String OPENSEARCH_READ_DATA_ERROR_HANDLERS = "opensearch.read.data.error.handlers";
    public static final String OPENSEARCH_READ_DATA_ERROR_HANDLER = "opensearch.read.data.error.handler";

    public DeserializationHandlerLoader() {
        super(IDeserializationErrorHandler.class);
    }

    @Override
    protected String getHandlersPropertyName() {
        return OPENSEARCH_READ_DATA_ERROR_HANDLERS;
    }

    @Override
    protected String getHandlerPropertyName() {
        return OPENSEARCH_READ_DATA_ERROR_HANDLER;
    }

    @Override
    protected IDeserializationErrorHandler loadBuiltInHandler(AbstractHandlerLoader.NamedHandlers handlerName) {
        ErrorHandler genericHandler;
        switch (handlerName) {
            case FAIL: {
                genericHandler = AbortOnFailure.create();
                break;
            }
            case LOG: {
                genericHandler = DropAndLog.create(new DeserializationLogRenderer());
                break;
            }
            case OPENSEARCH: {
                genericHandler = OpenSearchHandler.create(this.getSettings(), new DeserializationEventConverter());
                break;
            }
            default: {
                throw new OpenSearchHadoopIllegalArgumentException("Could not find default implementation for built in handler type [" + (Object)((Object)handlerName) + "]");
            }
        }
        return new DelegatingErrorHandler(genericHandler);
    }
}

