/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.json;

import org.opensearch.hadoop.serialization.Parser;

public class BlockAwareJsonParser
implements Parser {
    private final Parser delegate;
    private int open = 0;

    public BlockAwareJsonParser(Parser delegate) {
        this.delegate = delegate;
        Parser.Token currentToken = delegate.currentToken();
        if (currentToken != null && (currentToken == Parser.Token.START_OBJECT || currentToken == Parser.Token.START_ARRAY)) {
            this.open = 1;
        }
    }

    public Parser getParser() {
        return this.delegate;
    }

    public int getLevel() {
        return this.open;
    }

    public void exitBlock() {
        if (this.open == 0) {
            return;
        }
        if (this.open < 0) {
            throw new IllegalStateException("Parser is no longer nested in any blocks at the level in which it was created. You must create a new block aware parser to track the levels above this one.");
        }
        while (this.open > 0) {
            Parser.Token t = this.delegate.nextToken();
            if (t == null) {
                return;
            }
            this.updateLevelBasedOn(t);
        }
    }

    private void updateLevelBasedOn(Parser.Token token) {
        if (token != null) {
            switch (token) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++this.open;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    --this.open;
                }
            }
        }
    }

    @Override
    public Parser.Token currentToken() {
        return this.delegate.currentToken();
    }

    @Override
    public Parser.Token nextToken() {
        Parser.Token token = this.delegate.nextToken();
        this.updateLevelBasedOn(token);
        return token;
    }

    @Override
    public void skipChildren() {
        this.delegate.skipChildren();
        this.updateLevelBasedOn(this.delegate.currentToken());
    }

    @Override
    public String absoluteName() {
        return this.delegate.absoluteName();
    }

    @Override
    public String currentName() {
        return this.delegate.currentName();
    }

    @Override
    public Object currentValue() {
        return this.delegate.currentValue();
    }

    @Override
    public String text() {
        return this.delegate.text();
    }

    @Override
    public byte[] bytes() {
        return this.delegate.bytes();
    }

    @Override
    public Number numberValue() {
        return this.delegate.numberValue();
    }

    @Override
    public Parser.NumberType numberType() {
        return this.delegate.numberType();
    }

    @Override
    public short shortValue() {
        return this.delegate.shortValue();
    }

    @Override
    public int intValue() {
        return this.delegate.intValue();
    }

    @Override
    public long longValue() {
        return this.delegate.longValue();
    }

    @Override
    public float floatValue() {
        return this.delegate.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.delegate.doubleValue();
    }

    @Override
    public boolean booleanValue() {
        return this.delegate.booleanValue();
    }

    @Override
    public byte[] binaryValue() {
        return this.delegate.binaryValue();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public int tokenCharOffset() {
        return this.delegate.tokenCharOffset();
    }
}

