/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.serialization.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.opensearch.hadoop.serialization.OpenSearchHadoopSerializationException;
import org.opensearch.hadoop.serialization.Parser;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.JsonFactory;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.JsonParser;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.JsonStreamContext;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.JsonToken;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.impl.JsonParserBase;

public class JacksonJsonParser
implements Parser {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final JsonParser parser;
    private final JsonParserBase richerParser;

    public JacksonJsonParser(InputStream in) {
        try {
            this.parser = JSON_FACTORY.createJsonParser(in);
            this.richerParser = this.parser instanceof JsonParserBase ? (JsonParserBase)this.parser : null;
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    public JacksonJsonParser(byte[] content) {
        this(content, 0, content.length);
    }

    public JacksonJsonParser(byte[] content, int offset, int length) {
        try {
            this.parser = JSON_FACTORY.createJsonParser(content, offset, length);
            this.richerParser = this.parser instanceof JsonParserBase ? (JsonParserBase)this.parser : null;
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    public JacksonJsonParser(JsonParser parser) {
        this.parser = parser;
        this.richerParser = parser instanceof JsonParserBase ? (JsonParserBase)parser : null;
    }

    @Override
    public Parser.Token currentToken() {
        return this.convertToken(this.parser.getCurrentToken());
    }

    @Override
    public Object currentValue() {
        try {
            return this.parser.getCurrentToken().isNumeric() ? this.parser.getNumberValue() : this.parser.getText();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public Parser.Token nextToken() {
        try {
            return this.convertToken(this.parser.nextToken());
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    private Parser.Token convertToken(JsonToken token) {
        if (token == null) {
            return null;
        }
        switch (token) {
            case FIELD_NAME: {
                return Parser.Token.FIELD_NAME;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return Parser.Token.VALUE_BOOLEAN;
            }
            case VALUE_STRING: {
                return Parser.Token.VALUE_STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return Parser.Token.VALUE_NUMBER;
            }
            case VALUE_NULL: {
                return Parser.Token.VALUE_NULL;
            }
            case START_OBJECT: {
                return Parser.Token.START_OBJECT;
            }
            case END_OBJECT: {
                return Parser.Token.END_OBJECT;
            }
            case START_ARRAY: {
                return Parser.Token.START_ARRAY;
            }
            case END_ARRAY: {
                return Parser.Token.END_ARRAY;
            }
            case VALUE_EMBEDDED_OBJECT: {
                return Parser.Token.VALUE_EMBEDDED_OBJECT;
            }
            case NOT_AVAILABLE: {
                throw new UnsupportedOperationException();
            }
        }
        throw new OpenSearchHadoopSerializationException("No matching token for json_token [" + (Object)((Object)token) + "]");
    }

    @Override
    public void skipChildren() {
        try {
            this.parser.skipChildren();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public String absoluteName() {
        ArrayList<String> tree = new ArrayList<String>();
        for (JsonStreamContext ctx = this.parser.getParsingContext(); ctx != null; ctx = ctx.getParent()) {
            if (!ctx.inObject()) continue;
            tree.add(ctx.getCurrentName());
        }
        StringBuilder sb = new StringBuilder();
        for (int index = tree.size(); index > 0; --index) {
            sb.append((String)tree.get(index - 1));
            sb.append(".");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public String currentName() {
        try {
            return this.parser.getCurrentName();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public String text() {
        try {
            return this.parser.getText();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public byte[] bytes() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public Number numberValue() {
        try {
            return this.parser.getNumberValue();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public Parser.NumberType numberType() {
        try {
            return this.convertNumberType(this.parser.getNumberType());
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public short shortValue() {
        try {
            return this.parser.getShortValue();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public int intValue() {
        try {
            return this.parser.getIntValue();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public long longValue() {
        try {
            return this.parser.getLongValue();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public float floatValue() {
        try {
            return this.parser.getFloatValue();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public double doubleValue() {
        try {
            return this.parser.getDoubleValue();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public boolean booleanValue() {
        try {
            return this.parser.getBooleanValue();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public byte[] binaryValue() {
        try {
            return this.parser.getBinaryValue();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.parser.close();
        }
        catch (IOException ex) {
            throw new OpenSearchHadoopSerializationException(ex);
        }
    }

    private Parser.NumberType convertNumberType(JsonParser.NumberType numberType) {
        switch (numberType) {
            case INT: {
                return Parser.NumberType.INT;
            }
            case LONG: {
                return Parser.NumberType.LONG;
            }
            case FLOAT: {
                return Parser.NumberType.FLOAT;
            }
            case DOUBLE: {
                return Parser.NumberType.DOUBLE;
            }
            case BIG_INTEGER: {
                return Parser.NumberType.DOUBLE;
            }
            case BIG_DECIMAL: {
                return Parser.NumberType.DOUBLE;
            }
        }
        throw new OpenSearchHadoopSerializationException("No matching token for number_type [" + (Object)((Object)numberType) + "]");
    }

    @Override
    public int tokenCharOffset() {
        return (int)(this.richerParser != null ? this.richerParser.getTokenCharacterOffset() : this.parser.getTokenLocation().getCharOffset());
    }
}

