/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.thirdparty.codehaus.jackson.map.deser;

import java.io.IOException;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.JsonNode;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.JsonParser;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.JsonProcessingException;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.JsonToken;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.map.DeserializationContext;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.map.JsonDeserializer;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.map.deser.BaseNodeDeserializer;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.node.ArrayNode;
import org.opensearch.hadoop.thirdparty.codehaus.jackson.node.ObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonNodeDeserializer
extends BaseNodeDeserializer<JsonNode> {
    @Deprecated
    public static final JsonNodeDeserializer instance = new JsonNodeDeserializer();

    protected JsonNodeDeserializer() {
        super(JsonNode.class);
    }

    public static JsonDeserializer<? extends JsonNode> getDeserializer(Class<?> nodeClass) {
        if (nodeClass == ObjectNode.class) {
            return ObjectDeserializer.getInstance();
        }
        if (nodeClass == ArrayNode.class) {
            return ArrayDeserializer.getInstance();
        }
        return instance;
    }

    @Override
    public JsonNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this.deserializeAny(jp, ctxt);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ArrayDeserializer
    extends BaseNodeDeserializer<ArrayNode> {
        protected static final ArrayDeserializer _instance = new ArrayDeserializer();

        protected ArrayDeserializer() {
            super(ArrayNode.class);
        }

        public static ArrayDeserializer getInstance() {
            return _instance;
        }

        @Override
        public ArrayNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.isExpectedStartArrayToken()) {
                return this.deserializeArray(jp, ctxt);
            }
            throw ctxt.mappingException(ArrayNode.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ObjectDeserializer
    extends BaseNodeDeserializer<ObjectNode> {
        protected static final ObjectDeserializer _instance = new ObjectDeserializer();

        protected ObjectDeserializer() {
            super(ObjectNode.class);
        }

        public static ObjectDeserializer getInstance() {
            return _instance;
        }

        @Override
        public ObjectNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                jp.nextToken();
                return this.deserializeObject(jp, ctxt);
            }
            if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                return this.deserializeObject(jp, ctxt);
            }
            throw ctxt.mappingException(ObjectNode.class);
        }
    }
}

