/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.util;

import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.util.StringUtils;

public abstract class Assert {
    public static void hasText(CharSequence sequence, String message) {
        if (!StringUtils.hasText(sequence)) {
            throw new OpenSearchHadoopIllegalArgumentException(message);
        }
    }

    public static void hasText(CharSequence sequence) {
        Assert.hasText(sequence, "[Assertion failed] - this CharSequence argument must have text; it must not be null, empty, or blank");
    }

    public static void hasNoText(CharSequence sequence, String message) {
        if (StringUtils.hasText(sequence)) {
            throw new OpenSearchHadoopIllegalArgumentException(message);
        }
    }

    public static void hasNoText(CharSequence sequence) {
        Assert.hasNoText(sequence, "[Assertion failed] - this CharSequence argument must be empty");
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new OpenSearchHadoopIllegalArgumentException(message);
        }
    }

    public static void notNull(Object object) {
        Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    public static void isTrue(Boolean object, String message) {
        if (!Boolean.TRUE.equals(object)) {
            throw new OpenSearchHadoopIllegalArgumentException(message);
        }
    }

    public static void isTrue(Boolean object) {
        Assert.isTrue(object, "[Assertion failed] - this argument must be true");
    }

    public static void isFalse(Boolean object, String message) {
        if (!Boolean.FALSE.equals(object)) {
            throw new OpenSearchHadoopIllegalArgumentException(message);
        }
    }

    public static void isFalse(Boolean object) {
        Assert.isFalse(object, "[Assertion failed] - this argument must be false");
    }
}

