/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.util;

import java.io.Serializable;
import org.opensearch.hadoop.util.ClusterName;
import org.opensearch.hadoop.util.OpenSearchMajorVersion;

public class ClusterInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ClusterName clusterName;
    private final OpenSearchMajorVersion majorVersion;

    public static ClusterInfo unnamedLatest() {
        return new ClusterInfo(new ClusterName("!UNNAMED!", null), OpenSearchMajorVersion.LATEST);
    }

    public static ClusterInfo unnamedClusterWithVersion(OpenSearchMajorVersion version) {
        return new ClusterInfo(new ClusterName("!UNNAMED!", null), version);
    }

    public ClusterInfo(ClusterName clusterName, OpenSearchMajorVersion majorVersion) {
        this.clusterName = clusterName;
        this.majorVersion = majorVersion;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public OpenSearchMajorVersion getMajorVersion() {
        return this.majorVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterInfo that = (ClusterInfo)o;
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        return this.majorVersion != null ? this.majorVersion.equals(that.majorVersion) : that.majorVersion == null;
    }

    public int hashCode() {
        int result = this.clusterName != null ? this.clusterName.hashCode() : 0;
        result = 31 * result + (this.majorVersion != null ? this.majorVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClusterInfo{clusterName=" + this.clusterName + ", majorVersion=" + this.majorVersion + '}';
    }
}

