/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.util;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.hadoop.util.ObjectUtils;
import org.opensearch.hadoop.util.ReflectionUtils;

public abstract class DateUtils {
    public static boolean printed = false;
    private static final boolean jodaTimeAvailable = ObjectUtils.isClassPresent("org.joda.time.format.ISODateTimeFormat", DateUtils.class.getClassLoader());
    static final DateTimeFormatter DATE_OPTIONAL_TIME_OFFSET = DateTimeFormatter.ofPattern("uuuu-MM-dd['T'HH:mm:ss][.SSSSSSSSS][.SSSSSS][.SSS][XXX]");

    public static Calendar parseDate(String value) {
        if (!printed) {
            printed = true;
            Log log = LogFactory.getLog(DateUtils.class);
            if (jodaTimeAvailable && JodaTime.INITIALIZED) {
                log.info((Object)"Joda library available in the classpath; using it for date/time handling...");
            }
        }
        return jodaTimeAvailable && JodaTime.INITIALIZED ? JodaTime.parseDate(value) : Jdk6.parseDate(value);
    }

    public static Timestamp parseDateNanos(String value) {
        return DATE_OPTIONAL_TIME_OFFSET.parse((CharSequence)value, temporal -> {
            int year = temporal.get(ChronoField.YEAR);
            int month = temporal.get(ChronoField.MONTH_OF_YEAR);
            int dayOfMonth = temporal.get(ChronoField.DAY_OF_MONTH);
            int hour = DateUtils.getOrDefault(temporal, ChronoField.HOUR_OF_DAY, 0);
            int minute = DateUtils.getOrDefault(temporal, ChronoField.MINUTE_OF_HOUR, 0);
            int second = DateUtils.getOrDefault(temporal, ChronoField.SECOND_OF_MINUTE, 0);
            int nanoOfSecond = DateUtils.getOrDefault(temporal, ChronoField.NANO_OF_SECOND, 0);
            ZoneId zone = temporal.query(TemporalQueries.zone());
            if (zone == null) {
                zone = ZoneId.of("UTC");
            }
            ZonedDateTime zonedDateTime = ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, zone);
            return Timestamp.from(Instant.from(zonedDateTime));
        });
    }

    private static int getOrDefault(TemporalAccessor temporal, TemporalField field, int defaultValue) {
        if (temporal.isSupported(field)) {
            return temporal.get(field);
        }
        return defaultValue;
    }

    private static abstract class JodaTime {
        private static final Object DATE_OPTIONAL_TIME_FORMATTER;
        private static final Method PARSE_DATE_TIME;
        private static final Method TO_CALENDAR;
        private static final boolean INITIALIZED;

        private JodaTime() {
        }

        public static Calendar parseDate(String value) {
            Object dt = ReflectionUtils.invoke(PARSE_DATE_TIME, DATE_OPTIONAL_TIME_FORMATTER, value);
            return (Calendar)ReflectionUtils.invoke(TO_CALENDAR, dt, new Object[0]);
        }

        static {
            boolean init = false;
            Method parseDateTime = null;
            Method toCalendar = null;
            Object dotf = null;
            try {
                ClassLoader cl = JodaTime.class.getClassLoader();
                Class<?> FORMAT_CLASS = ObjectUtils.loadClass("org.joda.time.format.ISODateTimeFormat", cl);
                Method DATE_OPTIONAL_TIME = ReflectionUtils.findMethod(FORMAT_CLASS, "dateOptionalTimeParser", new Class[0]);
                dotf = ReflectionUtils.invoke(DATE_OPTIONAL_TIME, null, new Object[0]);
                parseDateTime = ReflectionUtils.findMethod(dotf.getClass(), "parseDateTime", String.class);
                Class<?> DATE_TIME_CLASS = ObjectUtils.loadClass("org.joda.time.DateTime", cl);
                toCalendar = ReflectionUtils.findMethod(DATE_TIME_CLASS, "toGregorianCalendar", new Class[0]);
                init = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            DATE_OPTIONAL_TIME_FORMATTER = dotf;
            PARSE_DATE_TIME = parseDateTime;
            TO_CALENDAR = toCalendar;
            INITIALIZED = init;
        }
    }

    private static abstract class Jdk6 {
        private Jdk6() {
        }

        public static Calendar parseDate(String value) {
            int timeZoneIndex = value.indexOf("T");
            if (timeZoneIndex > 0) {
                int sign = value.indexOf("+", timeZoneIndex);
                if (sign < 0) {
                    sign = value.indexOf("-", timeZoneIndex);
                }
                if (sign > 0) {
                    int colonIndex = sign + 3;
                    if (colonIndex >= value.length()) {
                        value = value + ":00";
                    } else if (value.charAt(colonIndex) != ':') {
                        value = value.substring(0, colonIndex) + ":" + value.substring(colonIndex);
                    }
                }
            }
            return DatatypeConverter.parseDateTime((String)value);
        }
    }
}

