/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.util;

import java.lang.reflect.Array;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.OpenSearchHadoopIllegalStateException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.serialization.SettingsAware;
import org.opensearch.hadoop.util.Assert;

public abstract class ObjectUtils {
    public static <T> T instantiate(String className, ClassLoader loader) {
        Assert.hasText(className, "No class name given");
        ClassLoader cl = loader != null ? loader : ObjectUtils.class.getClassLoader();
        Class<?> clz = null;
        try {
            clz = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new OpenSearchHadoopIllegalStateException(String.format("Cannot load class [%s]", className), e);
        }
        try {
            return (T)clz.newInstance();
        }
        catch (Exception ex) {
            throw new OpenSearchHadoopIllegalStateException(String.format("Cannot instantiate class [%s]", className), ex);
        }
    }

    public static <T> T instantiate(String className, Settings settings) {
        return ObjectUtils.instantiate(className, null, settings);
    }

    public static <T> T instantiate(String className, ClassLoader loader, Settings settings) {
        T obj = ObjectUtils.instantiate(className, loader);
        if (obj instanceof SettingsAware) {
            ((SettingsAware)obj).setSettings(settings);
        }
        return obj;
    }

    public static boolean isClassPresent(String className, ClassLoader cl) {
        Class<?> clz = null;
        try {
            clz = Class.forName(className, false, cl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clz != null;
    }

    public static Class<?> loadClass(String className, ClassLoader cl) {
        try {
            return Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException ex) {
            throw new OpenSearchHadoopIllegalArgumentException(String.format("Cannot load class [%s]", className), ex);
        }
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return new Object[0];
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return new Object[0];
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source, i);
        }
        return newArray;
    }
}

