/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.util.ecs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HostData {
    private static final Log LOG = LogFactory.getLog(HostData.class);
    private static volatile HostData INSTANCE;
    private final boolean hasData;
    private final String name;
    private final String ip;
    private final Long timezoneOffsetSec;
    private final String osName;
    private final String osVersion;
    private final String architecture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HostData getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<HostData> clazz = HostData.class;
        synchronized (HostData.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = HostData.collectHostData();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static HostData collectHostData() {
        String hostip;
        String hostName;
        InetAddress localAddress;
        String osName = HostData.getPropOrNull("os.name");
        String osVersion = HostData.getPropOrNull("os.version");
        String osArch = HostData.getPropOrNull("os.arch");
        try {
            localAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)"Could not collect host information for error tracing. Continuing with null host info.", (Throwable)e);
            localAddress = null;
        }
        if (localAddress != null) {
            hostName = localAddress.getHostName();
            hostip = localAddress.getHostAddress();
        } else {
            hostName = null;
            hostip = null;
        }
        Long hostTz = TimeUnit.SECONDS.convert(TimeZone.getDefault().getRawOffset(), TimeUnit.MILLISECONDS);
        return new HostData(hostName, hostip, hostTz, osName, osVersion, osArch);
    }

    private static String getPropOrNull(String prop) {
        try {
            return AccessController.doPrivileged(new GetPropAction(prop));
        }
        catch (SecurityException se) {
            return null;
        }
    }

    public static HostData emptyHostData() {
        return new HostData(null, null, null, null, null, null);
    }

    private HostData(String hostName, String hostIp, Long hostTzOffset, String osName, String osVersion, String osArch) {
        this.name = hostName;
        this.ip = hostIp;
        this.timezoneOffsetSec = hostTzOffset;
        this.osName = osName;
        this.osVersion = osVersion;
        this.architecture = osArch;
        boolean hasData = hostName != null;
        hasData |= hostIp != null;
        hasData |= hostTzOffset != null;
        hasData |= osName != null;
        hasData |= osVersion != null;
        this.hasData = hasData |= osArch != null;
    }

    public boolean hasData() {
        return this.hasData;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public Long getTimezoneOffsetSec() {
        return this.timezoneOffsetSec;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostData hostData = (HostData)o;
        if (this.name != null ? !this.name.equals(hostData.name) : hostData.name != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals(hostData.ip) : hostData.ip != null) {
            return false;
        }
        if (this.timezoneOffsetSec != null ? !this.timezoneOffsetSec.equals(hostData.timezoneOffsetSec) : hostData.timezoneOffsetSec != null) {
            return false;
        }
        if (this.osName != null ? !this.osName.equals(hostData.osName) : hostData.osName != null) {
            return false;
        }
        if (this.osVersion != null ? !this.osVersion.equals(hostData.osVersion) : hostData.osVersion != null) {
            return false;
        }
        return this.architecture != null ? this.architecture.equals(hostData.architecture) : hostData.architecture == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.ip != null ? this.ip.hashCode() : 0);
        result = 31 * result + (this.timezoneOffsetSec != null ? this.timezoneOffsetSec.hashCode() : 0);
        result = 31 * result + (this.osName != null ? this.osName.hashCode() : 0);
        result = 31 * result + (this.osVersion != null ? this.osVersion.hashCode() : 0);
        result = 31 * result + (this.architecture != null ? this.architecture.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HostData{hostName='" + this.name + '\'' + ", hostIp='" + this.ip + '\'' + ", hostTzOffset=" + this.timezoneOffsetSec + ", osName='" + this.osName + '\'' + ", osVersion='" + this.osVersion + '\'' + ", osArch='" + this.architecture + '\'' + '}';
    }

    private static class GetPropAction
    implements PrivilegedAction<String> {
        private final String propName;

        GetPropAction(String propName) {
            this.propName = propName;
        }

        @Override
        public String run() {
            return System.getProperty(this.propName);
        }
    }
}

