/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spark.deploy.yarn.security;

import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.spark.SparkConf;
import org.apache.spark.security.HadoopDelegationTokenProvider;
import org.opensearch.hadoop.cfg.CompositeSettings;
import org.opensearch.hadoop.cfg.HadoopSettingsManager;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.mr.security.HadoopUserProvider;
import org.opensearch.hadoop.mr.security.OpenSearchTokenIdentifier;
import org.opensearch.hadoop.rest.InitializationUtils;
import org.opensearch.hadoop.rest.RestClient;
import org.opensearch.hadoop.security.AuthenticationMethod;
import org.opensearch.hadoop.security.OpenSearchToken;
import org.opensearch.hadoop.security.User;
import org.opensearch.hadoop.security.UserProvider;
import org.opensearch.spark.cfg.SparkSettingsManager;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r4AAB\u0004\u0001)!)1\u0005\u0001C\u0001I!1q\u0005\u0001Q\u0001\n!BQ\u0001\r\u0001\u0005BEBQ!\u0010\u0001\u0005ByBQA\u0015\u0001\u0005BM\u00131e\u00149f]N+\u0017M]2i'\u0016\u0014h/[2f\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'O\u0003\u0002\t\u0013\u0005A1/Z2ve&$\u0018P\u0003\u0002\u000b\u0017\u0005!\u00110\u0019:o\u0015\taQ\"\u0001\u0004eKBdw.\u001f\u0006\u0003\u001d=\tQa\u001d9be.T!\u0001E\t\u0002\u0015=\u0004XM\\:fCJ\u001c\u0007NC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\r\u0001Qc\u0007\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005q\tS\"A\u000f\u000b\u0005!q\"B\u0001\b \u0015\t\u0001\u0013#\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Eu\u0011Q\u0004S1e_>\u0004H)\u001a7fO\u0006$\u0018n\u001c8U_.,g\u000e\u0015:pm&$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u0003\u001d\t1\u0001T(H!\tIc&D\u0001+\u0015\tYC&A\u0004m_\u001e<\u0017N\\4\u000b\u00055z\u0012aB2p[6|gn]\u0005\u0003_)\u00121\u0001T8h\u0003-\u0019XM\u001d<jG\u0016t\u0015-\\3\u0016\u0003I\u0002\"a\r\u001e\u000f\u0005QB\u0004CA\u001b\u0018\u001b\u00051$BA\u001c\u0014\u0003\u0019a$o\\8u}%\u0011\u0011hF\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:/\u0005AB-\u001a7fO\u0006$\u0018n\u001c8U_.,gn\u001d*fcVL'/\u001a3\u0015\u0007}\u0012\u0005\n\u0005\u0002\u0017\u0001&\u0011\u0011i\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019E\u00011\u0001E\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002F\r6\ta$\u0003\u0002H=\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0006\u0013\u0012\u0001\rAS\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007CA&Q\u001b\u0005a%BA'O\u0003\u0011\u0019wN\u001c4\u000b\u0005={\u0012A\u00025bI>|\u0007/\u0003\u0002R\u0019\ni1i\u001c8gS\u001e,(/\u0019;j_:\fac\u001c2uC&tG)\u001a7fO\u0006$\u0018n\u001c8U_.,gn\u001d\u000b\u0005)j[F\fE\u0002\u0017+^K!AV\f\u0003\r=\u0003H/[8o!\t1\u0002,\u0003\u0002Z/\t!Aj\u001c8h\u0011\u0015IU\u00011\u0001K\u0011\u0015\u0019U\u00011\u0001E\u0011\u0015iV\u00011\u0001_\u0003\u0015\u0019'/\u001a3t!\ty\u0016-D\u0001a\u0015\tAa*\u0003\u0002cA\nY1I]3eK:$\u0018.\u00197t\u0001")
public class OpenSearchServiceCredentialProvider
implements HadoopDelegationTokenProvider {
    private final Log LOG = LogFactory.getLog(OpenSearchServiceCredentialProvider.class);

    public String serviceName() {
        return "opensearch";
    }

    public boolean delegationTokensRequired(SparkConf sparkConf, Configuration hadoopConf) {
        Settings settings = sparkConf != null ? new CompositeSettings(Arrays.asList((Object[])new Settings[]{new SparkSettingsManager().load(sparkConf), new HadoopSettingsManager().load(hadoopConf)})) : HadoopSettingsManager.loadFrom(hadoopConf);
        boolean isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
        AuthenticationMethod esAuthMethod = settings.getSecurityAuthenticationMethod();
        boolean required = isSecurityEnabled && AuthenticationMethod.KERBEROS.equals((Object)esAuthMethod);
        this.LOG.info((Object)new StringBuilder(28).append("Hadoop Security Enabled = [").append(isSecurityEnabled).append("]").toString());
        this.LOG.info((Object)new StringBuilder(27).append("OpenSearch Auth Method = [").append((Object)esAuthMethod).append("]").toString());
        this.LOG.info((Object)new StringBuilder(23).append("Are creds required = [").append(required).append("]").toString());
        return required;
    }

    public Option<Object> obtainDelegationTokens(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        Some some;
        CompositeSettings settings = new CompositeSettings(Arrays.asList((Object[])new Settings[]{new SparkSettingsManager().load(sparkConf), new HadoopSettingsManager().load(hadoopConf)}));
        InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, LogFactory.getLog(OpenSearchServiceCredentialProvider.class));
        UserProvider userProvider = UserProvider.create(settings);
        try (RestClient client = new RestClient(settings);){
            User user = userProvider.getUser();
            OpenSearchToken opensearchToken = user.doAs(new PrivilegedExceptionAction<OpenSearchToken>(null, client){
                private final RestClient client$1;

                public OpenSearchToken run() {
                    return this.client$1.createNewApiToken(new StringBuilder(17).append("OPENSEARCHHADOOP_").append(UUID.randomUUID().toString()).toString());
                }
                {
                    this.client$1 = client$1;
                }
            });
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)new StringBuilder(0).append(new StringBuilder(42).append("getting token for: OpenSearch[tokenName=").append(opensearchToken.getName()).append(", ").toString()).append(new StringBuilder(20).append("clusterName=").append(opensearchToken.getClusterName()).append(", user=").append(user).append("]").toString()).toString());
            }
            long expiration = opensearchToken.getExpirationTime();
            Token<OpenSearchTokenIdentifier> token = OpenSearchTokenIdentifier.createTokenFrom(opensearchToken);
            creds.addToken(token.getService(), token);
            some = new Some((Object)BoxesRunTime.boxToLong((long)expiration));
        }
        return some;
    }

    public OpenSearchServiceCredentialProvider() {
        this.LOG.info((Object)"Loaded OpenSearchServiceCredentialProvider");
    }
}

