/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spark.rdd;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.TaskContext;
import org.apache.spark.package$;
import org.apache.spark.util.TaskCompletionListener;
import org.opensearch.hadoop.OpenSearchHadoopIllegalStateException;
import org.opensearch.hadoop.util.ObjectUtils;
import org.opensearch.hadoop.util.ReflectionUtils;
import org.opensearch.spark.rdd.CompatibilityLevel;
import scala.Function0;

abstract class CompatUtils {
    private static final Class<?> SCHEMA_RDD_LIKE_CLASS;

    CompatUtils() {
    }

    static void checkSparkLibraryCompatibility(boolean throwOnIncompatible) {
        boolean isSpark20Level = ObjectUtils.isClassPresent("org.apache.spark.sql.streaming.StreamingQuery", SparkConf.class.getClassLoader());
        try {
            CompatibilityLevel compatibilityLevel = (CompatibilityLevel)ObjectUtils.instantiate("org.opensearch.spark.sql.SparkSQLCompatibilityLevel", CompatUtils.class.getClassLoader());
            boolean isOpenSearchForSpark20 = "20".equals(compatibilityLevel.versionId());
            String esSupportedSparkVersion = compatibilityLevel.versionDescription();
            String errorMessage = null;
            if (!isSpark20Level) {
                String sparkVersion = CompatUtils.getSparkVersionOr("1.0-1.2");
                errorMessage = String.format("Incorrect classpath detected; OpenSearch Spark compiled for Spark %s but used with unsupported Spark version %s", esSupportedSparkVersion, sparkVersion);
            } else if (isSpark20Level != isOpenSearchForSpark20) {
                String sparkVersion = CompatUtils.getSparkVersionOr("2.0+");
                errorMessage = String.format("Incorrect classpath detected; OpenSearch Spark compiled for Spark %s but used with Spark %s", esSupportedSparkVersion, sparkVersion);
            }
            if (errorMessage != null) {
                if (throwOnIncompatible) {
                    throw new OpenSearchHadoopIllegalStateException(errorMessage);
                }
                LogFactory.getLog((String)"org.opensearch.spark.rdd.OpenSearchSpark").warn(errorMessage);
            }
        }
        catch (OpenSearchHadoopIllegalStateException noClass) {
            String errorMessage = "OpenSearch Spark SQL support could not be verified.";
            if (throwOnIncompatible) {
                throw new OpenSearchHadoopIllegalStateException(errorMessage, noClass);
            }
            LogFactory.getLog((String)"org.opensearch.spark.rdd.OpenSearchSpark").info((Object)(errorMessage + " Continuing with core support."));
        }
    }

    private static String getSparkVersionOr(String defaultValue) {
        String sparkVersion = null;
        SparkContext$ target = SparkContext$.MODULE$;
        Method sparkVersionMethod = ReflectionUtils.findMethod(target.getClass(), "SPARK_VERSION", new Class[0]);
        if (sparkVersionMethod == null) {
            target = package$.MODULE$;
            sparkVersionMethod = ReflectionUtils.findMethod(target.getClass(), "SPARK_VERSION", new Class[0]);
        }
        sparkVersion = sparkVersionMethod != null ? (String)ReflectionUtils.invoke(sparkVersionMethod, target, new Object[0]) : defaultValue;
        return sparkVersion;
    }

    static void addOnCompletition(TaskContext taskContext, final Function0<?> function) {
        taskContext.addTaskCompletionListener(new TaskCompletionListener(){

            public void onTaskCompletion(TaskContext context) {
                function.apply();
            }
        });
    }

    static boolean isInterrupted(TaskContext taskContext) {
        return taskContext.isInterrupted();
    }

    static void warnSchemaRDD(Object rdd, Log log) {
        if (rdd != null && SCHEMA_RDD_LIKE_CLASS != null && SCHEMA_RDD_LIKE_CLASS.isAssignableFrom(rdd.getClass())) {
            log.warn((Object)"basic RDD saveToOpenSearch() called on a Spark SQL SchemaRDD; typically this is a mistake(as the SQL schema will be ignored). Use 'org.opensearch.spark.sql' package instead");
        }
    }

    static {
        Class<?> clz = null;
        try {
            clz = Class.forName("org.apache.spark.sql.SchemaRDDLike", false, CompatUtils.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SCHEMA_RDD_LIKE_CLASS = clz;
        CompatUtils.checkSparkLibraryCompatibility(false);
    }
}

