/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spark.rdd;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.TaskContext;
import org.apache.spark.util.TaskCompletionListener;
import org.opensearch.hadoop.cfg.PropertiesSettings;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.mr.security.HadoopUserProvider;
import org.opensearch.hadoop.rest.InitializationUtils;
import org.opensearch.hadoop.rest.RestService;
import org.opensearch.hadoop.security.UserProvider;
import org.opensearch.hadoop.serialization.BytesConverter;
import org.opensearch.hadoop.serialization.JdkBytesConverter;
import org.opensearch.hadoop.serialization.builder.ValueWriter;
import org.opensearch.hadoop.serialization.bulk.MetadataExtractor;
import org.opensearch.hadoop.serialization.field.FieldExtractor;
import org.opensearch.hadoop.util.ObjectUtils;
import org.opensearch.spark.rdd.OpenSearchRDDWriter$;
import org.opensearch.spark.serialization.ScalaMapFieldExtractor;
import org.opensearch.spark.serialization.ScalaMetadataExtractor;
import org.opensearch.spark.serialization.ScalaValueWriter;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005mh!\u0002\f\u0018\u0001ey\u0002\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u001b\t\u0011y\u0002!\u0011!Q\u0001\nYB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001B\u0002B\u0003-a\tC\u0003X\u0001\u0011\u0005\u0001\f\u0003\u0005`\u0001!\u0015\r\u0011\"\u0005a\u0011!y\u0007\u0001#b\u0001\n\u0003\u0001\b\u0002C=\u0001\u0011\u000b\u0007I\u0011\u0001>\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u0011\u0011\u0006\u0001\u0005\u0012\u0005-\u0002bBA*\u0001\u0011E\u0011Q\u000b\u0005\b\u0003W\u0002A\u0011CA7\u0011\u001d\t9\t\u0001C\t\u0003\u0013Cq!a&\u0001\t#\tI\nC\u0004\u00024\u0002!\t\"!.\b\u0015\u0005ev#!A\t\u0002e\tYLB\u0005\u0017/\u0005\u0005\t\u0012A\r\u0002>\"1qK\u0005C\u0001\u0003\u001bD\u0011\"a4\u0013#\u0003%\t!!5\t\u0013\u0005-(#!A\u0005\n\u00055(aE(qK:\u001cV-\u0019:dQJ#Ei\u0016:ji\u0016\u0014(B\u0001\r\u001a\u0003\r\u0011H\r\u001a\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\u0015=\u0004XM\\:fCJ\u001c\u0007NC\u0001\u001f\u0003\ry'oZ\u000b\u0003A9\u001b2\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001&\r\b\u0003S=r!A\u000b\u0018\u000e\u0003-R!\u0001L\u0017\u0002\rq\u0012xn\u001c;?\u0007\u0001I\u0011\u0001J\u0005\u0003a\r\nq\u0001]1dW\u0006<W-\u0003\u00023g\ta1+\u001a:jC2L'0\u00192mK*\u0011\u0001gI\u0001\u0013g\u0016\u0014\u0018.\u00197ju\u0016$7+\u001a;uS:<7/F\u00017!\t94H\u0004\u00029sA\u0011!fI\u0005\u0003u\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!hI\u0001\u0014g\u0016\u0014\u0018.\u00197ju\u0016$7+\u001a;uS:<7\u000fI\u0001\u0010eVtG/[7f\u001b\u0016$\u0018\rZ1uCV\t\u0011\t\u0005\u0002#\u0005&\u00111i\t\u0002\b\u0005>|G.Z1o\u0003A\u0011XO\u001c;j[\u0016lU\r^1eCR\f\u0007%\u0001\u0006fm&$WM\\2fIE\u00022a\u0012&M\u001b\u0005A%BA%$\u0003\u001d\u0011XM\u001a7fGRL!a\u0013%\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"!\u0014(\r\u0001\u0011)q\n\u0001b\u0001!\n\tA+\u0005\u0002R)B\u0011!EU\u0005\u0003'\u000e\u0012qAT8uQ&tw\r\u0005\u0002#+&\u0011ak\t\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\bF\u0002Z;z#\"A\u0017/\u0011\u0007m\u0003A*D\u0001\u0018\u0011\u0015)e\u0001q\u0001G\u0011\u0015!d\u00011\u00017\u0011\u001dyd\u0001%AA\u0002\u0005\u000b1\u0001\\8h+\u0005\t\u0007C\u00012j\u001b\u0005\u0019'B\u00013f\u0003\u001dawnZ4j]\u001eT!AZ4\u0002\u000f\r|W.\\8og*\u0011\u0001.H\u0001\u0007CB\f7\r[3\n\u0005)\u001c'a\u0001'pO\"\u0012q\u0001\u001c\t\u0003E5L!A\\\u0012\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001C:fiRLgnZ:\u0016\u0003E\u0004\"A]<\u000e\u0003MT!\u0001^;\u0002\u0007\r4wM\u0003\u0002w7\u00051\u0001.\u00193p_BL!\u0001_:\u0003\u0011M+G\u000f^5oON\fQ\"\\3uC\u0016CHO]1di>\u0014X#A>\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0\u0001\u0003ck2\\'bAA\u0001k\u0006i1/\u001a:jC2L'0\u0019;j_:L1!!\u0002~\u0005EiU\r^1eCR\fW\t\u001f;sC\u000e$xN]\u0001\u0006oJLG/\u001a\u000b\u0007\u0003\u0017\t\t\"a\b\u0011\u0007\t\ni!C\u0002\u0002\u0010\r\u0012A!\u00168ji\"9\u00111\u0003\u0006A\u0002\u0005U\u0011a\u0003;bg.\u001cuN\u001c;fqR\u0004B!a\u0006\u0002\u001c5\u0011\u0011\u0011\u0004\u0006\u00035\u001dLA!!\b\u0002\u001a\tYA+Y:l\u0007>tG/\u001a=u\u0011\u001d\t\tC\u0003a\u0001\u0003G\tA\u0001Z1uCB!\u0001&!\nM\u0013\r\t9c\r\u0002\t\u0013R,'/\u0019;pe\u0006Ya/\u00197vK^\u0013\u0018\u000e^3s+\t\ti\u0003\r\u0003\u00020\u0005]\u0002#B\u001c\u00022\u0005U\u0012bAA\u001a{\t)1\t\\1tgB\u0019Q*a\u000e\u0005\u0017\u0005e2\"!A\u0001\u0002\u000b\u0005\u00111\b\u0002\u0004?\u0012\n\u0014cA)\u0002>A\"\u0011qHA'!\u0019\t\t%a\u0012\u0002L5\u0011\u00111\t\u0006\u0004\u0003\u000bz\u0018a\u00022vS2$WM]\u0005\u0005\u0003\u0013\n\u0019EA\u0006WC2,Xm\u0016:ji\u0016\u0014\bcA'\u0002N\u0011Y\u0011qJA)\u0003\u0003\u0005\tQ!\u0001Q\u0005\ryFE\r\u0003\f\u0003sY\u0011\u0011aA\u0001\u0006\u0003\tY$\u0001\bcsR,7oQ8om\u0016\u0014H/\u001a:\u0016\u0005\u0005]\u0003\u0007BA-\u0003;\u0002RaNA\u0019\u00037\u00022!TA/\t-\ty\u0006DA\u0001\u0002\u0003\u0015\t!!\u0019\u0003\u0007}#3'E\u0002R\u0003G\u0002B!!\u001a\u0002h5\tq0C\u0002\u0002j}\u0014aBQ=uKN\u001cuN\u001c<feR,'/\u0001\bgS\u0016dG-\u0012=ue\u0006\u001cGo\u001c:\u0016\u0005\u0005=\u0004\u0007BA9\u0003k\u0002RaNA\u0019\u0003g\u00022!TA;\t-\t9(DA\u0001\u0002\u0003\u0015\t!!\u001f\u0003\u0007}#C'E\u0002R\u0003w\u0002B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003{\u0018!\u00024jK2$\u0017\u0002BAC\u0003\u007f\u0012aBR5fY\u0012,\u0005\u0010\u001e:bGR|'/A\tnKR\fG-\u0019;b\u000bb$(/Y2u_J,\"!a#1\t\u00055\u0015\u0011\u0013\t\u0006o\u0005E\u0012q\u0012\t\u0004\u001b\u0006EEaCAJ\u001d\u0005\u0005\t\u0011!B\u0001\u0003+\u00131a\u0018\u00136#\t\t60\u0001\u0007vg\u0016\u0014\bK]8wS\u0012,'/\u0006\u0002\u0002\u001cB\"\u0011QTAQ!\u00159\u0014\u0011GAP!\ri\u0015\u0011\u0015\u0003\f\u0003G{\u0011\u0011!A\u0001\u0006\u0003\t)KA\u0002`IY\n2!UAT!\u0011\tI+a,\u000e\u0005\u0005-&bAAWk\u0006A1/Z2ve&$\u00180\u0003\u0003\u00022\u0006-&\u0001D+tKJ\u0004&o\u001c<jI\u0016\u0014\u0018a\u00039s_\u000e,7o\u001d#bi\u0006$2\u0001VA\\\u0011\u001d\t\t\u0003\u0005a\u0001\u0003G\t1c\u00149f]N+\u0017M]2i%\u0012#uK]5uKJ\u0004\"a\u0017\n\u0014\tI\t\u0013q\u0018\t\u0005\u0003\u0003\fY-\u0004\u0002\u0002D*!\u0011QYAd\u0003\tIwN\u0003\u0002\u0002J\u0006!!.\u0019<b\u0013\r\u0011\u00141\u0019\u000b\u0003\u0003w\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012T\u0003BAj\u0003S,\"!!6+\u0007\u0005\u000b9n\u000b\u0002\u0002ZB!\u00111\\As\u001b\t\tiN\u0003\u0003\u0002`\u0006\u0005\u0018!C;oG\",7m[3e\u0015\r\t\u0019oI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAt\u0003;\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015yEC1\u0001Q\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\u000f\u0005\u0003\u0002r\u0006]XBAAz\u0015\u0011\t)0a2\u0002\t1\fgnZ\u0005\u0005\u0003s\f\u0019P\u0001\u0004PE*,7\r\u001e")
public class OpenSearchRDDWriter<T>
implements Serializable {
    private transient Log log;
    private Settings settings;
    private MetadataExtractor metaExtractor;
    private final String serializedSettings;
    private final boolean runtimeMetadata;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static <T> boolean $lessinit$greater$default$2() {
        return OpenSearchRDDWriter$.MODULE$.$lessinit$greater$default$2();
    }

    public String serializedSettings() {
        return this.serializedSettings;
    }

    public boolean runtimeMetadata() {
        return this.runtimeMetadata;
    }

    private Log log$lzycompute() {
        OpenSearchRDDWriter openSearchRDDWriter = this;
        synchronized (openSearchRDDWriter) {
            if (!this.bitmap$trans$0) {
                this.log = LogFactory.getLog(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Log log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    /*
     * WARNING - void declaration
     */
    private Settings settings$lzycompute() {
        OpenSearchRDDWriter openSearchRDDWriter = this;
        synchronized (openSearchRDDWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                Settings settings = new PropertiesSettings().load(this.serializedSettings());
                InitializationUtils.setValueWriterIfNotSet(settings, this.valueWriter(), this.log());
                InitializationUtils.setBytesConverterIfNeeded(settings, this.bytesConverter(), this.log());
                InitializationUtils.setFieldExtractorIfNotSet(settings, this.fieldExtractor(), this.log());
                InitializationUtils.setMetadataExtractorIfNotSet(settings, this.metadataExtractor(), this.log());
                InitializationUtils.setUserProviderIfNotSet(settings, this.userProvider(), this.log());
                this.settings = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.settings;
    }

    public Settings settings() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.settings$lzycompute() : this.settings;
    }

    private MetadataExtractor metaExtractor$lzycompute() {
        OpenSearchRDDWriter openSearchRDDWriter = this;
        synchronized (openSearchRDDWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.metaExtractor = (MetadataExtractor)ObjectUtils.instantiate(this.settings().getMappingMetadataExtractorClassName(), this.settings());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.metaExtractor;
    }

    public MetadataExtractor metaExtractor() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.metaExtractor$lzycompute() : this.metaExtractor;
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        Object object = this.settings().getOpaqueId() != null && !this.settings().getOpaqueId().contains("] [task attempt ") ? this.settings().setOpaqueId(String.format(Locale.ROOT, "%s [stage %s] [task attempt %s]", this.settings().getOpaqueId(), Integer.toString(taskContext.stageId()), Long.toString(taskContext.taskAttemptId()))) : BoxedUnit.UNIT;
        RestService.PartitionWriter writer = RestService.createWriter(this.settings(), taskContext.partitionId(), -1, this.log());
        TaskCompletionListener listener = new TaskCompletionListener(null, writer){
            private final RestService.PartitionWriter writer$1;

            public void onTaskCompletion(TaskContext context) {
                this.writer$1.close();
            }
            {
                this.writer$1 = writer$1;
            }
        };
        taskContext.addTaskCompletionListener(listener);
        if (this.runtimeMetadata()) {
            writer.repository.addRuntimeFieldExtractor(this.metaExtractor());
        }
        while (data.hasNext()) {
            writer.repository.writeToIndex(this.processData(data));
        }
    }

    public Class<? extends ValueWriter<?>> valueWriter() {
        return ScalaValueWriter.class;
    }

    public Class<? extends BytesConverter> bytesConverter() {
        return JdkBytesConverter.class;
    }

    public Class<? extends FieldExtractor> fieldExtractor() {
        return ScalaMapFieldExtractor.class;
    }

    public Class<? extends MetadataExtractor> metadataExtractor() {
        return ScalaMetadataExtractor.class;
    }

    public Class<? extends UserProvider> userProvider() {
        return HadoopUserProvider.class;
    }

    /*
     * WARNING - void declaration
     */
    public Object processData(Iterator<T> data) {
        Object object;
        Object next = data.next();
        if (this.runtimeMetadata()) {
            Object object2 = next;
            if (!(object2 instanceof Tuple2)) {
                throw new MatchError(object2);
            }
            Tuple2 tuple2 = (Tuple2)object2;
            Object key = tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = new Tuple2(key, value);
            Tuple2 tuple23 = tuple22;
            Object key2 = tuple23._1();
            Object value2 = tuple23._2();
            this.metaExtractor().setObject(key2);
            object = value2;
        } else {
            void var3_2;
            object = var3_2;
        }
        return object;
    }

    public OpenSearchRDDWriter(String serializedSettings, boolean runtimeMetadata, ClassTag<T> evidence$1) {
        this.serializedSettings = serializedSettings;
        this.runtimeMetadata = runtimeMetadata;
    }
}

