/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spark.rdd;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.opensearch.hadoop.cfg.PropertiesSettings;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.mr.security.HadoopUserProvider;
import org.opensearch.hadoop.rest.InitializationUtils;
import org.opensearch.spark.cfg.SparkSettings;
import org.opensearch.spark.cfg.SparkSettingsManager;
import org.opensearch.spark.rdd.CompatUtils;
import org.opensearch.spark.rdd.OpenSearchRDDWriter;
import org.opensearch.spark.rdd.ScalaOpenSearchRDD;
import org.opensearch.spark.rdd.ScalaOpenSearchRDD$;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class OpenSearchSpark$ {
    public static final OpenSearchSpark$ MODULE$ = new OpenSearchSpark$();
    private static final transient Log LOG = LogFactory.getLog(MODULE$.getClass());

    public RDD<Tuple2<String, Map<String, Object>>> opensearchRDD(SparkContext sc) {
        return new ScalaOpenSearchRDD<Map<String, Object>>(sc, ScalaOpenSearchRDD$.MODULE$.$lessinit$greater$default$2());
    }

    public RDD<Tuple2<String, Map<String, Object>>> opensearchRDD(SparkContext sc, Map<String, String> cfg) {
        return new ScalaOpenSearchRDD<Map<String, Object>>(sc, cfg);
    }

    public RDD<Tuple2<String, Map<String, Object>>> opensearchRDD(SparkContext sc, String resource) {
        return new ScalaOpenSearchRDD<Map<String, Object>>(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource)}))));
    }

    public RDD<Tuple2<String, Map<String, Object>>> opensearchRDD(SparkContext sc, String resource, String query) {
        return new ScalaOpenSearchRDD<Map<String, Object>>(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.query"), (Object)query)}))));
    }

    public RDD<Tuple2<String, Map<String, Object>>> opensearchRDD(SparkContext sc, String resource, Map<String, String> cfg) {
        return new ScalaOpenSearchRDD<Map<String, Object>>(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource))));
    }

    public RDD<Tuple2<String, Map<String, Object>>> opensearchRDD(SparkContext sc, String resource, String query, Map<String, String> cfg) {
        return new ScalaOpenSearchRDD<Map<String, Object>>(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.query"), (Object)query), (Seq)Nil$.MODULE$)));
    }

    public RDD<Tuple2<String, String>> openSearchJsonRDD(SparkContext sc) {
        return new ScalaOpenSearchRDD<String>(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.output.json"), (Object)Boolean.toString(true))}))));
    }

    public RDD<Tuple2<String, String>> openSearchJsonRDD(SparkContext sc, Map<String, String> cfg) {
        return new ScalaOpenSearchRDD<String>(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.output.json"), (Object)Boolean.toString(true)))));
    }

    public RDD<Tuple2<String, String>> openSearchJsonRDD(SparkContext sc, String resource) {
        return new ScalaOpenSearchRDD<String>(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.output.json"), (Object)Boolean.toString(true))}))));
    }

    public RDD<Tuple2<String, String>> openSearchJsonRDD(SparkContext sc, String resource, String query) {
        return new ScalaOpenSearchRDD<String>(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.query"), (Object)query), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.output.json"), (Object)Boolean.toString(true))}))));
    }

    public RDD<Tuple2<String, String>> openSearchJsonRDD(SparkContext sc, String resource, Map<String, String> cfg) {
        return new ScalaOpenSearchRDD<String>(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.output.json"), (Object)Boolean.toString(true)), (Seq)Nil$.MODULE$)));
    }

    public RDD<Tuple2<String, String>> openSearchJsonRDD(SparkContext sc, String resource, String query, Map<String, String> cfg) {
        return new ScalaOpenSearchRDD<String>(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.read"), (Object)resource), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.query"), (Object)query), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.output.json"), (Object)Boolean.toString(true))}))));
    }

    public void saveToOpenSearch(RDD<?> rdd, String resource) {
        this.saveToOpenSearch(rdd, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.write"), (Object)resource)}))));
    }

    public void saveToOpenSearch(RDD<?> rdd, String resource, Map<String, String> cfg) {
        this.saveToOpenSearch(rdd, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.write"), (Object)resource))));
    }

    public void saveToOpenSearch(RDD<?> rdd, Map<String, String> cfg) {
        this.doSaveToOpenSearch(rdd, cfg, false);
    }

    public <K, V> void saveToOpenSearchWithMeta(RDD<Tuple2<K, V>> rdd, String resource) {
        this.saveToOpenSearchWithMeta(rdd, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.write"), (Object)resource)}))));
    }

    public <K, V> void saveToOpenSearchWithMeta(RDD<Tuple2<K, V>> rdd, String resource, Map<String, String> cfg) {
        this.saveToOpenSearchWithMeta(rdd, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.resource.write"), (Object)resource))));
    }

    public <K, V> void saveToOpenSearchWithMeta(RDD<Tuple2<K, V>> rdd, Map<String, String> cfg) {
        this.doSaveToOpenSearch(rdd, cfg, true);
    }

    public void doSaveToOpenSearch(RDD<?> rdd, Map<String, String> cfg, boolean hasMeta) {
        CompatUtils.warnSchemaRDD(rdd, LogFactory.getLog((String)"org.opensearch.spark.rdd.OpenSearchSpark"));
        if (rdd == null || rdd.partitions().length == 0) {
            return;
        }
        SparkSettings sparkCfg = new SparkSettingsManager().load(rdd.sparkContext().getConf());
        Settings config = new PropertiesSettings().load(sparkCfg.save());
        config.merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
        InitializationUtils.setUserProviderIfNotSet(config, HadoopUserProvider.class, LOG);
        InitializationUtils.discoverClusterInfo(config, LOG);
        InitializationUtils.checkIdForOperation(config);
        InitializationUtils.checkIndexExistence(config);
        OpenSearchRDDWriter openSearchRDDWriter = new OpenSearchRDDWriter(config.save(), hasMeta, ClassTag$.MODULE$.Any());
        rdd.sparkContext().runJob(rdd, (Function2 & Serializable)(taskContext, data) -> {
            openSearchRDDWriter.write(taskContext, data);
            return BoxedUnit.UNIT;
        }, (ClassTag)ClassTag$.MODULE$.Unit());
    }

    public void saveJsonToOpenSearch(RDD<?> rdd, String resource) {
        this.saveToOpenSearch(rdd, resource, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.input.json"), (Object)Boolean.toString(true))}))));
    }

    public void saveJsonToOpenSearch(RDD<?> rdd, String resource, Map<String, String> cfg) {
        this.saveToOpenSearch(rdd, resource, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.input.json"), (Object)Boolean.toString(true)))));
    }

    public void saveJsonToOpenSearch(RDD<?> rdd, Map<String, String> cfg) {
        this.saveToOpenSearch(rdd, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"opensearch.input.json"), (Object)Boolean.toString(true)))));
    }

    private OpenSearchSpark$() {
    }
}

