/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spark.sql.streaming;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.opensearch.hadoop.util.Assert;
import org.opensearch.spark.sql.streaming.JobState;
import org.opensearch.spark.sql.streaming.OpenSearchSinkStatus;
import org.opensearch.spark.sql.streaming.TaskCommit;
import org.opensearch.spark.sql.streaming.TaskState;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\n\u0014\u0001yA\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005g!)!\n\u0001C\u0001\u0017\"Aa\n\u0001EC\u0002\u0013\u0005q\nC\u0003Z\u0001\u0011\u0005!\fC\u0003d\u0001\u0011\u0005A\rC\u0003o\u0001\u0011\u0005q\u000eC\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\"Ia\u000f\u0001a\u0001\u0002\u0004%\ta\u001e\u0005\nu\u0002\u0001\r\u0011!Q!\nMD\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011\u0001:\t\u0013u\u0004\u0001\u0019!a\u0001\n\u0003q\bBCA\u0001\u0001\u0001\u0007\t\u0011)Q\u0005g\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\ti\u0002\u0001C\u0001\u0003?\u0011\u0001d\u00149f]N+\u0017M]2i\u0007>lW.\u001b;Qe>$xnY8m\u0015\t!R#A\u0005tiJ,\u0017-\\5oO*\u0011acF\u0001\u0004gFd'B\u0001\r\u001a\u0003\u0015\u0019\b/\u0019:l\u0015\tQ2$\u0001\u0006pa\u0016t7/Z1sG\"T\u0011\u0001H\u0001\u0004_J<7\u0001A\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002']9\u0011q\u0005\f\b\u0003Q-j\u0011!\u000b\u0006\u0003Uu\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0012\n\u00055\n\u0013a\u00029bG.\fw-Z\u0005\u0003_A\u0012AbU3sS\u0006d\u0017N_1cY\u0016T!!L\u0011\u0002\u0013\r|W.\\5u\u0019><W#A\u001a\u0011\u0007Qbd(D\u00016\u0015\t!bG\u0003\u00028q\u0005IQ\r_3dkRLwN\u001c\u0006\u0003-eR!\u0001\u0007\u001e\u000b\u0005mZ\u0012AB1qC\u000eDW-\u0003\u0002>k\tYQ*\u001a;bI\u0006$\u0018\rT8h!\r\u0001s(Q\u0005\u0003\u0001\u0006\u0012Q!\u0011:sCf\u0004\"AQ\"\u000e\u0003MI!\u0001R\n\u0003)=\u0003XM\\*fCJ\u001c\u0007nU5oWN#\u0018\r^;t\u0003)\u0019w.\\7ji2{w\r\t\u0015\u0003\u0005\u001d\u0003\"\u0001\t%\n\u0005%\u000b#!\u0003;sC:\u001c\u0018.\u001a8u\u0003\u0019a\u0014N\\5u}Q\u0011A*\u0014\t\u0003\u0005\u0002AQ!M\u0002A\u0002M\na\u0001\\8hO\u0016\u0014X#\u0001)\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016a\u00027pO\u001eLgn\u001a\u0006\u0003+j\nqaY8n[>t7/\u0003\u0002X%\n\u0019Aj\\4)\u0005\u00119\u0015aB5oSRTuN\u0019\u000b\u00037z\u0003\"\u0001\t/\n\u0005u\u000b#\u0001B+oSRDQaX\u0003A\u0002\u0001\f\u0001B[8c'R\fG/\u001a\t\u0003\u0005\u0006L!AY\n\u0003\u0011){'m\u0015;bi\u0016\f\u0011bY8n[&$(j\u001c2\u0015\u0007m+g\rC\u0003`\r\u0001\u0007\u0001\rC\u0003h\r\u0001\u0007\u0001.A\u0006uCN\\7i\\7nSR\u001c\bc\u0001\u0014jW&\u0011!\u000e\r\u0002\u0004'\u0016\f\bC\u0001\"m\u0013\ti7C\u0001\u0006UCN\\7i\\7nSR\f\u0001\"\u00192peRTuN\u0019\u000b\u00037BDQaX\u0004A\u0002\u0001\faB]3d_J$7o\u0016:jiR,g.F\u0001t!\t\u0001C/\u0003\u0002vC\t!Aj\u001c8h\u0003I\u0011XmY8sIN<&/\u001b;uK:|F%Z9\u0015\u0005mC\bbB=\n\u0003\u0003\u0005\ra]\u0001\u0004q\u0012\n\u0014a\u0004:fG>\u0014Hm],sSR$XM\u001c\u0011)\u0005)9\u0015AD3yK\u000e,H/[8o'R\f'\u000f^\u0001\u0013Kb,7-\u001e;j_:\u001cF/\u0019:u?\u0012*\u0017\u000f\u0006\u0002\\\u007f\"9\u0011\u0010DA\u0001\u0002\u0004\u0019\u0018aD3yK\u000e,H/[8o'R\f'\u000f\u001e\u0011)\u000559\u0015\u0001C5oSR$\u0016m]6\u0015\u0007m\u000bI\u0001C\u0004\u0002\f9\u0001\r!!\u0004\u0002\u0013Q\f7o[*uCR,\u0007c\u0001\"\u0002\u0010%\u0019\u0011\u0011C\n\u0003\u0013Q\u000b7o[*uCR,\u0017A\u0003:fG>\u0014HmU3f]R\t1,\u0001\u0006d_6l\u0017\u000e\u001e+bg.$2a[A\u000e\u0011\u001d\tY\u0001\u0005a\u0001\u0003\u001b\t\u0011\"\u00192peR$\u0016m]6\u0015\u0007m\u000b\t\u0003C\u0004\u0002\fE\u0001\r!!\u0004")
public class OpenSearchCommitProtocol
implements Serializable {
    private transient Log logger;
    private final transient MetadataLog<OpenSearchSinkStatus[]> commitLog;
    private transient long recordsWritten;
    private transient long executionStart;
    private volatile transient boolean bitmap$trans$0;

    public MetadataLog<OpenSearchSinkStatus[]> commitLog() {
        return this.commitLog;
    }

    private Log logger$lzycompute() {
        OpenSearchCommitProtocol openSearchCommitProtocol = this;
        synchronized (openSearchCommitProtocol) {
            if (!this.bitmap$trans$0) {
                this.logger = LogFactory.getLog(OpenSearchCommitProtocol.class);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Log logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void initJob(JobState jobState) {
        Assert.notNull(this.commitLog(), "commitLog cannot be null");
    }

    public void commitJob(JobState jobState, Seq<TaskCommit> taskCommits) {
        OpenSearchSinkStatus[] commits = (OpenSearchSinkStatus[])((IterableOnceOps)taskCommits.flatMap((Function1 & Serializable)x$1 -> x$1.statuses())).toArray(ClassTag$.MODULE$.apply(OpenSearchSinkStatus.class));
        if (!this.commitLog().add(jobState.batchId(), (Object)commits)) {
            throw new IllegalStateException(new StringBuilder(32).append("Batch Id [").append(jobState.batchId()).append("] is already committed").toString());
        }
        this.logger().debug((Object)new StringBuilder(16).append("Committed batch ").append(jobState.batchId()).toString());
    }

    public void abortJob(JobState jobState) {
    }

    public long recordsWritten() {
        return this.recordsWritten;
    }

    public void recordsWritten_$eq(long x$1) {
        this.recordsWritten = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public void executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void initTask(TaskState taskState) {
        this.recordsWritten_$eq(0L);
        this.executionStart_$eq(System.currentTimeMillis());
    }

    public void recordSeen() {
        this.recordsWritten_$eq(this.recordsWritten() + 1L);
    }

    public TaskCommit commitTask(TaskState taskState) {
        return this.recordsWritten() > 0L ? new TaskCommit((Option<OpenSearchSinkStatus>)new Some((Object)new OpenSearchSinkStatus(taskState.taskId(), this.executionStart(), taskState.resource(), this.recordsWritten()))) : new TaskCommit((Option<OpenSearchSinkStatus>)None$.MODULE$);
    }

    public void abortTask(TaskState taskState) {
    }

    public OpenSearchCommitProtocol(MetadataLog<OpenSearchSinkStatus[]> commitLog) {
        this.commitLog = commitLog;
    }
}

